/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import io.netty.channel.Channel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;

public class JpsNettyClient {
    private final UUID mySessionId;
    private final Channel myChannel;
    private final AtomicInteger currentDownloadsCount;

    public JpsNettyClient(@NotNull Channel channel, @NotNull UUID sessionId) {
        if (channel == null) {
            JpsNettyClient.$$$reportNull$$$0(0);
        }
        if (sessionId == null) {
            JpsNettyClient.$$$reportNull$$$0(1);
        }
        this.myChannel = channel;
        this.mySessionId = sessionId;
        this.currentDownloadsCount = new AtomicInteger();
    }

    public void sendDescriptionStatusMessage(@NotNull String message) {
        if (message == null) {
            JpsNettyClient.$$$reportNull$$$0(2);
        }
        this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCacheDownloadMessage(message)));
    }

    public void sendDescriptionStatusMessage(@NotNull String message, int expectedDownloads) {
        if (message == null) {
            JpsNettyClient.$$$reportNull$$$0(3);
        }
        int currentDownloads = this.currentDownloadsCount.incrementAndGet();
        if (expectedDownloads == 0) {
            this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCacheDownloadMessage(message)));
        } else {
            int doubleExpectedDownloads = expectedDownloads * 2 + 1000;
            this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCacheDownloadMessageWithProgress(message, (float)currentDownloads / (float)doubleExpectedDownloads)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendDownloadStatisticMessage(@NotNull String latestDownloadCommit, long decompressionTimeBytesPesSec, long l) {
        void deletionTimeBytesPerSec;
        if (latestDownloadCommit == null) {
            JpsNettyClient.$$$reportNull$$$0(4);
        }
        this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createSaveDownloadStatisticMessage(latestDownloadCommit, decompressionTimeBytesPesSec, (long)deletionTimeBytesPerSec)));
    }

    public static void saveLatestBuiltCommit(@NotNull Channel channel, @NotNull UUID sessionId) {
        if (channel == null) {
            JpsNettyClient.$$$reportNull$$$0(5);
        }
        if (sessionId == null) {
            JpsNettyClient.$$$reportNull$$$0(6);
        }
        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(sessionId, CmdlineProtoUtil.createSaveLatestBuiltCommitMessage()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latestDownloadCommit";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/cache/client/JpsNettyClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendDescriptionStatusMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sendDownloadStatisticMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "saveLatestBuiltCommit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

