/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class NotNullInstrumentingBuilder
extends BaseInstrumentingBuilder {
    private static final Logger LOG = Logger.getInstance(NotNullInstrumentingBuilder.class);
    private boolean myIsEnabled;
    private String[] myNotNulls;

    @Override
    public void buildStarted(CompileContext context) {
        ProjectDescriptor pd = context.getProjectDescriptor();
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(pd.getProject());
        this.myIsEnabled = config.isAddNotNullAssertions();
        this.myNotNulls = ArrayUtilRt.toStringArray((Collection)config.getNotNullAnnotations());
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = JpsBuildBundle.message("builder.name.notnull.instrumentation", new Object[0]);
        if (string == null) {
            NotNullInstrumentingBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected String getProgressMessage() {
        return JpsBuildBundle.message("progress.message.adding.notnull.assertions", new Object[0]);
    }

    @Override
    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        return this.myIsEnabled;
    }

    @Override
    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return (classFileVersion & 0xFFFF) >= 49 && !"module-info".equals(compiledClass.getClassName());
    }

    @Override
    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiledClass, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        try {
            if (NotNullVerifyingInstrumenter.processClassFile((ClassReader)reader, (ClassVisitor)writer, (String[])this.myNotNulls)) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (Throwable e) {
            LOG.error(e);
            Collection<File> sourceFiles = compiledClass.getSourceFiles();
            String msg = JpsBuildBundle.message("build.message.cannot.instrument.0.1", ContainerUtil.map(sourceFiles, file -> file.getName()), e.getMessage());
            context.processMessage(new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, msg, (String)ContainerUtil.getFirstItem(compiledClass.getSourceFilesPaths())));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/instrumentation/NotNullInstrumentingBuilder", "getPresentableName"));
    }
}

