/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.ProjectStamps;

public final class OutputToTargetRegistry
extends AbstractStateStorage<Integer, IntSet> {
    private final PathRelativizerService myRelativizer;
    private static final DataExternalizer<IntSet> DATA_EXTERNALIZER = new DataExternalizer<IntSet>(){

        public void save(@NotNull DataOutput out, IntSet value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            IntIterator iterator = value.iterator();
            while (iterator.hasNext()) {
                out.writeInt(iterator.nextInt());
            }
        }

        public IntSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            IntOpenHashSet result = new IntOpenHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(in.readInt());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    OutputToTargetRegistry(File storePath, PathRelativizerService relativizer) throws IOException {
        super(storePath, EnumeratorIntegerDescriptor.INSTANCE, DATA_EXTERNALIZER);
        this.myRelativizer = relativizer;
    }

    void addMapping(String outputPath, int buildTargetId) throws IOException {
        this.addMapping(Collections.singleton(outputPath), buildTargetId);
    }

    void addMapping(Collection<String> outputPaths, int buildTargetId) throws IOException {
        IntOpenHashSet set = new IntOpenHashSet();
        set.add(buildTargetId);
        for (String outputPath : outputPaths) {
            this.appendData(this.pathHashCode(outputPath), set);
        }
    }

    public void removeMapping(String outputPath, int buildTargetId) throws IOException {
        this.removeMapping(Collections.singleton(outputPath), buildTargetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(Collection<String> outputPaths, int buildTargetId) throws IOException {
        if (outputPaths.isEmpty()) {
            return;
        }
        for (String outputPath : outputPaths) {
            int key = this.pathHashCode(outputPath);
            Object object = this.myDataLock;
            synchronized (object) {
                IntSet state = (IntSet)this.getState(key);
                if (state != null) {
                    boolean removed = state.remove(buildTargetId);
                    if (state.isEmpty()) {
                        this.remove(key);
                    } else if (removed) {
                        this.update(key, state);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getSafeToDeleteOutputs(Collection<String> outputPaths, int currentTargetId) throws IOException {
        int size = outputPaths.size();
        if (size == 0) {
            return outputPaths;
        }
        ArrayList<String> result = new ArrayList<String>(size);
        for (String outputPath : outputPaths) {
            int key = this.pathHashCode(outputPath);
            Object object = this.myDataLock;
            synchronized (object) {
                IntSet associatedTargets = (IntSet)this.getState(key);
                if (associatedTargets == null || associatedTargets.size() != 1) {
                    continue;
                }
                if (associatedTargets.contains(currentTargetId)) {
                    result.add(outputPath);
                }
            }
        }
        return result;
    }

    private int pathHashCode(@NotNull String path) {
        if (path == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(0);
        }
        String relativePath = this.myRelativizer.toRelative(path);
        if (ProjectStamps.PORTABLE_CACHES) {
            return StringUtil.isEmpty((String)relativePath) ? 0 : FileUtil.toCanonicalPath((String)relativePath).hashCode();
        }
        return FileUtil.pathHashCode((String)relativePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry", "pathHashCode"));
    }
}

