/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template;

import com.android.tools.idea.wizard.template.AssetNameConverterKt;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\b\u0010\r\u001a\u00020\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/wizard/template/AssetNameConverter;", "", "type", "Lcom/android/tools/idea/wizard/template/AssetNameConverter$Type;", "name", "", "(Lcom/android/tools/idea/wizard/template/AssetNameConverter$Type;Ljava/lang/String;)V", "layoutPrefixOverride", "layoutPrefixWithTrailingUnderscore", "getLayoutPrefixWithTrailingUnderscore", "()Ljava/lang/String;", "getValue", "overrideLayoutPrefix", "toClassName", "Type", "intellij.android.wizardTemplate.plugin"})
public final class AssetNameConverter {
    @NotNull
    private final Type type;
    @NotNull
    private final String name;
    @Nullable
    private String layoutPrefixOverride;

    public AssetNameConverter(@NotNull Type type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.type = type;
        this.name = name;
    }

    private final String getLayoutPrefixWithTrailingUnderscore() {
        return (this.layoutPrefixOverride == null ? "activity" : this.layoutPrefixOverride) + "_";
    }

    private final String toClassName() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> AssetNameConverterKt.access$stripActivitySuffix(TemplateHelpersKt.toUpperCamelCase(this.name));
            case 2 -> {
                String layoutPrefix = this.getLayoutPrefixWithTrailingUnderscore();
                String layoutName = this.name;
                if (StringsKt.startsWith$default((String)layoutName, (String)layoutPrefix, (boolean)false, (int)2, null)) {
                    String v1 = layoutName.substring(layoutPrefix.length());
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).substring(startIndex)");
                    layoutName = v1;
                }
                yield TemplateHelpersKt.underscoreToCamelCase(layoutName);
            }
            case 3 -> TemplateHelpersKt.underscoreToCamelCase(this.name);
            case 4 -> {
                void var1_2;
                String className = null;
                className = this.name;
                String[] $this$forEach$iv = AssetNameConverterKt.getSTRIP_CLASS_SUFFIXES();
                boolean $i$f$forEach = false;
                int var5_7 = $this$forEach$iv.length;
                for (int var4_6 = 0; var4_6 < var5_7; ++var4_6) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[var4_6];
                    boolean $i$a$-forEach-AssetNameConverter$toClassName$1 = false;
                    className = AssetNameConverterKt.stripSuffix(className, it, true);
                }
                if (this.layoutPrefixOverride != null) {
                    String v2 = this.layoutPrefixOverride;
                    Intrinsics.checkNotNull((Object)v2);
                    String prefixAsSuffix = TemplateHelpersKt.underscoreToCamelCase(v2);
                    className = AssetNameConverterKt.stripSuffix$default(className, prefixAsSuffix, false, 2, null);
                }
                yield var1_2;
            }
            case 5 -> AssetNameConverterKt.access$stripFragmentSuffix(this.name);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final AssetNameConverter overrideLayoutPrefix(@Nullable String layoutPrefixOverride) {
        this.layoutPrefixOverride = layoutPrefixOverride;
        return this;
    }

    @NotNull
    public final String getValue(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (type == Type.FRAGMENT) {
            this.overrideLayoutPrefix("fragment");
        }
        String className = this.toClassName();
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                String v0 = TemplateHelpersKt.extractClassName(className);
                if (v0 == null) {
                    v0 = "Main";
                }
                String activityName = v0;
                yield activityName + "Activity";
            }
            case 2 -> {
                String layoutPrefix = this.getLayoutPrefixWithTrailingUnderscore();
                String layoutName = TemplateHelpersKt.camelCaseToUnderlines(className);
                yield layoutPrefix + StringsKt.replaceFirst((String)layoutName, (String)layoutPrefix, (String)"", (boolean)false);
            }
            case 3 -> TemplateHelpersKt.camelCaseToUnderlines(className);
            case 4 -> className;
            case 5 -> {
                String v2 = TemplateHelpersKt.extractClassName(className);
                if (v2 == null) {
                    v2 = "Main";
                }
                String fragmentName = v2;
                yield fragmentName + "Fragment";
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/wizard/template/AssetNameConverter$Type;", "", "(Ljava/lang/String;I)V", "ACTIVITY", "LAYOUT", "CLASS_NAME", "RESOURCE", "FRAGMENT", "intellij.android.wizardTemplate.plugin"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type ACTIVITY = new Type();
        public static final /* enum */ Type LAYOUT = new Type();
        public static final /* enum */ Type CLASS_NAME = new Type();
        public static final /* enum */ Type RESOURCE = new Type();
        public static final /* enum */ Type FRAGMENT = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.ACTIVITY, Type.LAYOUT, Type.CLASS_NAME, Type.RESOURCE, Type.FRAGMENT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.ACTIVITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LAYOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RESOURCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.CLASS_NAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.FRAGMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

