/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.cppGameActivity.src;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"rendererCpp", "", "rendererH", "intellij.android.wizardTemplate.impl"})
public final class RendererCppKt {
    @NotNull
    public static final String rendererCpp() {
        return "\n#include \"Renderer.h\"\n\n#include <game-activity/native_app_glue/android_native_app_glue.h>\n#include <GLES3/gl3.h>\n#include <memory>\n#include <vector>\n#include <android/imagedecoder.h>\n\n#include \"AndroidOut.h\"\n#include \"Shader.h\"\n#include \"Utility.h\"\n#include \"TextureAsset.h\"\n\n//! executes glGetString and outputs the result to logcat\n#define PRINT_GL_STRING(s) {aout << #s\": \"<< glGetString(s) << std::endl;}\n\n/*!\n * @brief if glGetString returns a space separated list of elements, prints each one on a new line\n *\n * This works by creating an istringstream of the input c-style string. Then that is used to create\n * a vector -- each element of the vector is a new element in the input string. Finally a foreach\n * loop consumes this and outputs it to logcat using @a aout\n */\n#define PRINT_GL_STRING_AS_LIST(s) { \\\nstd::istringstream extensionStream((const char *) glGetString(s));\\\nstd::vector<std::string> extensionList(\\\n        std::istream_iterator<std::string>{extensionStream},\\\n        std::istream_iterator<std::string>());\\\naout << #s\":\\n\";\\\nfor (auto& extension: extensionList) {\\\n    aout << extension << \"\\n\";\\\n}\\\naout << std::endl;\\\n}\n\n//! Color for cornflower blue. Can be sent directly to glClearColor\n#define CORNFLOWER_BLUE 100 / 255.f, 149 / 255.f, 237 / 255.f, 1\n\n// Vertex shader, you'd typically load this from assets\nstatic const char *vertex = R\"vertex(#version 300 es\nin vec3 inPosition;\nin vec2 inUV;\n\nout vec2 fragUV;\n\nuniform mat4 uProjection;\n\nvoid main() {\n    fragUV = inUV;\n    gl_Position = uProjection * vec4(inPosition, 1.0);\n}\n)vertex\";\n\n// Fragment shader, you'd typically load this from assets\nstatic const char *fragment = R\"fragment(#version 300 es\nprecision mediump float;\n\nin vec2 fragUV;\n\nuniform sampler2D uTexture;\n\nout vec4 outColor;\n\nvoid main() {\n    outColor = texture(uTexture, fragUV);\n}\n)fragment\";\n\n/*!\n * Half the height of the projection matrix. This gives you a renderable area of height 4 ranging\n * from -2 to 2\n */\nstatic constexpr float kProjectionHalfHeight = 2.f;\n\n/*!\n * The near plane distance for the projection matrix. Since this is an orthographic projection\n * matrix, it's convenient to have negative values for sorting (and avoiding z-fighting at 0).\n */\nstatic constexpr float kProjectionNearPlane = -1.f;\n\n/*!\n * The far plane distance for the projection matrix. Since this is an orthographic porjection\n * matrix, it's convenient to have the far plane equidistant from 0 as the near plane.\n */\nstatic constexpr float kProjectionFarPlane = 1.f;\n\nRenderer::~Renderer() {\n    if (display_ != EGL_NO_DISPLAY) {\n        eglMakeCurrent(display_, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);\n        if (context_ != EGL_NO_CONTEXT) {\n            eglDestroyContext(display_, context_);\n            context_ = EGL_NO_CONTEXT;\n        }\n        if (surface_ != EGL_NO_SURFACE) {\n            eglDestroySurface(display_, surface_);\n            surface_ = EGL_NO_SURFACE;\n        }\n        eglTerminate(display_);\n        display_ = EGL_NO_DISPLAY;\n    }\n}\n\nvoid Renderer::render() {\n    // Check to see if the surface has changed size. This is _necessary_ to do every frame when\n    // using immersive mode as you'll get no other notification that your renderable area has\n    // changed.\n    updateRenderArea();\n\n    // When the renderable area changes, the projection matrix has to also be updated. This is true\n    // even if you change from the sample orthographic projection matrix as your aspect ratio has\n    // likely changed.\n    if (shaderNeedsNewProjectionMatrix_) {\n        // a placeholder projection matrix allocated on the stack. Column-major memory layout\n        float projectionMatrix[16] = {0};\n\n        // build an orthographic projection matrix for 2d rendering\n        Utility::buildOrthographicMatrix(\n                projectionMatrix,\n                kProjectionHalfHeight,\n                float(width_) / height_,\n                kProjectionNearPlane,\n                kProjectionFarPlane);\n\n        // send the matrix to the shader\n        // Note: the shader must be active for this to work. Since we only have one shader for this\n        // demo, we can assume that it's active.\n        shader_->setProjectionMatrix(projectionMatrix);\n\n        // make sure the matrix isn't generated every frame\n        shaderNeedsNewProjectionMatrix_ = false;\n    }\n\n    // clear the color buffer\n    glClear(GL_COLOR_BUFFER_BIT);\n\n    // Render all the models. There's no depth testing in this sample so they're accepted in the\n    // order provided. But the sample EGL setup requests a 24 bit depth buffer so you could\n    // configure it at the end of initRenderer\n    if (!models_.empty()) {\n        for (const auto &model: models_) {\n            shader_->drawModel(model);\n        }\n    }\n\n    // Present the rendered image. This is an implicit glFlush.\n    auto swapResult = eglSwapBuffers(display_, surface_);\n    assert(swapResult == EGL_TRUE);\n}\n\nvoid Renderer::initRenderer() {\n    // Choose your render attributes\n    constexpr EGLint attribs[] = {\n            EGL_RENDERABLE_TYPE, EGL_OPENGL_ES3_BIT,\n            EGL_SURFACE_TYPE, EGL_WINDOW_BIT,\n            EGL_BLUE_SIZE, 8,\n            EGL_GREEN_SIZE, 8,\n            EGL_RED_SIZE, 8,\n            EGL_DEPTH_SIZE, 24,\n            EGL_NONE\n    };\n\n    // The default display is probably what you want on Android\n    auto display = eglGetDisplay(EGL_DEFAULT_DISPLAY);\n    eglInitialize(display, nullptr, nullptr);\n\n    // figure out how many configs there are\n    EGLint numConfigs;\n    eglChooseConfig(display, attribs, nullptr, 0, &numConfigs);\n\n    // get the list of configurations\n    std::unique_ptr<EGLConfig[]> supportedConfigs(new EGLConfig[numConfigs]);\n    eglChooseConfig(display, attribs, supportedConfigs.get(), numConfigs, &numConfigs);\n\n    // Find a config we like.\n    // Could likely just grab the first if we don't care about anything else in the config.\n    // Otherwise hook in your own heuristic\n    auto config = *std::find_if(\n            supportedConfigs.get(),\n            supportedConfigs.get() + numConfigs,\n            [&display](const EGLConfig &config) {\n                EGLint red, green, blue, depth;\n                if (eglGetConfigAttrib(display, config, EGL_RED_SIZE, &red)\n                    && eglGetConfigAttrib(display, config, EGL_GREEN_SIZE, &green)\n                    && eglGetConfigAttrib(display, config, EGL_BLUE_SIZE, &blue)\n                    && eglGetConfigAttrib(display, config, EGL_DEPTH_SIZE, &depth)) {\n\n                    aout << \"Found config with \" << red << \", \" << green << \", \" << blue << \", \"\n                         << depth << std::endl;\n                    return red == 8 && green == 8 && blue == 8 && depth == 24;\n                }\n                return false;\n            });\n\n    aout << \"Found \" << numConfigs << \" configs\" << std::endl;\n    aout << \"Chose \" << config << std::endl;\n\n    // create the proper window surface\n    EGLint format;\n    eglGetConfigAttrib(display, config, EGL_NATIVE_VISUAL_ID, &format);\n    EGLSurface surface = eglCreateWindowSurface(display, config, app_->window, nullptr);\n\n    // Create a GLES 3 context\n    EGLint contextAttribs[] = {EGL_CONTEXT_CLIENT_VERSION, 3, EGL_NONE};\n    EGLContext context = eglCreateContext(display, config, nullptr, contextAttribs);\n\n    // get some window metrics\n    auto madeCurrent = eglMakeCurrent(display, surface, surface, context);\n    assert(madeCurrent);\n\n    display_ = display;\n    surface_ = surface;\n    context_ = context;\n\n    // make width and height invalid so it gets updated the first frame in @a updateRenderArea()\n    width_ = -1;\n    height_ = -1;\n\n    PRINT_GL_STRING(GL_VENDOR);\n    PRINT_GL_STRING(GL_RENDERER);\n    PRINT_GL_STRING(GL_VERSION);\n    PRINT_GL_STRING_AS_LIST(GL_EXTENSIONS);\n\n    shader_ = std::unique_ptr<Shader>(\n            Shader::loadShader(vertex, fragment, \"inPosition\", \"inUV\", \"uProjection\"));\n    assert(shader_);\n\n    // Note: there's only one shader in this demo, so I'll activate it here. For a more complex game\n    // you'll want to track the active shader and activate/deactivate it as necessary\n    shader_->activate();\n\n    // setup any other gl related global states\n    glClearColor(CORNFLOWER_BLUE);\n\n    // enable alpha globally for now, you probably don't want to do this in a game\n    glEnable(GL_BLEND);\n    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);\n\n    // get some demo models into memory\n    createModels();\n}\n\nvoid Renderer::updateRenderArea() {\n    EGLint width;\n    eglQuerySurface(display_, surface_, EGL_WIDTH, &width);\n\n    EGLint height;\n    eglQuerySurface(display_, surface_, EGL_HEIGHT, &height);\n\n    if (width != width_ || height != height_) {\n        width_ = width;\n        height_ = height;\n        glViewport(0, 0, width, height);\n\n        // make sure that we lazily recreate the projection matrix before we render\n        shaderNeedsNewProjectionMatrix_ = true;\n    }\n}\n\n/**\n * @brief Create any demo models we want for this demo.\n */\nvoid Renderer::createModels() {\n    /*\n     * This is a square:\n     * 0 --- 1\n     * | \\   |\n     * |  \\  |\n     * |   \\ |\n     * 3 --- 2\n     */\n    std::vector<Vertex> vertices = {\n            Vertex(Vector3{1, 1, 0}, Vector2{0, 0}), // 0\n            Vertex(Vector3{-1, 1, 0}, Vector2{1, 0}), // 1\n            Vertex(Vector3{-1, -1, 0}, Vector2{1, 1}), // 2\n            Vertex(Vector3{1, -1, 0}, Vector2{0, 1}) // 3\n    };\n    std::vector<Index> indices = {\n            0, 1, 2, 0, 2, 3\n    };\n\n    // loads an image and assigns it to the square.\n    //\n    // Note: there is no texture management in this sample, so if you reuse an image be careful not\n    // to load it repeatedly. Since you get a shared_ptr you can safely reuse it in many models.\n    auto assetManager = app_->activity->assetManager;\n    auto spAndroidRobotTexture = TextureAsset::loadAsset(assetManager, \"android_robot.png\");\n\n    // Create a model and put it in the back of the render list.\n    models_.emplace_back(vertices, indices, spAndroidRobotTexture);\n}\n\nvoid Renderer::handleInput() {\n    // handle all queued inputs\n    auto *inputBuffer = android_app_swap_input_buffers(app_);\n    if (!inputBuffer) {\n        // no inputs yet.\n        return;\n    }\n\n    // handle motion events (motionEventsCounts can be 0).\n    for (auto i = 0; i < inputBuffer->motionEventsCount; i++) {\n        auto &motionEvent = inputBuffer->motionEvents[i];\n        auto action = motionEvent.action;\n\n        // Find the pointer index, mask and bitshift to turn it into a readable value.\n        auto pointerIndex = (action & AMOTION_EVENT_ACTION_POINTER_INDEX_MASK)\n                >> AMOTION_EVENT_ACTION_POINTER_INDEX_SHIFT;\n        aout << \"Pointer(s): \";\n\n        // get the x and y position of this event if it is not ACTION_MOVE.\n        auto &pointer = motionEvent.pointers[pointerIndex];\n        auto x = GameActivityPointerAxes_getX(&pointer);\n        auto y = GameActivityPointerAxes_getY(&pointer);\n\n        // determine the action type and process the event accordingly.\n        switch (action & AMOTION_EVENT_ACTION_MASK) {\n            case AMOTION_EVENT_ACTION_DOWN:\n            case AMOTION_EVENT_ACTION_POINTER_DOWN:\n                aout << \"(\" << pointer.id << \", \" << x << \", \" << y << \") \"\n                     << \"Pointer Down\";\n                break;\n\n            case AMOTION_EVENT_ACTION_CANCEL:\n                // treat the CANCEL as an UP event: doing nothing in the app, except\n                // removing the pointer from the cache if pointers are locally saved.\n                // code pass through on purpose.\n            case AMOTION_EVENT_ACTION_UP:\n            case AMOTION_EVENT_ACTION_POINTER_UP:\n                aout << \"(\" << pointer.id << \", \" << x << \", \" << y << \") \"\n                     << \"Pointer Up\";\n                break;\n\n            case AMOTION_EVENT_ACTION_MOVE:\n                // There is no pointer index for ACTION_MOVE, only a snapshot of\n                // all active pointers; app needs to cache previous active pointers\n                // to figure out which ones are actually moved.\n                for (auto index = 0; index < motionEvent.pointerCount; index++) {\n                    pointer = motionEvent.pointers[index];\n                    x = GameActivityPointerAxes_getX(&pointer);\n                    y = GameActivityPointerAxes_getY(&pointer);\n                    aout << \"(\" << pointer.id << \", \" << x << \", \" << y << \")\";\n\n                    if (index != (motionEvent.pointerCount - 1)) aout << \",\";\n                    aout << \" \";\n                }\n                aout << \"Pointer Move\";\n                break;\n            default:\n                aout << \"Unknown MotionEvent Action: \" << action;\n        }\n        aout << std::endl;\n    }\n    // clear the motion input count in this buffer for main thread to re-use.\n    android_app_clear_motion_events(inputBuffer);\n\n    // handle input key events.\n    for (auto i = 0; i < inputBuffer->keyEventsCount; i++) {\n        auto &keyEvent = inputBuffer->keyEvents[i];\n        aout << \"Key: \" << keyEvent.keyCode <<\" \";\n        switch (keyEvent.action) {\n            case AKEY_EVENT_ACTION_DOWN:\n                aout << \"Key Down\";\n                break;\n            case AKEY_EVENT_ACTION_UP:\n                aout << \"Key Up\";\n                break;\n            case AKEY_EVENT_ACTION_MULTIPLE:\n                // Deprecated since Android API level 29.\n                aout << \"Multiple Key Actions\";\n                break;\n            default:\n                aout << \"Unknown KeyEvent Action: \" << keyEvent.action;\n        }\n        aout << std::endl;\n    }\n    // clear the key input count too.\n    android_app_clear_key_events(inputBuffer);\n}\n\n";
    }

    @NotNull
    public static final String rendererH() {
        return "\n#ifndef ANDROIDGLINVESTIGATIONS_RENDERER_H\n#define ANDROIDGLINVESTIGATIONS_RENDERER_H\n\n#include <EGL/egl.h>\n#include <memory>\n\n#include \"Model.h\"\n#include \"Shader.h\"\n\nstruct android_app;\n\nclass Renderer {\npublic:\n    /*!\n     * @param pApp the android_app this Renderer belongs to, needed to configure GL\n     */\n    inline Renderer(android_app *pApp) :\n            app_(pApp),\n            display_(EGL_NO_DISPLAY),\n            surface_(EGL_NO_SURFACE),\n            context_(EGL_NO_CONTEXT),\n            width_(0),\n            height_(0),\n            shaderNeedsNewProjectionMatrix_(true) {\n        initRenderer();\n    }\n\n    virtual ~Renderer();\n\n    /*!\n     * Handles input from the android_app.\n     *\n     * Note: this will clear the input queue\n     */\n    void handleInput();\n\n    /*!\n     * Renders all the models in the renderer\n     */\n    void render();\n\nprivate:\n    /*!\n     * Performs necessary OpenGL initialization. Customize this if you want to change your EGL\n     * context or application-wide settings.\n     */\n    void initRenderer();\n\n    /*!\n     * @brief we have to check every frame to see if the framebuffer has changed in size. If it has,\n     * update the viewport accordingly\n     */\n    void updateRenderArea();\n\n    /*!\n     * Creates the models for this sample. You'd likely load a scene configuration from a file or\n     * use some other setup logic in your full game.\n     */\n    void createModels();\n\n    android_app *app_;\n    EGLDisplay display_;\n    EGLSurface surface_;\n    EGLContext context_;\n    EGLint width_;\n    EGLint height_;\n\n    bool shaderNeedsNewProjectionMatrix_;\n\n    std::unique_ptr<Shader> shader_;\n    std::vector<Model> models_;\n};\n\n\n#endif //ANDROIDGLINVESTIGATIONS_RENDERER_H\n";
    }
}

