/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.cppGameActivity.src;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"utilityCpp", "", "utilityH", "intellij.android.wizardTemplate.impl"})
public final class UtilityCppKt {
    @NotNull
    public static final String utilityCpp() {
        return "\n#include \"Utility.h\"\n#include \"AndroidOut.h\"\n\n#include <GLES3/gl3.h>\n\n#define CHECK_ERROR(e) case e: aout << \"GL Error: \"#e << std::endl; break;\n\nbool Utility::checkAndLogGlError(bool alwaysLog) {\n    GLenum error = glGetError();\n    if (error == GL_NO_ERROR) {\n        if (alwaysLog) {\n            aout << \"No GL error\" << std::endl;\n        }\n        return true;\n    } else {\n        switch (error) {\n            CHECK_ERROR(GL_INVALID_ENUM);\n            CHECK_ERROR(GL_INVALID_VALUE);\n            CHECK_ERROR(GL_INVALID_OPERATION);\n            CHECK_ERROR(GL_INVALID_FRAMEBUFFER_OPERATION);\n            CHECK_ERROR(GL_OUT_OF_MEMORY);\n            default:\n                aout << \"Unknown GL error: \" << error << std::endl;\n        }\n        return false;\n    }\n}\n\nfloat *\nUtility::buildOrthographicMatrix(float *outMatrix, float halfHeight, float aspect, float near,\n                                 float far) {\n    float halfWidth = halfHeight * aspect;\n\n    // column 1\n    outMatrix[0] = 1.f / halfWidth;\n    outMatrix[1] = 0.f;\n    outMatrix[2] = 0.f;\n    outMatrix[3] = 0.f;\n\n    // column 2\n    outMatrix[4] = 0.f;\n    outMatrix[5] = 1.f / halfHeight;\n    outMatrix[6] = 0.f;\n    outMatrix[7] = 0.f;\n\n    // column 3\n    outMatrix[8] = 0.f;\n    outMatrix[9] = 0.f;\n    outMatrix[10] = -2.f / (far - near);\n    outMatrix[11] = -(far + near) / (far - near);\n\n    // column 4\n    outMatrix[12] = 0.f;\n    outMatrix[13] = 0.f;\n    outMatrix[14] = 0.f;\n    outMatrix[15] = 1.f;\n\n    return outMatrix;\n}\n\nfloat *Utility::buildIdentityMatrix(float *outMatrix) {\n    // column 1\n    outMatrix[0] = 1.f;\n    outMatrix[1] = 0.f;\n    outMatrix[2] = 0.f;\n    outMatrix[3] = 0.f;\n\n    // column 2\n    outMatrix[4] = 0.f;\n    outMatrix[5] = 1.f;\n    outMatrix[6] = 0.f;\n    outMatrix[7] = 0.f;\n\n    // column 3\n    outMatrix[8] = 0.f;\n    outMatrix[9] = 0.f;\n    outMatrix[10] = 1.f;\n    outMatrix[11] = 0.f;\n\n    // column 4\n    outMatrix[12] = 0.f;\n    outMatrix[13] = 0.f;\n    outMatrix[14] = 0.f;\n    outMatrix[15] = 1.f;\n\n    return outMatrix;\n}\n";
    }

    @NotNull
    public static final String utilityH() {
        return "\n#ifndef ANDROIDGLINVESTIGATIONS_UTILITY_H\n#define ANDROIDGLINVESTIGATIONS_UTILITY_H\n\n\n#include <cassert>\n\nclass Utility {\npublic:\n    static bool checkAndLogGlError(bool alwaysLog = false);\n\n    static inline void assertGlError() { assert(checkAndLogGlError()); }\n\n    /**\n     * Generates an orthographic projection matrix given the half height, aspect ratio, near, and far\n     * planes\n     *\n     * @param outMatrix the matrix to write into\n     * @param halfHeight half of the height of the screen\n     * @param aspect the width of the screen divided by the height\n     * @param near the distance of the near plane\n     * @param far the distance of the far plane\n     * @return the generated matrix, this will be the same as @a outMatrix so you can chain calls\n     *     together if needed\n     */\n    static float *buildOrthographicMatrix(\n            float *outMatrix,\n            float halfHeight,\n            float aspect,\n            float near,\n            float far);\n\n    static float *buildIdentityMatrix(float *outMatrix);\n};\n\n\n#endif //ANDROIDGLINVESTIGATIONS_UTILITY_H\n";
    }
}

