/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"checkoutActivityKt", "", "activityClass", "viewModelClass", "layoutName", "packageName", "applicationPackage", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
public final class CheckoutActivityKtKt {
    @NotNull
    public static final String checkoutActivityKt(@NotNull String activityClass2, @NotNull String viewModelClass2, @NotNull String layoutName2, @NotNull String packageName, @Nullable String applicationPackage, boolean isViewBindingSupported) {
        String string;
        Intrinsics.checkNotNullParameter((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)viewModelClass2, (String)"viewModelClass");
        Intrinsics.checkNotNullParameter((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contentViewBlock = isViewBindingSupported ? "\n      // Use view binding to access the UI elements\n      layoutBinding = " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + ".inflate(layoutInflater)\n      setContentView(layoutBinding.root)\n  " : "setContentView(R.layout." + layoutName2 + ")";
        String googlePayButtonBlock = isViewBindingSupported ? "googlePayButton = layoutBinding.googlePayButton.root" : "googlePayButton = findViewById<View>(R.id.googlePayButton)";
        String string2 = TemplateHelpersKt.escapeKotlinIdentifier(packageName);
        String string3 = packageName;
        String string4 = packageName;
        String string5 = viewModelClass2;
        String string6 = ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName2, Language.Kotlin);
        String string7 = activityClass2;
        String string8 = viewModelClass2;
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isViewBindingSupported) {
            String string9 = string8;
            String string10 = string7;
            String string11 = string6;
            String string12 = string5;
            String string13 = string4;
            String string14 = string3;
            String string15 = string2;
            boolean bl = false;
            String string16 = "\n      private lateinit var layoutBinding: " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + "\n    ";
            string2 = string15;
            string3 = string14;
            string4 = string13;
            string5 = string12;
            string6 = string11;
            string7 = string10;
            string8 = string9;
            string = ((Object)StringsKt.trim((CharSequence)string16)).toString();
        } else {
            String string17;
            String it$iv = string17 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            boolean bl = false;
            string = string17;
            if (string == null) {
                string = "";
            }
        }
        return "\npackage " + string2 + "\n\nimport android.content.Intent\nimport android.os.Bundle\nimport android.util.Log\nimport android.view.View\nimport android.widget.Toast\nimport androidx.activity.viewModels\nimport androidx.appcompat.app.AppCompatActivity\nimport androidx.lifecycle.Observer\n\nimport com.google.android.gms.wallet.*\nimport org.json.JSONException\nimport org.json.JSONObject\n\nimport " + string3 + ".R\nimport " + string4 + ".viewmodel." + string5 + "\n" + string6 + "\n\n/**\n * Checkout implementation for the app\n */\nclass " + string7 + " : AppCompatActivity() {\n\n    // Arbitrarily-picked constant integer you define to track a request for payment data activity.\n    private val loadPaymentDataRequestCode = 991\n\n    private val model: " + string8 + " by viewModels()\n\n    " + string + "\n    private lateinit var googlePayButton: View\n\n    /**\n     * Initialize the Google Pay API on creation of the activity\n     *\n     * @see AppCompatActivity.onCreate\n     */\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        " + contentViewBlock + "\n\n        " + googlePayButtonBlock + "\n        googlePayButton.setOnClickListener { requestPayment() }\n\n        // Check whether Google Pay can be used to complete a payment\n        model.canUseGooglePay.observe(this, Observer(::setGooglePayAvailable))\n    }\n\n    /**\n     * If isReadyToPay returned `true`, show the button and hide the \"checking\" text. Otherwise,\n     * notify the user that Google Pay is not available. Please adjust to fit in with your current\n     * user flow. You are not required to explicitly let the user know if isReadyToPay returns `false`.\n     *\n     * @param available isReadyToPay API response.\n     */\n    private fun setGooglePayAvailable(available: Boolean) {\n        if (available) {\n            googlePayButton.visibility = View.VISIBLE\n        } else {\n            Toast.makeText(\n                    this,\n                    \"Unfortunately, Google Pay is not available on this device\",\n                    Toast.LENGTH_LONG).show()\n        }\n    }\n\n    private fun requestPayment() {\n\n        // Disables the button to prevent multiple clicks.\n        googlePayButton.isClickable = false\n\n        // The price provided to the API should include taxes and shipping.\n        // This price is not displayed to the user.\n        val dummyPriceCents = 100L\n        val shippingCostCents = 900L\n        val task = model.getLoadPaymentDataTask(dummyPriceCents + shippingCostCents)\n\n        // Shows the payment sheet and forwards the result to the onActivityResult method.\n        AutoResolveHelper.resolveTask(task, this, loadPaymentDataRequestCode)\n    }\n\n    /**\n     * Handle a resolved activity from the Google Pay payment sheet.\n     *\n     * @param requestCode Request code originally supplied to AutoResolveHelper in requestPayment().\n     * @param resultCode Result code returned by the Google Pay API.\n     * @param data Intent from the Google Pay API containing payment or error data.\n     * @see [Getting a result\n     * from an Activity](https://developer.android.com/training/basics/intents/result)\n     */\n    @Suppress(\"Deprecation\")\n    // Suppressing deprecation until `registerForActivityResult` is available on the Google Pay API.\n    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {\n        super.onActivityResult(requestCode, resultCode, data)\n        when (requestCode) {\n            // Value passed in AutoResolveHelper\n            loadPaymentDataRequestCode -> {\n                when (resultCode) {\n                    RESULT_OK ->\n                        data?.let { intent ->\n                            PaymentData.getFromIntent(intent)?.let(::handlePaymentSuccess)\n                        }\n\n                    RESULT_CANCELED -> {\n                        // The user cancelled the payment attempt\n                    }\n\n                    AutoResolveHelper.RESULT_ERROR -> {\n                        AutoResolveHelper.getStatusFromIntent(data)?.let {\n                            handleError(it.statusCode)\n                        }\n                    }\n                }\n\n                // Re-enables the Google Pay payment button.\n                googlePayButton.isClickable = true\n            }\n        }\n    }\n\n    /**\n     * PaymentData response object contains the payment information, as well as any additional\n     * requested information, such as billing and shipping address.\n     *\n     * @param paymentData A response object returned by Google after a payer approves payment.\n     * @see [Payment\n     * Data](https://developers.google.com/pay/api/android/reference/object.PaymentData)\n     */\n    private fun handlePaymentSuccess(paymentData: PaymentData) {\n        val paymentInformation = paymentData.toJson() ?: return\n\n        try {\n            // Token will be null if PaymentDataRequest was not constructed using fromJson(String).\n            val paymentMethodData = JSONObject(paymentInformation).getJSONObject(\"paymentMethodData\")\n            val billingName = paymentMethodData.getJSONObject(\"info\")\n                    .getJSONObject(\"billingAddress\").getString(\"name\")\n            Log.d(\"BillingName\", billingName)\n\n            Toast.makeText(this, getString(R.string.payments_show_name, billingName), Toast.LENGTH_LONG).show()\n\n            // Logging token string.\n            Log.d(\"GooglePaymentToken\", paymentMethodData\n                    .getJSONObject(\"tokenizationData\")\n                    .getString(\"token\"))\n\n        } catch (error: JSONException) {\n            Log.e(\"handlePaymentSuccess\", \"Error: $error\")\n        }\n    }\n\n    /**\n     * At this stage, the user has already seen a popup informing them an error occurred. Normally,\n     * only logging is required.\n     *\n     * @param statusCode will hold the value of any constant from CommonStatusCode or one of the\n     * WalletConstants.ERROR_CODE_* constants.\n     * @see [\n     * Wallet Constants Library](https://developers.google.com/android/reference/com/google/android/gms/wallet/WalletConstants.constant-summary)\n     */\n    private fun handleError(statusCode: Int) {\n        Log.w(\"loadPaymentData failed\", \"Error code: $statusCode\")\n    }\n}\n";
    }
}

