/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"checkoutViewModelJava", "", "viewModelClass", "packageName", "intellij.android.wizardTemplate.impl"})
public final class CheckoutViewModelJavaKt {
    @NotNull
    public static final String checkoutViewModelJava(@NotNull String viewModelClass2, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)viewModelClass2, (String)"viewModelClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + packageName + ".viewmodel;\n\nimport android.app.Application;\nimport android.util.Log;\n\nimport androidx.annotation.NonNull;\nimport androidx.lifecycle.AndroidViewModel;\nimport androidx.lifecycle.LiveData;\nimport androidx.lifecycle.MutableLiveData;\n\nimport com.google.android.gms.tasks.Task;\nimport com.google.android.gms.wallet.IsReadyToPayRequest;\nimport com.google.android.gms.wallet.PaymentData;\nimport com.google.android.gms.wallet.PaymentDataRequest;\nimport com.google.android.gms.wallet.PaymentsClient;\n\nimport org.json.JSONObject;\n\nimport " + packageName + ".util.PaymentsUtil;\n\npublic class " + viewModelClass2 + " extends AndroidViewModel {\n\n    // A client for interacting with the Google Pay API.\n    private final PaymentsClient paymentsClient;\n\n    // LiveData with the result of whether the user can pay using Google Pay\n    private final MutableLiveData<Boolean> _canUseGooglePay = new MutableLiveData<>();\n\n    public " + viewModelClass2 + "(@NonNull Application application) {\n        super(application);\n        paymentsClient = PaymentsUtil.createPaymentsClient(application);\n\n        fetchCanUseGooglePay();\n    }\n\n    public final LiveData<Boolean> canUseGooglePay = _canUseGooglePay;\n\n    /**\n     * Determine the user's ability to pay with a payment method supported by your app and display\n     * a Google Pay payment button.\n     */\n    private void fetchCanUseGooglePay() {\n        final JSONObject isReadyToPayJson = PaymentsUtil.getIsReadyToPayRequest();\n        if (isReadyToPayJson == null) {\n            _canUseGooglePay.setValue(false);\n            return;\n        }\n\n        // The call to isReadyToPay is asynchronous and returns a Task. We need to provide an\n        // OnCompleteListener to be triggered when the result of the call is known.\n        IsReadyToPayRequest request = IsReadyToPayRequest.fromJson(isReadyToPayJson.toString());\n        Task<Boolean> task = paymentsClient.isReadyToPay(request);\n        task.addOnCompleteListener(\n                completedTask -> {\n                    if (completedTask.isSuccessful()) {\n                        _canUseGooglePay.setValue(completedTask.getResult());\n                    } else {\n                        Log.w(\"isReadyToPay failed\", completedTask.getException());\n                        _canUseGooglePay.setValue(false);\n                    }\n                });\n    }\n\n    /**\n     * Creates a Task that starts the payment process with the transaction details included.\n     *\n     * @param priceCents the price to show on the payment sheet.\n     * @return a Task with the payment information.\n     * )\n     */\n    public Task<PaymentData> getLoadPaymentDataTask(final long priceCents) {\n        JSONObject paymentDataRequestJson = PaymentsUtil.getPaymentDataRequest(priceCents);\n        if (paymentDataRequestJson == null) {\n            return null;\n        }\n\n        PaymentDataRequest request =\n                PaymentDataRequest.fromJson(paymentDataRequestJson.toString());\n        return paymentsClient.loadPaymentData(request);\n    }\n}\n";
    }
}

