/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googleWalletActivity.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"samplePassKt", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class SamplePassKtKt {
    @NotNull
    public static final String samplePassKt(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport java.util.Date\nimport kotlin.random.Random\n\n/**\n * A helper class that allows us to easily configure the JSON we will be sending to\n * [PayClient.savePasses].\n *\n * If you are using the [temporary issuer](https://wallet-lab-tools.web.app/issuers) tool, then you\n * can use this class with the parameters created on the linked website.\n */\ndata class SamplePass(\n    private val issuerEmail: String,\n    private val issuerId: String,\n    private val passClass: String,\n    private val passId: String\n) {\n    val toJson: String = \"\"\"\n    {\n      \"iss\": \"$issuerEmail\",\n      \"aud\": \"google\",\n      \"typ\": \"savetowallet\",\n      \"iat\": ${Date().time / 1000L},\n      \"origins\": [],\n      \"payload\": {\n        \"genericObjects\": [\n          {\n            \"id\": \"$issuerId.$passId\",\n            \"classId\": \"$passClass\",\n            \"genericType\": \"GENERIC_TYPE_UNSPECIFIED\",\n            \"hexBackgroundColor\": \"#4285f4\",\n            \"logo\": {\n              \"sourceUri\": {\n                \"uri\": \"https://storage.googleapis.com/wallet-lab-tools-codelab-artifacts-public/pass_google_logo.jpg\"\n              }\n            },\n            \"cardTitle\": {\n              \"defaultValue\": {\n                \"language\": \"en\",\n                \"value\": \"Google I/O '22  [DEMO ONLY]\"\n              }\n            },\n            \"subheader\": {\n              \"defaultValue\": {\n                \"language\": \"en\",\n                \"value\": \"Attendee\"\n              }\n            },\n            \"header\": {\n              \"defaultValue\": {\n                \"language\": \"en\",\n                \"value\": \"Nicholas Corder\"\n              }\n            },\n            \"barcode\": {\n              \"type\": \"QR_CODE\",\n              \"value\": \"$passId\"\n            },\n            \"heroImage\": {\n              \"sourceUri\": {\n                \"uri\": \"https://storage.googleapis.com/wallet-lab-tools-codelab-artifacts-public/google-io-hero-demo-only.jpg\"\n              }\n            },\n            \"textModulesData\": [\n              {\n                \"header\": \"POINTS\",\n                \"body\": \"${Random.nextInt(0, 9999)}\",\n                \"id\": \"points\"\n              },\n              {\n                \"header\": \"CONTACTS\",\n                \"body\": \"${Random.nextInt(1, 99)}\",\n                \"id\": \"contacts\"\n              }\n            ]\n          }\n        ]\n      }\n    }\n    \"\"\"\n}\n";
    }
}

