/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.responsiveActivity.src.ui.transform;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"transformFragmentKt", "", "packageName", "applicationPackage", "fragmentClassName", "navFragmentPrefix", "navViewModelClass", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
public final class TransformFragmentKtKt {
    @NotNull
    public static final String transformFragmentKt(@NotNull String packageName, @Nullable String applicationPackage, @NotNull String fragmentClassName, @NotNull String navFragmentPrefix, @NotNull String navViewModelClass, boolean isViewBindingSupported) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fragmentClassName, (String)"fragmentClassName");
        Intrinsics.checkNotNullParameter((Object)navFragmentPrefix, (String)"navFragmentPrefix");
        Intrinsics.checkNotNullParameter((Object)navViewModelClass, (String)"navViewModelClass");
        String layoutName2 = "fragment_transform";
        String bindingName = ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2);
        return "\npackage " + packageName + ".ui." + navFragmentPrefix + "\n\nimport android.os.Bundle\nimport android.view.LayoutInflater\nimport android.view.View\nimport android.view.ViewGroup\nimport android.widget.ImageView\nimport android.widget.TextView\nimport androidx.core.content.res.ResourcesCompat\nimport androidx.fragment.app.Fragment\nimport androidx.lifecycle.ViewModelProvider\nimport androidx.recyclerview.widget.DiffUtil\nimport androidx.recyclerview.widget.ListAdapter\nimport androidx.recyclerview.widget.RecyclerView\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".R\n" + ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName2, Language.Kotlin) + "\n" + ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, "item_transform", Language.Kotlin) + "\n\n/**\n * Fragment that demonstrates a responsive layout pattern where the format of the content\n * transforms depending on the size of the screen. Specifically this Fragment shows items in\n * the [RecyclerView] using LinearLayoutManager in a small screen\n * and shows items using GridLayoutManager in a large screen.\n */\nclass " + fragmentClassName + " : Fragment() {\n\n    private var _binding: " + bindingName + "? = null\n    // This property is only valid between onCreateView and\n    // onDestroyView.\n    private val binding get() = _binding!!\n\n    override fun onCreateView(\n        inflater: LayoutInflater,\n        container: ViewGroup?,\n        savedInstanceState: Bundle?\n    ): View {\n        val " + navFragmentPrefix + "ViewModel = ViewModelProvider(this).get(" + navViewModelClass + "::class.java)\n        _binding = " + bindingName + ".inflate(inflater, container, false)\n        val root: View = binding.root\n\n        val recyclerView = binding.recyclerviewTransform\n        val adapter = TransformAdapter()\n        recyclerView.adapter = adapter\n        " + navFragmentPrefix + "ViewModel.texts.observe(viewLifecycleOwner) {\n            adapter.submitList(it)\n        }\n        return root\n    }\n\n    override fun onDestroyView() {\n        super.onDestroyView()\n        _binding = null\n    }\n\n    class TransformAdapter : ListAdapter<String, TransformViewHolder>(object : DiffUtil.ItemCallback<String>() {\n\n        override fun areItemsTheSame(oldItem: String, newItem: String): Boolean =\n            oldItem == newItem\n\n        override fun areContentsTheSame(oldItem: String, newItem: String): Boolean =\n            oldItem == newItem\n    }) {\n\n        private val drawables = listOf(\n            R.drawable.avatar_1,\n            R.drawable.avatar_2,\n            R.drawable.avatar_3,\n            R.drawable.avatar_4,\n            R.drawable.avatar_5,\n            R.drawable.avatar_6,\n            R.drawable.avatar_7,\n            R.drawable.avatar_8,\n            R.drawable.avatar_9,\n            R.drawable.avatar_10,\n            R.drawable.avatar_11,\n            R.drawable.avatar_12,\n            R.drawable.avatar_13,\n            R.drawable.avatar_14,\n            R.drawable.avatar_15,\n            R.drawable.avatar_16,\n        )\n\n        override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): TransformViewHolder {\n            val binding = ItemTransformBinding.inflate(LayoutInflater.from(parent.context))\n            return TransformViewHolder(binding)\n        }\n\n        override fun onBindViewHolder(holder: TransformViewHolder, position: Int) {\n            holder.textView.text = getItem(position)\n            holder.imageView.setImageDrawable(\n                ResourcesCompat.getDrawable(holder.imageView.resources, drawables[position], null))\n        }\n    }\n\n    class TransformViewHolder(binding: ItemTransformBinding) : RecyclerView.ViewHolder(binding.root) {\n\n        val imageView: ImageView = binding.imageViewItemTransform\n        val textView: TextView = binding.textViewItemTransform\n    }\n}\n";
    }
}

