/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceConverter {
    public static void main(String[] args) throws Exception {
        System.out.println("Parsing input...");
        Map<String, String> map2 = ResourceConverter.loadStrings("./validator/resources/strings.xml");
        System.out.println("Writing to output...");
        ResourceConverter.writeStrings(map2, "./validator/resources/strings.properties");
        System.out.println("Finished converting.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStrings(Map<String, String> map2, String outputPath) throws Exception {
        File output = new File(outputPath);
        output.createNewFile();
        try (FileWriter writer = new FileWriter(output);){
            writer.write(ResourceConverter.getCopyRight());
            writer.write("\n");
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String name = entry.getKey();
                String value2 = entry.getValue();
                writer.write(name + " = " + value2 + "\n");
            }
        }
    }

    private static Map<String, String> loadStrings(String path) throws Exception {
        LinkedHashMap<String, String> toReturn = new LinkedHashMap<String, String>();
        File file2 = new File(path);
        if (!file2.exists()) {
            System.err.println("The input file " + path + " does not exist. Terminating.");
            return toReturn;
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(file2);
        NodeList nodeList = document.getElementsByTagName("string");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            StringBuilder valueBuilder = new StringBuilder();
            try {
                for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                    Node child = node.getChildNodes().item(j);
                    String toAdd = null;
                    toAdd = "ns1:g".equals(child.getNodeName()) ? child.getFirstChild().getNodeValue() : ("xliff:g".equals(child.getNodeName()) ? child.getFirstChild().getNodeValue() : child.getNodeValue());
                    toAdd = toAdd.replaceAll("[\n\t]", "");
                    toAdd = toAdd.replaceAll("[ ]+", " ");
                    valueBuilder.append(toAdd);
                }
                String finalString = valueBuilder.toString().trim();
                toReturn.put(name, finalString);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    private static String getCopyRight() {
        return "\n#\n# Copyright (C) 2020 The Android Open Source Project\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n#      http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n#";
    }
}

