/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.util.AccessibilityUtils;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityShortcutInfo {
    private static final String TAG_ACCESSIBILITY_SHORTCUT = "accessibility-shortcut-target";
    public static final String META_DATA = "android.accessibilityshortcut.target";
    private final ComponentName mComponentName;
    private final ActivityInfo mActivityInfo;
    private final int mIntroResId;
    private final int mSummaryResId;
    private final int mDescriptionResId;
    private final int mAnimatedImageRes;
    private final int mHtmlDescriptionRes;
    private String mSettingsActivityName;
    private String mTileServiceName;

    public AccessibilityShortcutInfo(Context context, ActivityInfo activityInfo) throws XmlPullParserException, IOException {
        PackageManager packageManager = context.getPackageManager();
        this.mComponentName = activityInfo.getComponentName();
        this.mActivityInfo = activityInfo;
        try (XmlResourceParser parser = this.mActivityInfo.loadXmlMetaData(packageManager, META_DATA);){
            if (parser == null) {
                throw new XmlPullParserException("Meta-data accessibility-shortcut-target does not exist");
            }
            int type = 0;
            while (type != 1 && type != 2) {
                type = parser.next();
            }
            String nodeName = parser.getName();
            if (!TAG_ACCESSIBILITY_SHORTCUT.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start withaccessibility-shortcut-target tag");
            }
            AttributeSet allAttributes = Xml.asAttributeSet(parser);
            Resources resources = packageManager.getResourcesForApplication(this.mActivityInfo.applicationInfo);
            TypedArray asAttributes = resources.obtainAttributes(allAttributes, R.styleable.AccessibilityShortcutTarget);
            this.mDescriptionResId = asAttributes.getResourceId(0, 0);
            this.mSummaryResId = asAttributes.getResourceId(1, 0);
            this.mAnimatedImageRes = asAttributes.getResourceId(3, 0);
            this.mHtmlDescriptionRes = asAttributes.getResourceId(4, 0);
            this.mSettingsActivityName = asAttributes.getString(2);
            this.mTileServiceName = asAttributes.getString(5);
            this.mIntroResId = asAttributes.getResourceId(6, 0);
            asAttributes.recycle();
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new XmlPullParserException("Unable to create context for: " + this.mActivityInfo.packageName);
        }
    }

    public ActivityInfo getActivityInfo() {
        return this.mActivityInfo;
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public String loadSummary(PackageManager packageManager) {
        return this.loadResourceString(packageManager, this.mActivityInfo, this.mSummaryResId);
    }

    public String loadIntro(PackageManager packageManager) {
        return this.loadResourceString(packageManager, this.mActivityInfo, this.mIntroResId);
    }

    public String loadDescription(PackageManager packageManager) {
        return this.loadResourceString(packageManager, this.mActivityInfo, this.mDescriptionResId);
    }

    public int getAnimatedImageRes() {
        return this.mAnimatedImageRes;
    }

    public Drawable loadAnimatedImage(Context context) {
        if (this.mAnimatedImageRes == 0) {
            return null;
        }
        return AccessibilityUtils.loadSafeAnimatedImage(context, this.mActivityInfo.applicationInfo, this.mAnimatedImageRes);
    }

    public String loadHtmlDescription(PackageManager packageManager) {
        String htmlDescription = this.loadResourceString(packageManager, this.mActivityInfo, this.mHtmlDescriptionRes);
        if (htmlDescription != null) {
            return AccessibilityUtils.getFilteredHtmlText(htmlDescription);
        }
        return null;
    }

    public String getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    public String getTileServiceName() {
        return this.mTileServiceName;
    }

    private String loadResourceString(PackageManager packageManager, ActivityInfo activityInfo, int resId) {
        if (resId == 0) {
            return null;
        }
        CharSequence text = packageManager.getText(activityInfo.packageName, resId, activityInfo.applicationInfo);
        if (text != null) {
            return text.toString().trim();
        }
        return null;
    }

    public int hashCode() {
        return 31 + (this.mComponentName == null ? 0 : this.mComponentName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityShortcutInfo other = (AccessibilityShortcutInfo)obj;
        return !(this.mComponentName == null ? other.mComponentName != null : !this.mComponentName.equals(other.mComponentName));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AccessibilityShortcutInfo[");
        stringBuilder.append("activityInfo: ").append(this.mActivityInfo);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

