/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.IAccountManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.Set;

public class Account
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static final String TAG = "Account";
    @GuardedBy(value={"sAccessedAccounts"})
    private static final Set<Account> sAccessedAccounts = new ArraySet<Account>();
    public final String name;
    public final String type;
    private String mSafeName;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final String accessId;
    public static final Parcelable.Creator<Account> CREATOR = new Parcelable.Creator<Account>(){

        @Override
        public Account createFromParcel(Parcel source) {
            return new Account(source);
        }

        public Account[] newArray(int size) {
            return new Account[size];
        }
    };

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        return this.name.equals(other.name) && this.type.equals(other.type);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public Account(String name, String type) {
        this(name, type, null);
    }

    public Account(Account other, String accessId) {
        this(other.name, other.type, accessId);
    }

    public Account(String name, String type, String accessId) {
        if (TextUtils.isEmpty(name)) {
            throw new IllegalArgumentException("the name must not be empty: " + name);
        }
        if (TextUtils.isEmpty(type)) {
            throw new IllegalArgumentException("the type must not be empty: " + type);
        }
        this.name = name;
        this.type = type;
        this.accessId = accessId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account(Parcel in) {
        this.name = in.readString();
        this.type = in.readString();
        if (TextUtils.isEmpty(this.name)) {
            throw new BadParcelableException("the name must not be empty: " + this.name);
        }
        if (TextUtils.isEmpty(this.type)) {
            throw new BadParcelableException("the type must not be empty: " + this.type);
        }
        this.accessId = in.readString();
        if (this.accessId != null) {
            Set<Account> set = sAccessedAccounts;
            synchronized (set) {
                if (sAccessedAccounts.add(this)) {
                    try {
                        IAccountManager accountManager = IAccountManager.Stub.asInterface(ServiceManager.getService("account"));
                        accountManager.onAccountAccessed(this.accessId);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error noting account access", e);
                    }
                }
            }
        }
    }

    public String getAccessId() {
        return this.accessId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.type);
        dest.writeString(this.accessId);
    }

    public String toString() {
        return "Account {name=" + this.name + ", type=" + this.type + "}";
    }

    public String toSafeString() {
        if (this.mSafeName == null) {
            this.mSafeName = Account.toSafeName(this.name, 'x');
        }
        return "Account {name=" + this.mSafeName + ", type=" + this.type + "}";
    }

    public static String toSafeName(String name, char replacement) {
        StringBuilder builder2 = new StringBuilder(64);
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                builder2.append(replacement);
                continue;
            }
            builder2.append(c);
        }
        return builder2.toString();
    }
}

