/*
 * Decompiled with CFR 0.152.
 */
package android.adservices;

import android.adservices.GetTopicsRequest;
import android.adservices.GetTopicsResponse;
import android.adservices.IGetTopicsCallback;
import android.adservices.ITopicsService;
import android.adservices.exceptions.AdServicesException;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import java.util.Objects;
import java.util.concurrent.Executor;

public class TopicsManager {
    public static final String TOPICS_SERVICE = "topics_service";
    private final Context mContext;
    private final ServiceBinder<ITopicsService> mServiceBinder;

    public TopicsManager(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.TOPICS_SERVICE", ITopicsService.Stub::asInterface);
    }

    private ITopicsService getService() {
        ITopicsService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    public void getTopics(final Executor executor, final OutcomeReceiver<GetTopicsResponse, AdServicesException> callback2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        ITopicsService service = this.getService();
        try {
            service.getTopics(new GetTopicsRequest.Builder().setAttributionSource(this.mContext.getAttributionSource()).build(), new IGetTopicsCallback.Stub(){

                @Override
                public void onResult(GetTopicsResponse resultParcel) {
                    executor.execute(() -> callback2.onResult(resultParcel));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e("RemoteException", e);
            callback2.onError(new AdServicesException("Internal Error!"));
        }
    }

    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }
}

