/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.FloatKeyframeSet;
import android.animation.IntKeyframeSet;
import android.animation.Keyframe;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.util.Log;
import java.util.Arrays;
import java.util.List;

public class KeyframeSet
implements Keyframes {
    int mNumKeyframes;
    Keyframe mFirstKeyframe;
    Keyframe mLastKeyframe;
    TimeInterpolator mInterpolator;
    List<Keyframe> mKeyframes;
    TypeEvaluator mEvaluator;

    public KeyframeSet(Keyframe ... keyframes) {
        this.mNumKeyframes = keyframes.length;
        this.mKeyframes = Arrays.asList(keyframes);
        this.mFirstKeyframe = keyframes[0];
        this.mLastKeyframe = keyframes[this.mNumKeyframes - 1];
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    @Override
    public List<Keyframe> getKeyframes() {
        return this.mKeyframes;
    }

    public static KeyframeSet ofInt(int ... values2) {
        int numKeyframes = values2.length;
        Keyframe.IntKeyframe[] keyframes = new Keyframe.IntKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            keyframes[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, values2[0]);
        } else {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, values2[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(numKeyframes - 1), values2[i]);
            }
        }
        return new IntKeyframeSet(keyframes);
    }

    public static KeyframeSet ofFloat(float ... values2) {
        boolean badValue = false;
        int numKeyframes = values2.length;
        Keyframe.FloatKeyframe[] keyframes = new Keyframe.FloatKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            keyframes[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, values2[0]);
            if (Float.isNaN(values2[0])) {
                badValue = true;
            }
        } else {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, values2[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(numKeyframes - 1), values2[i]);
                if (!Float.isNaN(values2[i])) continue;
                badValue = true;
            }
        }
        if (badValue) {
            Log.w("Animator", "Bad value (NaN) in float animator");
        }
        return new FloatKeyframeSet(keyframes);
    }

    public static KeyframeSet ofKeyframe(Keyframe ... keyframes) {
        int numKeyframes = keyframes.length;
        boolean hasFloat = false;
        boolean hasInt = false;
        boolean hasOther = false;
        for (int i = 0; i < numKeyframes; ++i) {
            if (keyframes[i] instanceof Keyframe.FloatKeyframe) {
                hasFloat = true;
                continue;
            }
            if (keyframes[i] instanceof Keyframe.IntKeyframe) {
                hasInt = true;
                continue;
            }
            hasOther = true;
        }
        if (hasFloat && !hasInt && !hasOther) {
            Keyframe.FloatKeyframe[] floatKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                floatKeyframes[i] = (Keyframe.FloatKeyframe)keyframes[i];
            }
            return new FloatKeyframeSet(floatKeyframes);
        }
        if (hasInt && !hasFloat && !hasOther) {
            Keyframe.IntKeyframe[] intKeyframes = new Keyframe.IntKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                intKeyframes[i] = (Keyframe.IntKeyframe)keyframes[i];
            }
            return new IntKeyframeSet(intKeyframes);
        }
        return new KeyframeSet(keyframes);
    }

    public static KeyframeSet ofObject(Object ... values2) {
        int numKeyframes = values2.length;
        Keyframe[] keyframes = new Keyframe.ObjectKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframes[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, values2[0]);
        } else {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, values2[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)i / (float)(numKeyframes - 1), values2[i]);
            }
        }
        return new KeyframeSet(keyframes);
    }

    public static PathKeyframes ofPath(Path path) {
        return new PathKeyframes(path);
    }

    public static PathKeyframes ofPath(Path path, float error) {
        return new PathKeyframes(path, error);
    }

    @Override
    public void setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
    }

    @Override
    public Class getType() {
        return this.mFirstKeyframe.getType();
    }

    @Override
    public KeyframeSet clone() {
        List<Keyframe> keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe[] newKeyframes = new Keyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = keyframes.get(i).clone();
        }
        KeyframeSet newSet = new KeyframeSet(newKeyframes);
        return newSet;
    }

    @Override
    public Object getValue(float fraction2) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                fraction2 = this.mInterpolator.getInterpolation(fraction2);
            }
            return this.mEvaluator.evaluate(fraction2, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (fraction2 <= 0.0f) {
            Keyframe nextKeyframe = this.mKeyframes.get(1);
            TimeInterpolator interpolator2 = nextKeyframe.getInterpolator();
            if (interpolator2 != null) {
                fraction2 = interpolator2.getInterpolation(fraction2);
            }
            float prevFraction = this.mFirstKeyframe.getFraction();
            float intervalFraction = (fraction2 - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, this.mFirstKeyframe.getValue(), nextKeyframe.getValue());
        }
        if (fraction2 >= 1.0f) {
            Keyframe prevKeyframe = this.mKeyframes.get(this.mNumKeyframes - 2);
            TimeInterpolator interpolator3 = this.mLastKeyframe.getInterpolator();
            if (interpolator3 != null) {
                fraction2 = interpolator3.getInterpolation(fraction2);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction2 - prevFraction) / (this.mLastKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe prevKeyframe = this.mFirstKeyframe;
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe nextKeyframe = this.mKeyframes.get(i);
            if (fraction2 < nextKeyframe.getFraction()) {
                TimeInterpolator interpolator4 = nextKeyframe.getInterpolator();
                float prevFraction = prevKeyframe.getFraction();
                float intervalFraction = (fraction2 - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
                if (interpolator4 != null) {
                    intervalFraction = interpolator4.getInterpolation(intervalFraction);
                }
                return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), nextKeyframe.getValue());
            }
            prevKeyframe = nextKeyframe;
        }
        return this.mLastKeyframe.getValue();
    }

    public String toString() {
        String returnVal = " ";
        for (int i = 0; i < this.mNumKeyframes; ++i) {
            returnVal = returnVal + this.mKeyframes.get(i).getValue() + "  ";
        }
        return returnVal;
    }
}

