/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.IAlarmCompleteListener;
import android.app.IAlarmListener;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.android.i18n.timezone.ZoneInfoDb;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

public class AlarmManager {
    private static final String TAG = "AlarmManager";
    public static final int RTC_WAKEUP = 0;
    public static final int RTC = 1;
    public static final int ELAPSED_REALTIME_WAKEUP = 2;
    public static final int ELAPSED_REALTIME = 3;
    public static final String ACTION_NEXT_ALARM_CLOCK_CHANGED = "android.app.action.NEXT_ALARM_CLOCK_CHANGED";
    public static final String ACTION_SCHEDULE_EXACT_ALARM_PERMISSION_STATE_CHANGED = "android.app.action.SCHEDULE_EXACT_ALARM_PERMISSION_STATE_CHANGED";
    @UnsupportedAppUsage
    public static final long WINDOW_EXACT = 0L;
    @UnsupportedAppUsage
    public static final long WINDOW_HEURISTIC = -1L;
    @UnsupportedAppUsage
    public static final int FLAG_STANDALONE = 1;
    @UnsupportedAppUsage
    public static final int FLAG_WAKE_FROM_IDLE = 2;
    public static final int FLAG_ALLOW_WHILE_IDLE = 4;
    @UnsupportedAppUsage
    public static final int FLAG_ALLOW_WHILE_IDLE_UNRESTRICTED = 8;
    @UnsupportedAppUsage
    public static final int FLAG_IDLE_UNTIL = 16;
    public static final int FLAG_ALLOW_WHILE_IDLE_COMPAT = 32;
    public static final int FLAG_PRIORITIZE = 64;
    public static final long REQUIRE_EXACT_ALARM_PERMISSION = 171306433L;
    public static final long ENFORCE_MINIMUM_WINDOW_ON_INEXACT_ALARMS = 185199076L;
    public static final long ENABLE_USE_EXACT_ALARM = 218533173L;
    public static final long SCHEDULE_EXACT_ALARM_DENIED_BY_DEFAULT = 226439802L;
    @UnsupportedAppUsage
    private final IAlarmManager mService;
    private final Context mContext;
    private final String mPackageName;
    private final boolean mAlwaysExact;
    private final int mTargetSdkVersion;
    private final Handler mMainThreadHandler;
    private static WeakHashMap<OnAlarmListener, WeakReference<ListenerWrapper>> sWrappers;
    public static final long INTERVAL_FIFTEEN_MINUTES = 900000L;
    public static final long INTERVAL_HALF_HOUR = 1800000L;
    public static final long INTERVAL_HOUR = 3600000L;
    public static final long INTERVAL_HALF_DAY = 43200000L;
    public static final long INTERVAL_DAY = 86400000L;

    AlarmManager(IAlarmManager service, Context ctx) {
        this.mService = service;
        this.mContext = ctx;
        this.mPackageName = ctx.getPackageName();
        this.mTargetSdkVersion = ctx.getApplicationInfo().targetSdkVersion;
        this.mAlwaysExact = this.mTargetSdkVersion < 19;
        this.mMainThreadHandler = new Handler(ctx.getMainLooper());
    }

    private long legacyExactLength() {
        return this.mAlwaysExact ? 0L : -1L;
    }

    public void set(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), 0L, 0, operation, null, null, (Handler)null, null, null);
    }

    public void set(int type, long triggerAtMillis, String tag2, OnAlarmListener listener2, Handler targetHandler) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), 0L, 0, null, listener2, tag2, targetHandler, null, null);
    }

    public void setRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), intervalMillis, 0, operation, null, null, (Handler)null, null, null);
    }

    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, 0, operation, null, null, (Handler)null, null, null);
    }

    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, String tag2, OnAlarmListener listener2, Handler targetHandler) {
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, 0, null, listener2, tag2, targetHandler, null, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SCHEDULE_PRIORITIZED_ALARM")
    public void setPrioritized(int type, long windowStartMillis, long windowLengthMillis, String tag2, Executor executor, OnAlarmListener listener2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener2);
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, 64, null, listener2, tag2, executor, null, null);
    }

    @RequiresPermission(value="android.permission.SCHEDULE_EXACT_ALARM", conditional=true)
    public void setExact(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 0, operation, null, null, (Handler)null, null, null);
    }

    @RequiresPermission(value="android.permission.SCHEDULE_EXACT_ALARM", conditional=true)
    public void setExact(int type, long triggerAtMillis, String tag2, OnAlarmListener listener2, Handler targetHandler) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 0, null, listener2, tag2, targetHandler, null, null);
    }

    public void setIdleUntil(int type, long triggerAtMillis, String tag2, OnAlarmListener listener2, Handler targetHandler) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 16, null, listener2, tag2, targetHandler, null, null);
    }

    @RequiresPermission(value="android.permission.SCHEDULE_EXACT_ALARM")
    public void setAlarmClock(AlarmClockInfo info, PendingIntent operation) {
        this.setImpl(0, info.getTriggerTime(), 0L, 0L, 0, operation, null, null, (Handler)null, null, info);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, PendingIntent operation, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, 0, operation, null, null, (Handler)null, workSource, null);
    }

    @UnsupportedAppUsage
    public void set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, String tag2, OnAlarmListener listener2, Handler targetHandler, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, 0, null, listener2, tag2, targetHandler, workSource, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, OnAlarmListener listener2, Handler targetHandler, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, 0, null, listener2, null, targetHandler, workSource, null);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.UPDATE_DEVICE_STATS", "android.permission.SCHEDULE_EXACT_ALARM"}, conditional=true)
    public void setExact(int type, long triggerAtMillis, String tag2, Executor executor, WorkSource workSource, OnAlarmListener listener2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(workSource);
        Objects.requireNonNull(listener2);
        this.setImpl(type, triggerAtMillis, 0L, 0L, 0, null, listener2, tag2, executor, workSource, null);
    }

    private void setImpl(int type, long triggerAtMillis, long windowMillis, long intervalMillis, int flags, PendingIntent operation, OnAlarmListener listener2, String listenerTag, Handler targetHandler, WorkSource workSource, AlarmClockInfo alarmClock) {
        Handler handlerToUse = targetHandler != null ? targetHandler : this.mMainThreadHandler;
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, flags, operation, listener2, listenerTag, new HandlerExecutor(handlerToUse), workSource, alarmClock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void setImpl(int type, long triggerAtMillis, long windowMillis, long intervalMillis, int flags, PendingIntent operation, OnAlarmListener listener2, String listenerTag, Executor targetExecutor, WorkSource workSource, AlarmClockInfo alarmClock) {
        if (triggerAtMillis < 0L) {
            triggerAtMillis = 0L;
        }
        ListenerWrapper recipientWrapper = null;
        if (listener2 != null) {
            WeakReference<ListenerWrapper> weakRef;
            Class<AlarmManager> clazz = AlarmManager.class;
            // MONITORENTER : android.app.AlarmManager.class
            if (sWrappers == null) {
                sWrappers = new WeakHashMap();
            }
            if ((weakRef = sWrappers.get(listener2)) != null) {
                recipientWrapper = (ListenerWrapper)weakRef.get();
            }
            if (recipientWrapper == null) {
                recipientWrapper = new ListenerWrapper(listener2);
                sWrappers.put(listener2, new WeakReference<ListenerWrapper>(recipientWrapper));
            }
            // MONITOREXIT : clazz
            recipientWrapper.setExecutor(targetExecutor);
        }
        try {
            this.mService.set(this.mPackageName, type, triggerAtMillis, windowMillis, intervalMillis, flags, operation, recipientWrapper, listenerTag, workSource, alarmClock);
            return;
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, -1L, intervalMillis, 0, operation, null, null, (Handler)null, null, null);
    }

    public void setAndAllowWhileIdle(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, -1L, 0L, 4, operation, null, null, (Handler)null, null, null);
    }

    @RequiresPermission(value="android.permission.SCHEDULE_EXACT_ALARM", conditional=true)
    public void setExactAndAllowWhileIdle(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 4, operation, null, null, (Handler)null, null, null);
    }

    public void cancel(PendingIntent operation) {
        if (operation == null) {
            String msg = "cancel() called with a null PendingIntent";
            if (this.mTargetSdkVersion >= 24) {
                throw new NullPointerException("cancel() called with a null PendingIntent");
            }
            Log.e(TAG, "cancel() called with a null PendingIntent");
            return;
        }
        try {
            this.mService.remove(operation, null);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(OnAlarmListener listener2) {
        if (listener2 == null) {
            throw new NullPointerException("cancel() called with a null OnAlarmListener");
        }
        ListenerWrapper wrapper = null;
        Class<AlarmManager> clazz = AlarmManager.class;
        synchronized (AlarmManager.class) {
            WeakReference<ListenerWrapper> weakRef;
            if (sWrappers != null && (weakRef = sWrappers.get(listener2)) != null) {
                wrapper = (ListenerWrapper)weakRef.get();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (wrapper == null) {
                Log.w(TAG, "Unrecognized alarm listener " + listener2);
                return;
            }
            wrapper.cancel();
            return;
        }
    }

    @RequiresPermission(value="android.permission.SET_TIME")
    public void setTime(long millis) {
        try {
            this.mService.setTime(millis);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_TIME_ZONE")
    public void setTimeZone(String timeZone) {
        boolean hasTimeZone;
        if (TextUtils.isEmpty(timeZone)) {
            return;
        }
        if (this.mTargetSdkVersion >= 23 && !(hasTimeZone = ZoneInfoDb.getInstance().hasTimeZone(timeZone))) {
            throw new IllegalArgumentException("Timezone: " + timeZone + " is not an Olson ID");
        }
        try {
            this.mService.setTimeZone(timeZone);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public long getNextWakeFromIdleTime() {
        try {
            return this.mService.getNextWakeFromIdleTime();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canScheduleExactAlarms() {
        try {
            return this.mService.canScheduleExactAlarms(this.mContext.getOpPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasScheduleExactAlarm(String packageName, int userId) {
        try {
            return this.mService.hasScheduleExactAlarm(packageName, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public AlarmClockInfo getNextAlarmClock() {
        return this.getNextAlarmClock(this.mContext.getUserId());
    }

    public AlarmClockInfo getNextAlarmClock(int userId) {
        try {
            return this.mService.getNextAlarmClock(userId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public static class AlarmClockInfo
    implements Parcelable {
        private final long mTriggerTime;
        private final PendingIntent mShowIntent;
        public static final Parcelable.Creator<AlarmClockInfo> CREATOR = new Parcelable.Creator<AlarmClockInfo>(){

            @Override
            public AlarmClockInfo createFromParcel(Parcel in) {
                return new AlarmClockInfo(in);
            }

            public AlarmClockInfo[] newArray(int size) {
                return new AlarmClockInfo[size];
            }
        };

        public AlarmClockInfo(long triggerTime, PendingIntent showIntent) {
            this.mTriggerTime = triggerTime;
            this.mShowIntent = showIntent;
        }

        AlarmClockInfo(Parcel in) {
            this.mTriggerTime = in.readLong();
            this.mShowIntent = (PendingIntent)in.readParcelable(PendingIntent.class.getClassLoader());
        }

        public long getTriggerTime() {
            return this.mTriggerTime;
        }

        public PendingIntent getShowIntent() {
            return this.mShowIntent;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mTriggerTime);
            dest.writeParcelable(this.mShowIntent, flags);
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, this.mTriggerTime);
            if (this.mShowIntent != null) {
                this.mShowIntent.dumpDebug(proto, 1146756268034L);
            }
            proto.end(token);
        }
    }

    class ListenerWrapper
    extends IAlarmListener.Stub
    implements Runnable {
        final OnAlarmListener mListener;
        Executor mExecutor;
        IAlarmCompleteListener mCompletion;

        public ListenerWrapper(OnAlarmListener listener2) {
            this.mListener = listener2;
        }

        void setExecutor(Executor e) {
            this.mExecutor = e;
        }

        public void cancel() {
            try {
                AlarmManager.this.mService.remove(null, this);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public void doAlarm(IAlarmCompleteListener alarmManager) {
            this.mCompletion = alarmManager;
            this.mExecutor.execute(this);
        }

        @Override
        public void run() {
            try {
                this.mListener.onAlarm();
            }
            finally {
                try {
                    this.mCompletion.alarmComplete(this);
                }
                catch (Exception e) {
                    Log.e(AlarmManager.TAG, "Unable to report completion to Alarm Manager!", e);
                }
            }
        }
    }

    public static interface OnAlarmListener {
        public void onAlarm();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlarmType {
    }
}

