/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.LoadedApk;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.view.autofill.AutofillManager;
import android.view.autofill.Helper;
import java.util.ArrayList;

public class Application
extends ContextWrapper
implements ComponentCallbacks2 {
    private static final String TAG = "Application";
    @UnsupportedAppUsage
    private ArrayList<ActivityLifecycleCallbacks> mActivityLifecycleCallbacks = new ArrayList();
    @UnsupportedAppUsage
    private ArrayList<OnProvideAssistDataListener> mAssistCallbacks = null;
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();
    @UnsupportedAppUsage
    public LoadedApk mLoadedApk;

    public Application() {
        super(null);
    }

    private String getLoadedApkInfo() {
        if (this.mLoadedApk == null) {
            return "null";
        }
        return this.mLoadedApk + "/pkg=" + this.mLoadedApk.mPackageName;
    }

    public void onCreate() {
    }

    public void onTerminate() {
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.mCallbacksController.dispatchConfigurationChanged(newConfig);
    }

    @Override
    public void onLowMemory() {
        this.mCallbacksController.dispatchLowMemory();
    }

    @Override
    public void onTrimMemory(int level) {
        this.mCallbacksController.dispatchTrimMemory(level);
    }

    @Override
    public void registerComponentCallbacks(ComponentCallbacks callback2) {
        this.mCallbacksController.registerCallbacks(callback2);
    }

    @Override
    public void unregisterComponentCallbacks(ComponentCallbacks callback2) {
        this.mCallbacksController.unregisterCallbacks(callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback2) {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.add(callback2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback2) {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.remove(callback2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnProvideAssistDataListener(OnProvideAssistDataListener callback2) {
        Application application = this;
        synchronized (application) {
            if (this.mAssistCallbacks == null) {
                this.mAssistCallbacks = new ArrayList();
            }
            this.mAssistCallbacks.add(callback2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnProvideAssistDataListener(OnProvideAssistDataListener callback2) {
        Application application = this;
        synchronized (application) {
            if (this.mAssistCallbacks != null) {
                this.mAssistCallbacks.remove(callback2);
            }
        }
    }

    public static String getProcessName() {
        return ActivityThread.currentProcessName();
    }

    @UnsupportedAppUsage
    void attach(Context context) {
        this.attachBaseContext(context);
        this.mLoadedApk = ContextImpl.getImpl((Context)context).mPackageInfo;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPreCreated(Activity activity, Bundle savedInstanceState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPreCreated(activity, savedInstanceState);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivityCreated(Activity activity, Bundle savedInstanceState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityCreated(activity, savedInstanceState);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostCreated(Activity activity, Bundle savedInstanceState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostCreated(activity, savedInstanceState);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPreStarted(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPreStarted(activity);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivityStarted(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityStarted(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostStarted(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostStarted(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPreResumed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPreResumed(activity);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivityResumed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityResumed(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostResumed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostResumed(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPrePaused(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPrePaused(activity);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivityPaused(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPaused(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostPaused(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostPaused(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPreStopped(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPreStopped(activity);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivityStopped(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityStopped(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostStopped(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostStopped(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPreSaveInstanceState(Activity activity, Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPreSaveInstanceState(activity, outState);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivitySaveInstanceState(Activity activity, Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivitySaveInstanceState(activity, outState);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostSaveInstanceState(Activity activity, Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostSaveInstanceState(activity, outState);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPreDestroyed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPreDestroyed(activity);
            }
        }
    }

    @UnsupportedAppUsage
    void dispatchActivityDestroyed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityDestroyed(activity);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityPostDestroyed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPostDestroyed(activity);
            }
        }
    }

    void dispatchActivityConfigurationChanged(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityConfigurationChanged(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private Object[] collectActivityLifecycleCallbacks() {
        Object[] callbacks = null;
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            if (this.mActivityLifecycleCallbacks.size() > 0) {
                callbacks = this.mActivityLifecycleCallbacks.toArray();
            }
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchOnProvideAssistData(Activity activity, Bundle data) {
        Object[] callbacks;
        Application application = this;
        synchronized (application) {
            if (this.mAssistCallbacks == null) {
                return;
            }
            callbacks = this.mAssistCallbacks.toArray();
        }
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((OnProvideAssistDataListener)callbacks[i]).onProvideAssistData(activity, data);
            }
        }
    }

    @Override
    public AutofillManager.AutofillClient getAutofillClient() {
        ActivityThread activityThread;
        AutofillManager.AutofillClient client = super.getAutofillClient();
        if (client != null) {
            return client;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "getAutofillClient(): null on super, trying to find activity thread");
        }
        if ((activityThread = ActivityThread.currentActivityThread()) == null) {
            return null;
        }
        int activityCount = activityThread.mActivities.size();
        for (int i = 0; i < activityCount; ++i) {
            Activity activity;
            ActivityThread.ActivityClientRecord record = activityThread.mActivities.valueAt(i);
            if (record == null || (activity = record.activity) == null || !activity.getWindow().getDecorView().hasFocus()) continue;
            if (Helper.sVerbose) {
                Log.v(TAG, "getAutofillClient(): found activity for " + this + ": " + activity);
            }
            return activity.getAutofillClient();
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "getAutofillClient(): none of the " + activityCount + " activities on " + this + " have focus");
        }
        return null;
    }

    public static interface OnProvideAssistDataListener {
        public void onProvideAssistData(Activity var1, Bundle var2);
    }

    public static interface ActivityLifecycleCallbacks {
        default public void onActivityPreCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityCreated(Activity var1, Bundle var2);

        default public void onActivityPostCreated(Activity activity, Bundle savedInstanceState) {
        }

        default public void onActivityPreStarted(Activity activity) {
        }

        public void onActivityStarted(Activity var1);

        default public void onActivityPostStarted(Activity activity) {
        }

        default public void onActivityPreResumed(Activity activity) {
        }

        public void onActivityResumed(Activity var1);

        default public void onActivityPostResumed(Activity activity) {
        }

        default public void onActivityPrePaused(Activity activity) {
        }

        public void onActivityPaused(Activity var1);

        default public void onActivityPostPaused(Activity activity) {
        }

        default public void onActivityPreStopped(Activity activity) {
        }

        public void onActivityStopped(Activity var1);

        default public void onActivityPostStopped(Activity activity) {
        }

        default public void onActivityPreSaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivitySaveInstanceState(Activity var1, Bundle var2);

        default public void onActivityPostSaveInstanceState(Activity activity, Bundle outState) {
        }

        default public void onActivityPreDestroyed(Activity activity) {
        }

        public void onActivityDestroyed(Activity var1);

        default public void onActivityPostDestroyed(Activity activity) {
        }

        default public void onActivityConfigurationChanged(Activity activity) {
        }
    }
}

