/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ComponentOptions;
import android.app.compat.CompatChanges;
import android.os.Bundle;

@SystemApi
public class BroadcastOptions
extends ComponentOptions {
    private long mTemporaryAppAllowlistDuration;
    private int mTemporaryAppAllowlistType;
    private int mTemporaryAppAllowlistReasonCode;
    private String mTemporaryAppAllowlistReason;
    private int mMinManifestReceiverApiLevel = 0;
    private int mMaxManifestReceiverApiLevel = 10000;
    private boolean mDontSendToRestrictedApps = false;
    private boolean mAllowBackgroundActivityStarts;
    private String[] mRequireAllOfPermissions;
    private String[] mRequireNoneOfPermissions;
    private long mRequireCompatChangeId = Long.MIN_VALUE;
    private boolean mRequireCompatChangeEnabled = true;
    private long mIdForResponseEvent;
    public static final long CHANGE_INVALID = Long.MIN_VALUE;
    public static final long CHANGE_ALWAYS_ENABLED = 209888056L;
    public static final long CHANGE_ALWAYS_DISABLED = 210856463L;
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_DURATION = "android:broadcast.temporaryAppAllowlistDuration";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_TYPE = "android:broadcast.temporaryAppAllowlistType";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_REASON_CODE = "android:broadcast.temporaryAppAllowlistReasonCode";
    private static final String KEY_TEMPORARY_APP_ALLOWLIST_REASON = "android:broadcast.temporaryAppAllowlistReason";
    private static final String KEY_MIN_MANIFEST_RECEIVER_API_LEVEL = "android:broadcast.minManifestReceiverApiLevel";
    private static final String KEY_MAX_MANIFEST_RECEIVER_API_LEVEL = "android:broadcast.maxManifestReceiverApiLevel";
    private static final String KEY_DONT_SEND_TO_RESTRICTED_APPS = "android:broadcast.dontSendToRestrictedApps";
    private static final String KEY_ALLOW_BACKGROUND_ACTIVITY_STARTS = "android:broadcast.allowBackgroundActivityStarts";
    public static final String KEY_REQUIRE_ALL_OF_PERMISSIONS = "android:broadcast.requireAllOfPermissions";
    public static final String KEY_REQUIRE_NONE_OF_PERMISSIONS = "android:broadcast.requireNoneOfPermissions";
    private static final String KEY_REQUIRE_COMPAT_CHANGE_ID = "android:broadcast.requireCompatChangeId";
    private static final String KEY_REQUIRE_COMPAT_CHANGE_ENABLED = "android:broadcast.requireCompatChangeEnabled";
    @Deprecated
    public static final int TEMPORARY_WHITELIST_TYPE_FOREGROUND_SERVICE_ALLOWED = 0;
    @Deprecated
    public static final int TEMPORARY_WHITELIST_TYPE_FOREGROUND_SERVICE_NOT_ALLOWED = 1;
    private static final String KEY_ID_FOR_RESPONSE_EVENT = "android:broadcast.idForResponseEvent";

    public static BroadcastOptions makeBasic() {
        BroadcastOptions opts = new BroadcastOptions();
        return opts;
    }

    private BroadcastOptions() {
        this.resetTemporaryAppAllowlist();
    }

    public BroadcastOptions(Bundle opts) {
        super(opts);
        if (opts.containsKey(KEY_TEMPORARY_APP_ALLOWLIST_DURATION)) {
            this.mTemporaryAppAllowlistDuration = opts.getLong(KEY_TEMPORARY_APP_ALLOWLIST_DURATION);
            this.mTemporaryAppAllowlistType = opts.getInt(KEY_TEMPORARY_APP_ALLOWLIST_TYPE);
            this.mTemporaryAppAllowlistReasonCode = opts.getInt(KEY_TEMPORARY_APP_ALLOWLIST_REASON_CODE, 0);
            this.mTemporaryAppAllowlistReason = opts.getString(KEY_TEMPORARY_APP_ALLOWLIST_REASON);
        } else {
            this.resetTemporaryAppAllowlist();
        }
        this.mMinManifestReceiverApiLevel = opts.getInt(KEY_MIN_MANIFEST_RECEIVER_API_LEVEL, 0);
        this.mMaxManifestReceiverApiLevel = opts.getInt(KEY_MAX_MANIFEST_RECEIVER_API_LEVEL, 10000);
        this.mDontSendToRestrictedApps = opts.getBoolean(KEY_DONT_SEND_TO_RESTRICTED_APPS, false);
        this.mAllowBackgroundActivityStarts = opts.getBoolean(KEY_ALLOW_BACKGROUND_ACTIVITY_STARTS, false);
        this.mRequireAllOfPermissions = opts.getStringArray(KEY_REQUIRE_ALL_OF_PERMISSIONS);
        this.mRequireNoneOfPermissions = opts.getStringArray(KEY_REQUIRE_NONE_OF_PERMISSIONS);
        this.mRequireCompatChangeId = opts.getLong(KEY_REQUIRE_COMPAT_CHANGE_ID, Long.MIN_VALUE);
        this.mRequireCompatChangeEnabled = opts.getBoolean(KEY_REQUIRE_COMPAT_CHANGE_ENABLED, true);
        this.mIdForResponseEvent = opts.getLong(KEY_ID_FOR_RESPONSE_EVENT);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "android.permission.START_ACTIVITIES_FROM_BACKGROUND", "android.permission.START_FOREGROUND_SERVICES_FROM_BACKGROUND"})
    public void setTemporaryAppWhitelistDuration(long duration) {
        this.setTemporaryAppAllowlist(duration, 0, 0, null);
    }

    @RequiresPermission(anyOf={"android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "android.permission.START_ACTIVITIES_FROM_BACKGROUND", "android.permission.START_FOREGROUND_SERVICES_FROM_BACKGROUND"})
    public void setTemporaryAppAllowlist(long duration, int type, int reasonCode, String reason) {
        this.mTemporaryAppAllowlistDuration = duration;
        this.mTemporaryAppAllowlistType = type;
        this.mTemporaryAppAllowlistReasonCode = reasonCode;
        this.mTemporaryAppAllowlistReason = reason;
        if (!this.isTemporaryAppAllowlistSet()) {
            this.resetTemporaryAppAllowlist();
        }
    }

    private boolean isTemporaryAppAllowlistSet() {
        return this.mTemporaryAppAllowlistDuration > 0L && this.mTemporaryAppAllowlistType != -1;
    }

    private void resetTemporaryAppAllowlist() {
        this.mTemporaryAppAllowlistDuration = 0L;
        this.mTemporaryAppAllowlistType = -1;
        this.mTemporaryAppAllowlistReasonCode = 0;
        this.mTemporaryAppAllowlistReason = null;
    }

    @Override
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    public void setPendingIntentBackgroundActivityLaunchAllowed(boolean allowed) {
        super.setPendingIntentBackgroundActivityLaunchAllowed(allowed);
    }

    @Override
    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    public boolean isPendingIntentBackgroundActivityLaunchAllowed() {
        return super.isPendingIntentBackgroundActivityLaunchAllowed();
    }

    public long getTemporaryAppAllowlistDuration() {
        return this.mTemporaryAppAllowlistDuration;
    }

    public int getTemporaryAppAllowlistType() {
        return this.mTemporaryAppAllowlistType;
    }

    public int getTemporaryAppAllowlistReasonCode() {
        return this.mTemporaryAppAllowlistReasonCode;
    }

    public String getTemporaryAppAllowlistReason() {
        return this.mTemporaryAppAllowlistReason;
    }

    @Deprecated
    public void setMinManifestReceiverApiLevel(int apiLevel) {
        this.mMinManifestReceiverApiLevel = apiLevel;
    }

    @Deprecated
    public int getMinManifestReceiverApiLevel() {
        return this.mMinManifestReceiverApiLevel;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @Deprecated
    public void setMaxManifestReceiverApiLevel(int apiLevel) {
        this.mMaxManifestReceiverApiLevel = apiLevel;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @Deprecated
    public int getMaxManifestReceiverApiLevel() {
        return this.mMaxManifestReceiverApiLevel;
    }

    public void setDontSendToRestrictedApps(boolean dontSendToRestrictedApps) {
        this.mDontSendToRestrictedApps = dontSendToRestrictedApps;
    }

    public boolean isDontSendToRestrictedApps() {
        return this.mDontSendToRestrictedApps;
    }

    @RequiresPermission(value="android.permission.START_ACTIVITIES_FROM_BACKGROUND")
    public void setBackgroundActivityStartsAllowed(boolean allowBackgroundActivityStarts) {
        this.mAllowBackgroundActivityStarts = allowBackgroundActivityStarts;
    }

    public boolean allowsBackgroundActivityStarts() {
        return this.mAllowBackgroundActivityStarts;
    }

    @SystemApi
    public void setRequireAllOfPermissions(String[] requiredPermissions) {
        this.mRequireAllOfPermissions = requiredPermissions;
    }

    @SystemApi
    public void setRequireNoneOfPermissions(String[] excludedPermissions) {
        this.mRequireNoneOfPermissions = excludedPermissions;
    }

    public void setRequireCompatChange(long changeId, boolean enabled) {
        this.mRequireCompatChangeId = changeId;
        this.mRequireCompatChangeEnabled = enabled;
    }

    public void clearRequireCompatChange() {
        this.mRequireCompatChangeId = Long.MIN_VALUE;
        this.mRequireCompatChangeEnabled = true;
    }

    public long getRequireCompatChangeId() {
        return this.mRequireCompatChangeId;
    }

    public boolean testRequireCompatChange(int uid) {
        if (this.mRequireCompatChangeId != Long.MIN_VALUE) {
            return CompatChanges.isChangeEnabled(this.mRequireCompatChangeId, uid) == this.mRequireCompatChangeEnabled;
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RESPONSE_STATS")
    public void recordResponseEventWhileInBackground(long id2) {
        this.mIdForResponseEvent = id2;
    }

    public long getIdForResponseEvent() {
        return this.mIdForResponseEvent;
    }

    @Override
    public Bundle toBundle() {
        Bundle b = super.toBundle();
        if (this.isTemporaryAppAllowlistSet()) {
            b.putLong(KEY_TEMPORARY_APP_ALLOWLIST_DURATION, this.mTemporaryAppAllowlistDuration);
            b.putInt(KEY_TEMPORARY_APP_ALLOWLIST_TYPE, this.mTemporaryAppAllowlistType);
            b.putInt(KEY_TEMPORARY_APP_ALLOWLIST_REASON_CODE, this.mTemporaryAppAllowlistReasonCode);
            b.putString(KEY_TEMPORARY_APP_ALLOWLIST_REASON, this.mTemporaryAppAllowlistReason);
        }
        if (this.mMinManifestReceiverApiLevel != 0) {
            b.putInt(KEY_MIN_MANIFEST_RECEIVER_API_LEVEL, this.mMinManifestReceiverApiLevel);
        }
        if (this.mMaxManifestReceiverApiLevel != 10000) {
            b.putInt(KEY_MAX_MANIFEST_RECEIVER_API_LEVEL, this.mMaxManifestReceiverApiLevel);
        }
        if (this.mDontSendToRestrictedApps) {
            b.putBoolean(KEY_DONT_SEND_TO_RESTRICTED_APPS, true);
        }
        if (this.mAllowBackgroundActivityStarts) {
            b.putBoolean(KEY_ALLOW_BACKGROUND_ACTIVITY_STARTS, true);
        }
        if (this.mRequireAllOfPermissions != null) {
            b.putStringArray(KEY_REQUIRE_ALL_OF_PERMISSIONS, this.mRequireAllOfPermissions);
        }
        if (this.mRequireNoneOfPermissions != null) {
            b.putStringArray(KEY_REQUIRE_NONE_OF_PERMISSIONS, this.mRequireNoneOfPermissions);
        }
        if (this.mRequireCompatChangeId != Long.MIN_VALUE) {
            b.putLong(KEY_REQUIRE_COMPAT_CHANGE_ID, this.mRequireCompatChangeId);
            b.putBoolean(KEY_REQUIRE_COMPAT_CHANGE_ENABLED, this.mRequireCompatChangeEnabled);
        }
        if (this.mIdForResponseEvent != 0L) {
            b.putLong(KEY_ID_FOR_RESPONSE_EVENT, this.mIdForResponseEvent);
        }
        return b.isEmpty() ? null : b;
    }
}

