/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Bundle;

public class ComponentOptions {
    public static final boolean PENDING_INTENT_BAL_ALLOWED_DEFAULT = true;
    public static final String KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED = "android.pendingIntent.backgroundActivityAllowed";
    public static final String KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED_BY_PERMISSION = "android.pendingIntent.backgroundActivityAllowedByPermission";
    private boolean mPendingIntentBalAllowed = true;
    private boolean mPendingIntentBalAllowedByPermission = false;

    ComponentOptions() {
    }

    ComponentOptions(Bundle opts) {
        opts.setDefusable(true);
        this.setPendingIntentBackgroundActivityLaunchAllowed(opts.getBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED, true));
        this.setPendingIntentBackgroundActivityLaunchAllowedByPermission(opts.getBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED_BY_PERMISSION, false));
    }

    public void setPendingIntentBackgroundActivityLaunchAllowed(boolean allowed) {
        this.mPendingIntentBalAllowed = allowed;
    }

    public boolean isPendingIntentBackgroundActivityLaunchAllowed() {
        return this.mPendingIntentBalAllowed;
    }

    public void setPendingIntentBackgroundActivityLaunchAllowedByPermission(boolean allowed) {
        this.mPendingIntentBalAllowedByPermission = allowed;
    }

    public boolean isPendingIntentBackgroundActivityLaunchAllowedByPermission() {
        return this.mPendingIntentBalAllowedByPermission;
    }

    public Bundle toBundle() {
        Bundle b = new Bundle();
        b.putBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED, this.mPendingIntentBalAllowed);
        if (this.mPendingIntentBalAllowedByPermission) {
            b.putBoolean(KEY_PENDING_INTENT_BACKGROUND_ACTIVITY_ALLOWED_BY_PERMISSION, this.mPendingIntentBalAllowedByPermission);
        }
        return b;
    }
}

