/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.IProcessObserver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@SuppressLint(value={"ListenerInterface"})
public abstract class HomeVisibilityListener {
    private Context mContext;
    private ActivityManager mActivityManager;
    private Executor mExecutor;
    IProcessObserver.Stub mObserver = new IProcessObserver.Stub(){

        @Override
        public void onForegroundActivitiesChanged(int pid, int uid, boolean fg) {
            this.refreshHomeVisibility();
        }

        @Override
        public void onForegroundServicesChanged(int pid, int uid, int fgServiceTypes) {
        }

        @Override
        public void onProcessDied(int pid, int uid) {
            this.refreshHomeVisibility();
        }

        private void refreshHomeVisibility() {
            boolean isHomeActivityVisible = HomeVisibilityListener.this.isHomeActivityVisible();
            if (HomeVisibilityListener.this.mIsHomeActivityVisible != isHomeActivityVisible) {
                HomeVisibilityListener.this.mIsHomeActivityVisible = isHomeActivityVisible;
                Binder.withCleanCallingIdentity(() -> HomeVisibilityListener.this.mExecutor.execute(() -> HomeVisibilityListener.this.onHomeVisibilityChanged(HomeVisibilityListener.this.mIsHomeActivityVisible)));
            }
        }
    };
    boolean mIsHomeActivityVisible;

    void init(Context context, Executor executor, ActivityManager activityManager) {
        this.mContext = context;
        this.mActivityManager = activityManager;
        this.mIsHomeActivityVisible = this.isHomeActivityVisible();
        this.mExecutor = executor;
    }

    public abstract void onHomeVisibilityChanged(boolean var1);

    private boolean isHomeActivityVisible() {
        List<ActivityManager.RunningTaskInfo> tasks = this.mActivityManager.getRunningTasks(1);
        if (tasks == null || tasks.isEmpty()) {
            return false;
        }
        String top = tasks.get((int)0).topActivity.getPackageName();
        if (top == null) {
            return false;
        }
        ComponentName defaultHomeComponent = this.mContext.getPackageManager().getHomeActivities(new ArrayList<ResolveInfo>());
        if (defaultHomeComponent == null) {
            return false;
        }
        String defaultHomePackage = defaultHomeComponent.getPackageName();
        return Objects.equals(top, defaultHomePackage);
    }
}

