/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICompatCameraControlCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ICompatCameraControlCallback";

    public void applyCameraCompatTreatment() throws RemoteException;

    public void revertCameraCompatTreatment() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICompatCameraControlCallback {
        static final int TRANSACTION_applyCameraCompatTreatment = 1;
        static final int TRANSACTION_revertCameraCompatTreatment = 2;

        public Stub() {
            this.attachInterface(this, ICompatCameraControlCallback.DESCRIPTOR);
        }

        public static ICompatCameraControlCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICompatCameraControlCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICompatCameraControlCallback) {
                return (ICompatCameraControlCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "applyCameraCompatTreatment";
                }
                case 2: {
                    return "revertCameraCompatTreatment";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICompatCameraControlCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.applyCameraCompatTreatment();
                    break;
                }
                case 2: {
                    this.revertCameraCompatTreatment();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICompatCameraControlCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICompatCameraControlCallback.DESCRIPTOR;
            }

            @Override
            public void applyCameraCompatTreatment() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICompatCameraControlCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void revertCameraCompatTreatment() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICompatCameraControlCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICompatCameraControlCallback {
        @Override
        public void applyCameraCompatTreatment() throws RemoteException {
        }

        @Override
        public void revertCameraCompatTreatment() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

