/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILocaleManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ILocaleManager";

    public void setApplicationLocales(String var1, int var2, LocaleList var3) throws RemoteException;

    public LocaleList getApplicationLocales(String var1, int var2) throws RemoteException;

    public LocaleList getSystemLocales() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocaleManager {
        static final int TRANSACTION_setApplicationLocales = 1;
        static final int TRANSACTION_getApplicationLocales = 2;
        static final int TRANSACTION_getSystemLocales = 3;

        public Stub() {
            this.attachInterface(this, ILocaleManager.DESCRIPTOR);
        }

        public static ILocaleManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILocaleManager.DESCRIPTOR);
            if (iin != null && iin instanceof ILocaleManager) {
                return (ILocaleManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setApplicationLocales";
                }
                case 2: {
                    return "getApplicationLocales";
                }
                case 3: {
                    return "getSystemLocales";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILocaleManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    LocaleList _arg2 = data.readTypedObject(LocaleList.CREATOR);
                    data.enforceNoDataAvail();
                    this.setApplicationLocales(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    LocaleList _result = this.getApplicationLocales(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    LocaleList _result = this.getSystemLocales();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ILocaleManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILocaleManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setApplicationLocales(String packageName, int userId, LocaleList locales) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILocaleManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeTypedObject(locales, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LocaleList getApplicationLocales(String packageName, int userId) throws RemoteException {
                LocaleList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILocaleManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LocaleList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LocaleList getSystemLocales() throws RemoteException {
                LocaleList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILocaleManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LocaleList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ILocaleManager {
        @Override
        public void setApplicationLocales(String packageName, int userId, LocaleList locales) throws RemoteException {
        }

        @Override
        public LocaleList getApplicationLocales(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public LocaleList getSystemLocales() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

