/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.TaskSnapshot;

public interface ITaskStackListener
extends IInterface {
    public static final int FORCED_RESIZEABLE_REASON_SPLIT_SCREEN = 1;
    public static final int FORCED_RESIZEABLE_REASON_SECONDARY_DISPLAY = 2;

    public void onTaskStackChanged() throws RemoteException;

    public void onActivityPinned(String var1, int var2, int var3, int var4) throws RemoteException;

    public void onActivityUnpinned() throws RemoteException;

    public void onActivityRestartAttempt(ActivityManager.RunningTaskInfo var1, boolean var2, boolean var3, boolean var4) throws RemoteException;

    public void onActivityForcedResizable(String var1, int var2, int var3) throws RemoteException;

    public void onActivityDismissingDockedTask() throws RemoteException;

    public void onActivityLaunchOnSecondaryDisplayFailed(ActivityManager.RunningTaskInfo var1, int var2) throws RemoteException;

    public void onActivityLaunchOnSecondaryDisplayRerouted(ActivityManager.RunningTaskInfo var1, int var2) throws RemoteException;

    public void onTaskCreated(int var1, ComponentName var2) throws RemoteException;

    public void onTaskRemoved(int var1) throws RemoteException;

    public void onTaskMovedToFront(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onTaskDescriptionChanged(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onActivityRequestedOrientationChanged(int var1, int var2) throws RemoteException;

    public void onTaskRemovalStarted(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onTaskProfileLocked(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onTaskSnapshotChanged(int var1, TaskSnapshot var2) throws RemoteException;

    public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onTaskDisplayChanged(int var1, int var2) throws RemoteException;

    public void onRecentTaskListUpdated() throws RemoteException;

    public void onRecentTaskListFrozenChanged(boolean var1) throws RemoteException;

    public void onTaskFocusChanged(int var1, boolean var2) throws RemoteException;

    public void onTaskRequestedOrientationChanged(int var1, int var2) throws RemoteException;

    public void onActivityRotation(int var1) throws RemoteException;

    public void onTaskMovedToBack(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onLockTaskModeChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskStackListener {
        public static final String DESCRIPTOR = "android.app.ITaskStackListener";
        static final int TRANSACTION_onTaskStackChanged = 1;
        static final int TRANSACTION_onActivityPinned = 2;
        static final int TRANSACTION_onActivityUnpinned = 3;
        static final int TRANSACTION_onActivityRestartAttempt = 4;
        static final int TRANSACTION_onActivityForcedResizable = 5;
        static final int TRANSACTION_onActivityDismissingDockedTask = 6;
        static final int TRANSACTION_onActivityLaunchOnSecondaryDisplayFailed = 7;
        static final int TRANSACTION_onActivityLaunchOnSecondaryDisplayRerouted = 8;
        static final int TRANSACTION_onTaskCreated = 9;
        static final int TRANSACTION_onTaskRemoved = 10;
        static final int TRANSACTION_onTaskMovedToFront = 11;
        static final int TRANSACTION_onTaskDescriptionChanged = 12;
        static final int TRANSACTION_onActivityRequestedOrientationChanged = 13;
        static final int TRANSACTION_onTaskRemovalStarted = 14;
        static final int TRANSACTION_onTaskProfileLocked = 15;
        static final int TRANSACTION_onTaskSnapshotChanged = 16;
        static final int TRANSACTION_onBackPressedOnTaskRoot = 17;
        static final int TRANSACTION_onTaskDisplayChanged = 18;
        static final int TRANSACTION_onRecentTaskListUpdated = 19;
        static final int TRANSACTION_onRecentTaskListFrozenChanged = 20;
        static final int TRANSACTION_onTaskFocusChanged = 21;
        static final int TRANSACTION_onTaskRequestedOrientationChanged = 22;
        static final int TRANSACTION_onActivityRotation = 23;
        static final int TRANSACTION_onTaskMovedToBack = 24;
        static final int TRANSACTION_onLockTaskModeChanged = 25;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITaskStackListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITaskStackListener) {
                return (ITaskStackListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTaskStackChanged";
                }
                case 2: {
                    return "onActivityPinned";
                }
                case 3: {
                    return "onActivityUnpinned";
                }
                case 4: {
                    return "onActivityRestartAttempt";
                }
                case 5: {
                    return "onActivityForcedResizable";
                }
                case 6: {
                    return "onActivityDismissingDockedTask";
                }
                case 7: {
                    return "onActivityLaunchOnSecondaryDisplayFailed";
                }
                case 8: {
                    return "onActivityLaunchOnSecondaryDisplayRerouted";
                }
                case 9: {
                    return "onTaskCreated";
                }
                case 10: {
                    return "onTaskRemoved";
                }
                case 11: {
                    return "onTaskMovedToFront";
                }
                case 12: {
                    return "onTaskDescriptionChanged";
                }
                case 13: {
                    return "onActivityRequestedOrientationChanged";
                }
                case 14: {
                    return "onTaskRemovalStarted";
                }
                case 15: {
                    return "onTaskProfileLocked";
                }
                case 16: {
                    return "onTaskSnapshotChanged";
                }
                case 17: {
                    return "onBackPressedOnTaskRoot";
                }
                case 18: {
                    return "onTaskDisplayChanged";
                }
                case 19: {
                    return "onRecentTaskListUpdated";
                }
                case 20: {
                    return "onRecentTaskListFrozenChanged";
                }
                case 21: {
                    return "onTaskFocusChanged";
                }
                case 22: {
                    return "onTaskRequestedOrientationChanged";
                }
                case 23: {
                    return "onActivityRotation";
                }
                case 24: {
                    return "onTaskMovedToBack";
                }
                case 25: {
                    return "onLockTaskModeChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onTaskStackChanged();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActivityPinned(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    this.onActivityUnpinned();
                    break;
                }
                case 4: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onActivityRestartAttempt(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActivityForcedResizable(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    this.onActivityDismissingDockedTask();
                    break;
                }
                case 7: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActivityLaunchOnSecondaryDisplayFailed(_arg0, _arg1);
                    break;
                }
                case 8: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActivityLaunchOnSecondaryDisplayRerouted(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskCreated(_arg0, _arg1);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTaskRemoved(_arg0);
                    break;
                }
                case 11: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskMovedToFront(_arg0);
                    break;
                }
                case 12: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskDescriptionChanged(_arg0);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActivityRequestedOrientationChanged(_arg0, _arg1);
                    break;
                }
                case 14: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskRemovalStarted(_arg0);
                    break;
                }
                case 15: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskProfileLocked(_arg0);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    TaskSnapshot _arg1 = data.readTypedObject(TaskSnapshot.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskSnapshotChanged(_arg0, _arg1);
                    break;
                }
                case 17: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBackPressedOnTaskRoot(_arg0);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTaskDisplayChanged(_arg0, _arg1);
                    break;
                }
                case 19: {
                    this.onRecentTaskListUpdated();
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onRecentTaskListFrozenChanged(_arg0);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onTaskFocusChanged(_arg0, _arg1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTaskRequestedOrientationChanged(_arg0, _arg1);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActivityRotation(_arg0);
                    break;
                }
                case 24: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskMovedToBack(_arg0);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLockTaskModeChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements ITaskStackListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onTaskStackChanged() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityPinned(String packageName, int userId, int taskId, int stackId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(taskId);
                    _data.writeInt(stackId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onActivityUnpinned() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityRestartAttempt(ActivityManager.RunningTaskInfo task2, boolean homeTaskVisible, boolean clearedTask, boolean wasVisible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(task2, 0);
                    _data.writeBoolean(homeTaskVisible);
                    _data.writeBoolean(clearedTask);
                    _data.writeBoolean(wasVisible);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityForcedResizable(String packageName, int taskId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(taskId);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onActivityDismissingDockedTask() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityLaunchOnSecondaryDisplayFailed(ActivityManager.RunningTaskInfo taskInfo, int requestedDisplayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    _data.writeInt(requestedDisplayId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityLaunchOnSecondaryDisplayRerouted(ActivityManager.RunningTaskInfo taskInfo, int requestedDisplayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    _data.writeInt(requestedDisplayId);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskCreated(int taskId, ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeTypedObject(componentName, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskRemoved(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskMovedToFront(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskDescriptionChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityRequestedOrientationChanged(int taskId, int requestedOrientation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeInt(requestedOrientation);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskRemovalStarted(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskProfileLocked(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskSnapshotChanged(int taskId, TaskSnapshot snapshot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeTypedObject(snapshot, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskDisplayChanged(int taskId, int newDisplayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeInt(newDisplayId);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRecentTaskListUpdated() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecentTaskListFrozenChanged(boolean frozen) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(frozen);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskFocusChanged(int taskId, boolean focused) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeBoolean(focused);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskRequestedOrientationChanged(int taskId, int requestedOrientation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeInt(requestedOrientation);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityRotation(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskMovedToBack(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLockTaskModeChanged(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskStackListener {
        @Override
        public void onTaskStackChanged() throws RemoteException {
        }

        @Override
        public void onActivityPinned(String packageName, int userId, int taskId, int stackId) throws RemoteException {
        }

        @Override
        public void onActivityUnpinned() throws RemoteException {
        }

        @Override
        public void onActivityRestartAttempt(ActivityManager.RunningTaskInfo task2, boolean homeTaskVisible, boolean clearedTask, boolean wasVisible) throws RemoteException {
        }

        @Override
        public void onActivityForcedResizable(String packageName, int taskId, int reason) throws RemoteException {
        }

        @Override
        public void onActivityDismissingDockedTask() throws RemoteException {
        }

        @Override
        public void onActivityLaunchOnSecondaryDisplayFailed(ActivityManager.RunningTaskInfo taskInfo, int requestedDisplayId) throws RemoteException {
        }

        @Override
        public void onActivityLaunchOnSecondaryDisplayRerouted(ActivityManager.RunningTaskInfo taskInfo, int requestedDisplayId) throws RemoteException {
        }

        @Override
        public void onTaskCreated(int taskId, ComponentName componentName) throws RemoteException {
        }

        @Override
        public void onTaskRemoved(int taskId) throws RemoteException {
        }

        @Override
        public void onTaskMovedToFront(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onTaskDescriptionChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onActivityRequestedOrientationChanged(int taskId, int requestedOrientation) throws RemoteException {
        }

        @Override
        public void onTaskRemovalStarted(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onTaskProfileLocked(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onTaskSnapshotChanged(int taskId, TaskSnapshot snapshot) throws RemoteException {
        }

        @Override
        public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onTaskDisplayChanged(int taskId, int newDisplayId) throws RemoteException {
        }

        @Override
        public void onRecentTaskListUpdated() throws RemoteException {
        }

        @Override
        public void onRecentTaskListFrozenChanged(boolean frozen) throws RemoteException {
        }

        @Override
        public void onTaskFocusChanged(int taskId, boolean focused) throws RemoteException {
        }

        @Override
        public void onTaskRequestedOrientationChanged(int taskId, int requestedOrientation) throws RemoteException {
        }

        @Override
        public void onActivityRotation(int displayId) throws RemoteException {
        }

        @Override
        public void onTaskMovedToBack(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onLockTaskModeChanged(int mode) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

