/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityClient;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.admin.DevicePolicyManager;
import android.app.admin.PasswordMetrics;
import android.app.trust.ITrustManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.ArrayMap;
import android.util.Log;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IKeyguardLockedStateListener;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.IWeakEscrowTokenActivatedListener;
import com.android.internal.widget.IWeakEscrowTokenRemovedListener;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.VerifyCredentialResponse;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class KeyguardManager {
    private static final String TAG = "KeyguardManager";
    private final Context mContext;
    private final LockPatternUtils mLockPatternUtils;
    private final IWindowManager mWM;
    private final IActivityManager mAm;
    private final ITrustManager mTrustManager;
    private final INotificationManager mNotificationManager;
    private final ArrayMap<WeakEscrowTokenRemovedListener, IWeakEscrowTokenRemovedListener> mListeners = new ArrayMap();
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER = "android.app.action.CONFIRM_DEVICE_CREDENTIAL_WITH_USER";
    public static final String ACTION_CONFIRM_FRP_CREDENTIAL = "android.app.action.CONFIRM_FRP_CREDENTIAL";
    public static final String EXTRA_TITLE = "android.app.extra.TITLE";
    public static final String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";
    public static final String EXTRA_ALTERNATE_BUTTON_LABEL = "android.app.extra.ALTERNATE_BUTTON_LABEL";
    public static final int RESULT_ALTERNATE = 1;
    public static final String EXTRA_DISALLOW_BIOMETRICS_IF_POLICY_EXISTS = "check_dpm";
    @SystemApi
    public static final int PASSWORD = 0;
    @SystemApi
    public static final int PIN = 1;
    @SystemApi
    public static final int PATTERN = 2;
    private final IKeyguardLockedStateListener mIKeyguardLockedStateListener = new IKeyguardLockedStateListener.Stub(){

        @Override
        public void onKeyguardLockedStateChanged(boolean isKeyguardLocked) {
            KeyguardManager.this.mKeyguardLockedStateListeners.forEach((listener2, executor) -> executor.execute(() -> listener2.onKeyguardLockedStateChanged(isKeyguardLocked)));
        }
    };
    private final ArrayMap<KeyguardLockedStateListener, Executor> mKeyguardLockedStateListeners = new ArrayMap();

    @Deprecated
    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description) {
        if (!this.isDeviceSecure()) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId) {
        if (!this.isDeviceSecure(userId)) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra("android.intent.extra.USER_ID", userId);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId, boolean disallowBiometricsIfPolicyExists) {
        Intent intent = this.createConfirmDeviceCredentialIntent(title, description, userId);
        if (intent != null) {
            intent.putExtra(EXTRA_DISALLOW_BIOMETRICS_IF_POLICY_EXISTS, disallowBiometricsIfPolicyExists);
        }
        return intent;
    }

    @SystemApi
    public Intent createConfirmFactoryResetCredentialIntent(CharSequence title, CharSequence description, CharSequence alternateButtonLabel) {
        if (!LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            Log.w(TAG, "Factory reset credentials not supported.");
            throw new UnsupportedOperationException("not supported on this device");
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0) {
            Log.e(TAG, "Factory reset credential cannot be verified after provisioning.");
            throw new IllegalStateException("must not be provisioned yet");
        }
        try {
            IPersistentDataBlockService pdb = IPersistentDataBlockService.Stub.asInterface(ServiceManager.getService("persistent_data_block"));
            if (pdb == null) {
                Log.e(TAG, "No persistent data block service");
                throw new UnsupportedOperationException("not supported on this device");
            }
            if (!pdb.hasFrpCredentialHandle()) {
                Log.i(TAG, "The persistent data block does not have a factory reset credential.");
                return null;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Intent intent = new Intent(ACTION_CONFIRM_FRP_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra(EXTRA_ALTERNATE_BUTTON_LABEL, alternateButtonLabel);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_KEYGUARD_SECURE_NOTIFICATIONS")
    public void setPrivateNotificationsAllowed(boolean allow) {
        try {
            this.mNotificationManager.setPrivateNotificationsAllowed(allow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_KEYGUARD_SECURE_NOTIFICATIONS")
    public boolean getPrivateNotificationsAllowed() {
        try {
            return this.mNotificationManager.getPrivateNotificationsAllowed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private String getSettingsPackageForIntent(Intent intent) {
        int i = 0;
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentActivities(intent, 0x100000);
        if (i < resolveInfos.size()) {
            return resolveInfos.get((int)i).activityInfo.packageName;
        }
        return "com.android.settings";
    }

    KeyguardManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mWM = WindowManagerGlobal.getWindowManagerService();
        this.mAm = ActivityManager.getService();
        this.mTrustManager = ITrustManager.Stub.asInterface(ServiceManager.getServiceOrThrow("trust"));
        this.mNotificationManager = INotificationManager.Stub.asInterface(ServiceManager.getServiceOrThrow("notification"));
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String tag2) {
        return new KeyguardLock(tag2);
    }

    public boolean isKeyguardLocked() {
        try {
            return this.mWM.isKeyguardLocked();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean isKeyguardSecure() {
        try {
            return this.mWM.isKeyguardSecure(this.mContext.getUserId());
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean inKeyguardRestrictedInputMode() {
        return this.isKeyguardLocked();
    }

    public boolean isDeviceLocked() {
        return this.isDeviceLocked(this.mContext.getUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean isDeviceLocked(int userId) {
        try {
            return this.mTrustManager.isDeviceLocked(userId, this.mContext.getAssociatedDisplayId());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isDeviceSecure() {
        return this.isDeviceSecure(this.mContext.getUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isDeviceSecure(int userId) {
        try {
            return this.mTrustManager.isDeviceSecure(userId, this.mContext.getAssociatedDisplayId());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void requestDismissKeyguard(Activity activity, KeyguardDismissCallback callback2) {
        this.requestDismissKeyguard(activity, null, callback2);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SHOW_KEYGUARD_MESSAGE")
    public void requestDismissKeyguard(final Activity activity, CharSequence message, final KeyguardDismissCallback callback2) {
        ActivityClient.getInstance().dismissKeyguard(activity.getActivityToken(), new IKeyguardDismissCallback.Stub(){

            @Override
            public void onDismissError() throws RemoteException {
                if (callback2 != null && !activity.isDestroyed()) {
                    activity.mHandler.post(callback2::onDismissError);
                }
            }

            @Override
            public void onDismissSucceeded() throws RemoteException {
                if (callback2 != null && !activity.isDestroyed()) {
                    activity.mHandler.post(callback2::onDismissSucceeded);
                }
            }

            @Override
            public void onDismissCancelled() throws RemoteException {
                if (callback2 != null && !activity.isDestroyed()) {
                    activity.mHandler.post(callback2::onDismissCancelled);
                }
            }
        }, message);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.DISABLE_KEYGUARD")
    public void exitKeyguardSecurely(final OnKeyguardExitResult callback2) {
        try {
            this.mWM.exitKeyguardSecurely(new IOnKeyguardExitResult.Stub(){

                @Override
                public void onKeyguardExitResult(boolean success) throws RemoteException {
                    if (callback2 != null) {
                        callback2.onKeyguardExitResult(success);
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean checkInitialLockMethodUsage() {
        if (!this.hasPermission("android.permission.SET_INITIAL_LOCK")) {
            throw new SecurityException("Requires SET_INITIAL_LOCK permission.");
        }
        return true;
    }

    private boolean hasPermission(String permission2) {
        return 0 == this.mContext.checkCallingOrSelfPermission(permission2);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_INITIAL_LOCK")
    public boolean isValidLockPasswordComplexity(@LockTypes int lockType, byte[] password, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return false;
        }
        complexity = PasswordMetrics.sanitizeComplexityLevel(complexity);
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        PasswordMetrics adminMetrics = devicePolicyManager.getPasswordMinimumMetrics(this.mContext.getUserId());
        boolean isPinOrPattern = lockType != 0;
        return PasswordMetrics.validatePassword(adminMetrics, complexity, isPinOrPattern, password).size() == 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_INITIAL_LOCK")
    public int getMinLockLength(boolean isPin, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return -1;
        }
        complexity = PasswordMetrics.sanitizeComplexityLevel(complexity);
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        PasswordMetrics adminMetrics = devicePolicyManager.getPasswordMinimumMetrics(this.mContext.getUserId());
        PasswordMetrics minMetrics = PasswordMetrics.applyComplexity(adminMetrics, isPin, complexity);
        return minMetrics.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.SET_INITIAL_LOCK")
    public boolean setLock(@LockTypes int lockType, byte[] password, int complexity) {
        boolean success;
        if (!this.checkInitialLockMethodUsage()) {
            return false;
        }
        int userId = this.mContext.getUserId();
        if (this.isDeviceSecure(userId)) {
            Log.e(TAG, "Password already set, rejecting call to setLock");
            return false;
        }
        if (!this.isValidLockPasswordComplexity(lockType, password, complexity)) {
            Log.e(TAG, "Password is not valid, rejecting call to setLock");
            return false;
        }
        try {
            LockscreenCredential credential = this.createLockscreenCredential(lockType, password);
            success = this.mLockPatternUtils.setLockCredential(credential, LockscreenCredential.createNone(), userId);
        }
        catch (Exception e) {
            Log.e(TAG, "Save lock exception", e);
            success = false;
        }
        finally {
            Arrays.fill(password, (byte)0);
        }
        return success;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public long addWeakEscrowToken(byte[] token, UserHandle user, final Executor executor, final WeakEscrowTokenActivatedListener listener2) {
        Objects.requireNonNull(token, "Token cannot be null.");
        Objects.requireNonNull(user, "User cannot be null.");
        Objects.requireNonNull(executor, "Executor cannot be null.");
        Objects.requireNonNull(listener2, "Listener cannot be null.");
        int userId = user.getIdentifier();
        IWeakEscrowTokenActivatedListener.Stub internalListener = new IWeakEscrowTokenActivatedListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWeakEscrowTokenActivated(long handle, int userId) {
                UserHandle user = UserHandle.of(userId);
                long restoreToken = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener2.onWeakEscrowTokenActivated(handle, user));
                }
                finally {
                    Binder.restoreCallingIdentity(restoreToken);
                }
                Log.i(KeyguardManager.TAG, "Weak escrow token activated.");
            }
        };
        return this.mLockPatternUtils.addWeakEscrowToken(token, userId, internalListener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean removeWeakEscrowToken(long handle, UserHandle user) {
        Objects.requireNonNull(user, "User cannot be null.");
        return this.mLockPatternUtils.removeWeakEscrowToken(handle, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean isWeakEscrowTokenActive(long handle, UserHandle user) {
        Objects.requireNonNull(user, "User cannot be null.");
        return this.mLockPatternUtils.isWeakEscrowTokenActive(handle, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean isWeakEscrowTokenValid(long handle, byte[] token, UserHandle user) {
        Objects.requireNonNull(token, "Token cannot be null.");
        Objects.requireNonNull(user, "User cannot be null.");
        return this.mLockPatternUtils.isWeakEscrowTokenValid(handle, token, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean registerWeakEscrowTokenRemovedListener(final Executor executor, final WeakEscrowTokenRemovedListener listener2) {
        Objects.requireNonNull(listener2, "Listener cannot be null.");
        Objects.requireNonNull(executor, "Executor cannot be null.");
        Preconditions.checkArgument(!this.mListeners.containsKey(listener2), "Listener already registered: %s", listener2);
        IWeakEscrowTokenRemovedListener.Stub internalListener = new IWeakEscrowTokenRemovedListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWeakEscrowTokenRemoved(long handle, int userId) {
                UserHandle user = UserHandle.of(userId);
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener2.onWeakEscrowTokenRemoved(handle, user));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
        if (this.mLockPatternUtils.registerWeakEscrowTokenRemovedListener(internalListener)) {
            this.mListeners.put(listener2, internalListener);
            return true;
        }
        Log.e(TAG, "Listener failed to register");
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean unregisterWeakEscrowTokenRemovedListener(WeakEscrowTokenRemovedListener listener2) {
        Objects.requireNonNull(listener2, "Listener cannot be null.");
        IWeakEscrowTokenRemovedListener internalListener = this.mListeners.get(listener2);
        Preconditions.checkArgument(internalListener != null, "Listener was not registered");
        if (this.mLockPatternUtils.unregisterWeakEscrowTokenRemovedListener(internalListener)) {
            this.mListeners.remove(listener2);
            return true;
        }
        Log.e(TAG, "Listener failed to unregister.");
        return false;
    }

    @RequiresPermission(anyOf={"android.permission.SET_AND_VERIFY_LOCKSCREEN_CREDENTIALS", "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE"})
    public boolean setLock(@LockTypes int newLockType, byte[] newPassword, @LockTypes int currentLockType, byte[] currentPassword) {
        int userId = this.mContext.getUserId();
        LockscreenCredential currentCredential = this.createLockscreenCredential(currentLockType, currentPassword);
        LockscreenCredential newCredential = this.createLockscreenCredential(newLockType, newPassword);
        return this.mLockPatternUtils.setLockCredential(newCredential, currentCredential, userId);
    }

    @RequiresPermission(anyOf={"android.permission.SET_AND_VERIFY_LOCKSCREEN_CREDENTIALS", "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE"})
    public boolean checkLock(@LockTypes int lockType, byte[] password) {
        LockscreenCredential credential = this.createLockscreenCredential(lockType, password);
        VerifyCredentialResponse response = this.mLockPatternUtils.verifyCredential(credential, this.mContext.getUserId(), 0);
        if (response == null) {
            return false;
        }
        return response.getResponseCode() == 0;
    }

    private LockscreenCredential createLockscreenCredential(@LockTypes int lockType, byte[] password) {
        if (password == null) {
            return LockscreenCredential.createNone();
        }
        switch (lockType) {
            case 0: {
                String passwordStr = new String(password, Charset.forName("UTF-8"));
                return LockscreenCredential.createPassword(passwordStr);
            }
            case 1: {
                String pinStr = new String(password);
                return LockscreenCredential.createPin(pinStr);
            }
            case 2: {
                List<LockPatternView.Cell> pattern = LockPatternUtils.byteArrayToPattern(password);
                return LockscreenCredential.createPattern(pattern);
            }
        }
        throw new IllegalArgumentException("Unknown lock type " + lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void addKeyguardLockedStateListener(Executor executor, KeyguardLockedStateListener listener2) {
        ArrayMap<KeyguardLockedStateListener, Executor> arrayMap = this.mKeyguardLockedStateListeners;
        synchronized (arrayMap) {
            this.mKeyguardLockedStateListeners.put(listener2, executor);
            if (this.mKeyguardLockedStateListeners.size() > 1) {
                return;
            }
            try {
                this.mWM.addKeyguardLockedStateListener(this.mIKeyguardLockedStateListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void removeKeyguardLockedStateListener(KeyguardLockedStateListener listener2) {
        ArrayMap<KeyguardLockedStateListener, Executor> arrayMap = this.mKeyguardLockedStateListeners;
        synchronized (arrayMap) {
            this.mKeyguardLockedStateListeners.remove(listener2);
            if (!this.mKeyguardLockedStateListeners.isEmpty()) {
                return;
            }
            try {
                this.mWM.removeKeyguardLockedStateListener(this.mIKeyguardLockedStateListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @FunctionalInterface
    public static interface KeyguardLockedStateListener {
        public void onKeyguardLockedStateChanged(boolean var1);
    }

    @SystemApi
    public static interface WeakEscrowTokenRemovedListener {
        public void onWeakEscrowTokenRemoved(long var1, UserHandle var3);
    }

    @SystemApi
    public static interface WeakEscrowTokenActivatedListener {
        public void onWeakEscrowTokenActivated(long var1, UserHandle var3);
    }

    public static abstract class KeyguardDismissCallback {
        public void onDismissError() {
        }

        public void onDismissSucceeded() {
        }

        public void onDismissCancelled() {
        }
    }

    @Deprecated
    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    @Deprecated
    public class KeyguardLock {
        private final IBinder mToken = new Binder();
        private final String mTag;

        KeyguardLock(String tag2) {
            this.mTag = tag2;
        }

        @RequiresPermission(value="android.permission.DISABLE_KEYGUARD")
        public void disableKeyguard() {
            try {
                KeyguardManager.this.mWM.disableKeyguard(this.mToken, this.mTag, KeyguardManager.this.mContext.getUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @RequiresPermission(value="android.permission.DISABLE_KEYGUARD")
        public void reenableKeyguard() {
            try {
                KeyguardManager.this.mWM.reenableKeyguard(this.mToken, KeyguardManager.this.mContext.getUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static @interface LockTypes {
    }
}

