/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.NotificationChannel;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.proto.ProtoOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationChannelGroup
implements Parcelable {
    public static final int MAX_TEXT_LENGTH = 1000;
    private static final String TAG_GROUP = "channelGroup";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESC = "desc";
    private static final String ATT_ID = "id";
    private static final String ATT_BLOCKED = "blocked";
    private static final String ATT_USER_LOCKED = "locked";
    public static final int USER_LOCKED_BLOCKED_STATE = 1;
    @UnsupportedAppUsage
    private final String mId;
    private CharSequence mName;
    private String mDescription;
    private boolean mBlocked;
    private List<NotificationChannel> mChannels = new ArrayList<NotificationChannel>();
    private int mUserLockedFields;
    public static final Parcelable.Creator<NotificationChannelGroup> CREATOR = new Parcelable.Creator<NotificationChannelGroup>(){

        @Override
        public NotificationChannelGroup createFromParcel(Parcel in) {
            return new NotificationChannelGroup(in);
        }

        public NotificationChannelGroup[] newArray(int size) {
            return new NotificationChannelGroup[size];
        }
    };

    public NotificationChannelGroup(String id2, CharSequence name) {
        this.mId = this.getTrimmedString(id2);
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
    }

    protected NotificationChannelGroup(Parcel in) {
        this.mId = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : null;
        this.mName = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : "";
        this.mDescription = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : null;
        in.readParcelableList(this.mChannels, NotificationChannel.class.getClassLoader(), NotificationChannel.class);
        this.mBlocked = in.readBoolean();
        this.mUserLockedFields = in.readInt();
    }

    private String getTrimmedString(String input) {
        if (input != null && input.length() > 1000) {
            return input.substring(0, 1000);
        }
        return input;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mName != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mName.toString());
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mDescription != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mDescription);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeParcelableList(this.mChannels, flags);
        dest.writeBoolean(this.mBlocked);
        dest.writeInt(this.mUserLockedFields);
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public List<NotificationChannel> getChannels() {
        return this.mChannels;
    }

    public boolean isBlocked() {
        return this.mBlocked;
    }

    public void setDescription(String description) {
        this.mDescription = this.getTrimmedString(description);
    }

    public void setBlocked(boolean blocked) {
        this.mBlocked = blocked;
    }

    public void addChannel(NotificationChannel channel) {
        this.mChannels.add(channel);
    }

    public void setChannels(List<NotificationChannel> channels) {
        this.mChannels = channels;
    }

    public void lockFields(int field) {
        this.mUserLockedFields |= field;
    }

    public void unlockFields(int field) {
        this.mUserLockedFields &= ~field;
    }

    public int getUserLockedFields() {
        return this.mUserLockedFields;
    }

    public void populateFromXml(TypedXmlPullParser parser) {
        this.setDescription(parser.getAttributeValue(null, ATT_DESC));
        this.setBlocked(parser.getAttributeBoolean(null, ATT_BLOCKED, false));
    }

    public void writeXml(TypedXmlSerializer out) throws IOException {
        out.startTag(null, TAG_GROUP);
        out.attribute(null, ATT_ID, this.getId());
        if (this.getName() != null) {
            out.attribute(null, ATT_NAME, this.getName().toString());
        }
        if (this.getDescription() != null) {
            out.attribute(null, ATT_DESC, this.getDescription().toString());
        }
        out.attributeBoolean(null, ATT_BLOCKED, this.isBlocked());
        out.attributeInt(null, ATT_USER_LOCKED, this.mUserLockedFields);
        out.endTag(null, TAG_GROUP);
    }

    @SystemApi
    public JSONObject toJson() throws JSONException {
        JSONObject record = new JSONObject();
        record.put(ATT_ID, this.getId());
        record.put(ATT_NAME, this.getName());
        record.put(ATT_DESC, this.getDescription());
        record.put(ATT_BLOCKED, this.isBlocked());
        record.put(ATT_USER_LOCKED, this.mUserLockedFields);
        return record;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannelGroup that = (NotificationChannelGroup)o;
        return this.isBlocked() == that.isBlocked() && this.mUserLockedFields == that.mUserLockedFields && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getChannels(), that.getChannels());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.getDescription(), this.isBlocked(), this.getChannels(), this.mUserLockedFields);
    }

    public NotificationChannelGroup clone() {
        NotificationChannelGroup cloned = new NotificationChannelGroup(this.getId(), this.getName());
        cloned.setDescription(this.getDescription());
        cloned.setBlocked(this.isBlocked());
        cloned.setChannels(this.getChannels());
        cloned.lockFields(this.mUserLockedFields);
        return cloned;
    }

    public String toString() {
        return "NotificationChannelGroup{mId='" + this.mId + '\'' + ", mName=" + this.mName + ", mDescription=" + (!TextUtils.isEmpty(this.mDescription) ? "hasDescription " : "") + ", mBlocked=" + this.mBlocked + ", mChannels=" + this.mChannels + ", mUserLockedFields=" + this.mUserLockedFields + '}';
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mId);
        proto.write(1138166333442L, this.mName.toString());
        proto.write(1138166333443L, this.mDescription);
        proto.write(1133871366148L, this.mBlocked);
        for (NotificationChannel channel : this.mChannels) {
            channel.dumpDebug(proto, 2246267895813L);
        }
        proto.end(token);
    }
}

