/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.RemoteAction;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Rational;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PictureInPictureParams
implements Parcelable {
    private Rational mAspectRatio;
    private Rational mExpandedAspectRatio;
    private List<RemoteAction> mUserActions;
    private RemoteAction mCloseAction;
    private Rect mSourceRectHint;
    private Boolean mAutoEnterEnabled;
    private Boolean mSeamlessResizeEnabled;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private Boolean mIsLaunchIntoPip;
    public static final Parcelable.Creator<PictureInPictureParams> CREATOR = new Parcelable.Creator<PictureInPictureParams>(){

        @Override
        public PictureInPictureParams createFromParcel(Parcel in) {
            return new PictureInPictureParams(in);
        }

        public PictureInPictureParams[] newArray(int size) {
            return new PictureInPictureParams[size];
        }
    };

    PictureInPictureParams() {
    }

    PictureInPictureParams(Parcel in) {
        this.mAspectRatio = this.readRationalFromParcel(in);
        this.mExpandedAspectRatio = this.readRationalFromParcel(in);
        if (in.readInt() != 0) {
            this.mUserActions = new ArrayList<RemoteAction>();
            in.readTypedList(this.mUserActions, RemoteAction.CREATOR);
        }
        this.mCloseAction = in.readTypedObject(RemoteAction.CREATOR);
        if (in.readInt() != 0) {
            this.mSourceRectHint = Rect.CREATOR.createFromParcel(in);
        }
        if (in.readInt() != 0) {
            this.mAutoEnterEnabled = in.readBoolean();
        }
        if (in.readInt() != 0) {
            this.mSeamlessResizeEnabled = in.readBoolean();
        }
        if (in.readInt() != 0) {
            this.mTitle = in.readCharSequence();
        }
        if (in.readInt() != 0) {
            this.mSubtitle = in.readCharSequence();
        }
        if (in.readInt() != 0) {
            this.mIsLaunchIntoPip = in.readBoolean();
        }
    }

    PictureInPictureParams(Rational aspectRatio, Rational expandedAspectRatio, List<RemoteAction> actions2, RemoteAction closeAction, Rect sourceRectHint, Boolean autoEnterEnabled, Boolean seamlessResizeEnabled, CharSequence title, CharSequence subtitle, Boolean isLaunchIntoPip) {
        this.mAspectRatio = aspectRatio;
        this.mExpandedAspectRatio = expandedAspectRatio;
        this.mUserActions = actions2;
        this.mCloseAction = closeAction;
        this.mSourceRectHint = sourceRectHint;
        this.mAutoEnterEnabled = autoEnterEnabled;
        this.mSeamlessResizeEnabled = seamlessResizeEnabled;
        this.mTitle = title;
        this.mSubtitle = subtitle;
        this.mIsLaunchIntoPip = isLaunchIntoPip;
    }

    public PictureInPictureParams(PictureInPictureParams other) {
        this(other.mAspectRatio, other.mExpandedAspectRatio, other.mUserActions, other.mCloseAction, other.hasSourceBoundsHint() ? new Rect(other.getSourceRectHint()) : null, other.mAutoEnterEnabled, other.mSeamlessResizeEnabled, other.mTitle, other.mSubtitle, other.mIsLaunchIntoPip);
    }

    public void copyOnlySet(PictureInPictureParams otherArgs) {
        if (otherArgs.hasSetAspectRatio()) {
            this.mAspectRatio = otherArgs.mAspectRatio;
        }
        this.mExpandedAspectRatio = otherArgs.mExpandedAspectRatio;
        if (otherArgs.hasSetActions()) {
            this.mUserActions = otherArgs.mUserActions;
        }
        if (otherArgs.hasSetCloseAction()) {
            this.mCloseAction = otherArgs.mCloseAction;
        }
        if (otherArgs.hasSourceBoundsHint()) {
            this.mSourceRectHint = new Rect(otherArgs.getSourceRectHint());
        }
        if (otherArgs.mAutoEnterEnabled != null) {
            this.mAutoEnterEnabled = otherArgs.mAutoEnterEnabled;
        }
        if (otherArgs.mSeamlessResizeEnabled != null) {
            this.mSeamlessResizeEnabled = otherArgs.mSeamlessResizeEnabled;
        }
        if (otherArgs.hasSetTitle()) {
            this.mTitle = otherArgs.mTitle;
        }
        if (otherArgs.hasSetSubtitle()) {
            this.mSubtitle = otherArgs.mSubtitle;
        }
        if (otherArgs.mIsLaunchIntoPip != null) {
            this.mIsLaunchIntoPip = otherArgs.mIsLaunchIntoPip;
        }
    }

    public float getAspectRatioFloat() {
        if (this.mAspectRatio != null) {
            return this.mAspectRatio.floatValue();
        }
        return 0.0f;
    }

    public Rational getAspectRatio() {
        return this.mAspectRatio;
    }

    public boolean hasSetAspectRatio() {
        return this.mAspectRatio != null;
    }

    public float getExpandedAspectRatioFloat() {
        if (this.mExpandedAspectRatio != null) {
            return this.mExpandedAspectRatio.floatValue();
        }
        return 0.0f;
    }

    public Rational getExpandedAspectRatio() {
        return this.mExpandedAspectRatio;
    }

    public boolean hasSetExpandedAspectRatio() {
        return this.mExpandedAspectRatio != null;
    }

    public List<RemoteAction> getActions() {
        if (this.mUserActions == null) {
            return new ArrayList<RemoteAction>();
        }
        return this.mUserActions;
    }

    public boolean hasSetActions() {
        return this.mUserActions != null;
    }

    public RemoteAction getCloseAction() {
        return this.mCloseAction;
    }

    public boolean hasSetCloseAction() {
        return this.mCloseAction != null;
    }

    public void truncateActions(int size) {
        if (this.hasSetActions()) {
            this.mUserActions = this.mUserActions.subList(0, Math.min(this.mUserActions.size(), size));
        }
    }

    public Rect getSourceRectHint() {
        return this.mSourceRectHint;
    }

    public boolean hasSourceBoundsHint() {
        return this.mSourceRectHint != null && !this.mSourceRectHint.isEmpty();
    }

    public boolean isAutoEnterEnabled() {
        return this.mAutoEnterEnabled == null ? false : this.mAutoEnterEnabled;
    }

    public boolean isSeamlessResizeEnabled() {
        return this.mSeamlessResizeEnabled == null ? true : this.mSeamlessResizeEnabled;
    }

    public boolean hasSetTitle() {
        return this.mTitle != null;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public boolean hasSetSubtitle() {
        return this.mSubtitle != null;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public boolean isLaunchIntoPip() {
        return this.mIsLaunchIntoPip == null ? false : this.mIsLaunchIntoPip;
    }

    public boolean empty() {
        return !this.hasSourceBoundsHint() && !this.hasSetActions() && !this.hasSetCloseAction() && !this.hasSetAspectRatio() && !this.hasSetExpandedAspectRatio() && this.mAutoEnterEnabled == null && this.mSeamlessResizeEnabled == null && !this.hasSetTitle() && !this.hasSetSubtitle() && this.mIsLaunchIntoPip == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PictureInPictureParams)) {
            return false;
        }
        PictureInPictureParams that = (PictureInPictureParams)o;
        return Objects.equals(this.mAutoEnterEnabled, that.mAutoEnterEnabled) && Objects.equals(this.mSeamlessResizeEnabled, that.mSeamlessResizeEnabled) && Objects.equals(this.mAspectRatio, that.mAspectRatio) && Objects.equals(this.mExpandedAspectRatio, that.mExpandedAspectRatio) && Objects.equals(this.mUserActions, that.mUserActions) && Objects.equals(this.mCloseAction, that.mCloseAction) && Objects.equals(this.mSourceRectHint, that.mSourceRectHint) && Objects.equals(this.mTitle, that.mTitle) && Objects.equals(this.mSubtitle, that.mSubtitle) && Objects.equals(this.mIsLaunchIntoPip, that.mIsLaunchIntoPip);
    }

    public int hashCode() {
        return Objects.hash(this.mAspectRatio, this.mExpandedAspectRatio, this.mUserActions, this.mCloseAction, this.mSourceRectHint, this.mAutoEnterEnabled, this.mSeamlessResizeEnabled, this.mTitle, this.mSubtitle, this.mIsLaunchIntoPip);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.writeRationalToParcel(this.mAspectRatio, out);
        this.writeRationalToParcel(this.mExpandedAspectRatio, out);
        if (this.mUserActions != null) {
            out.writeInt(1);
            out.writeTypedList(this.mUserActions, 0);
        } else {
            out.writeInt(0);
        }
        out.writeTypedObject(this.mCloseAction, 0);
        if (this.mSourceRectHint != null) {
            out.writeInt(1);
            this.mSourceRectHint.writeToParcel(out, 0);
        } else {
            out.writeInt(0);
        }
        if (this.mAutoEnterEnabled != null) {
            out.writeInt(1);
            out.writeBoolean(this.mAutoEnterEnabled);
        } else {
            out.writeInt(0);
        }
        if (this.mSeamlessResizeEnabled != null) {
            out.writeInt(1);
            out.writeBoolean(this.mSeamlessResizeEnabled);
        } else {
            out.writeInt(0);
        }
        if (this.mTitle != null) {
            out.writeInt(1);
            out.writeCharSequence(this.mTitle);
        } else {
            out.writeInt(0);
        }
        if (this.mSubtitle != null) {
            out.writeInt(1);
            out.writeCharSequence(this.mSubtitle);
        } else {
            out.writeInt(0);
        }
        if (this.mIsLaunchIntoPip != null) {
            out.writeInt(1);
            out.writeBoolean(this.mIsLaunchIntoPip);
        } else {
            out.writeInt(0);
        }
    }

    private void writeRationalToParcel(Rational rational, Parcel out) {
        if (rational != null) {
            out.writeInt(1);
            out.writeInt(rational.getNumerator());
            out.writeInt(rational.getDenominator());
        } else {
            out.writeInt(0);
        }
    }

    private Rational readRationalFromParcel(Parcel in) {
        if (in.readInt() != 0) {
            return new Rational(in.readInt(), in.readInt());
        }
        return null;
    }

    public String toString() {
        return "PictureInPictureParams( aspectRatio=" + this.getAspectRatio() + " expandedAspectRatio=" + this.mExpandedAspectRatio + " sourceRectHint=" + this.getSourceRectHint() + " hasSetActions=" + this.hasSetActions() + " hasSetCloseAction=" + this.hasSetCloseAction() + " isAutoPipEnabled=" + this.isAutoEnterEnabled() + " isSeamlessResizeEnabled=" + this.isSeamlessResizeEnabled() + " title=" + this.getTitle() + " subtitle=" + this.getSubtitle() + " isLaunchIntoPip=" + this.isLaunchIntoPip() + ")";
    }

    public static class Builder {
        private Rational mAspectRatio;
        private Rational mExpandedAspectRatio;
        private List<RemoteAction> mUserActions;
        private RemoteAction mCloseAction;
        private Rect mSourceRectHint;
        private Boolean mAutoEnterEnabled;
        private Boolean mSeamlessResizeEnabled;
        private CharSequence mTitle;
        private CharSequence mSubtitle;
        private Boolean mIsLaunchIntoPip;

        public Builder() {
        }

        public Builder(PictureInPictureParams original) {
            this.mAspectRatio = original.mAspectRatio;
            this.mUserActions = original.mUserActions;
            this.mCloseAction = original.mCloseAction;
            this.mSourceRectHint = original.mSourceRectHint;
            this.mAutoEnterEnabled = original.mAutoEnterEnabled;
            this.mSeamlessResizeEnabled = original.mSeamlessResizeEnabled;
            this.mTitle = original.mTitle;
            this.mSubtitle = original.mSubtitle;
            this.mIsLaunchIntoPip = original.mIsLaunchIntoPip;
        }

        public Builder setAspectRatio(Rational aspectRatio) {
            this.mAspectRatio = aspectRatio;
            return this;
        }

        public Builder setExpandedAspectRatio(Rational expandedAspectRatio) {
            this.mExpandedAspectRatio = expandedAspectRatio;
            return this;
        }

        public Builder setActions(List<RemoteAction> actions2) {
            if (this.mUserActions != null) {
                this.mUserActions = null;
            }
            if (actions2 != null) {
                this.mUserActions = new ArrayList<RemoteAction>(actions2);
            }
            return this;
        }

        public Builder setCloseAction(RemoteAction action2) {
            this.mCloseAction = action2;
            return this;
        }

        public Builder setSourceRectHint(Rect launchBounds) {
            this.mSourceRectHint = launchBounds == null ? null : new Rect(launchBounds);
            return this;
        }

        public Builder setAutoEnterEnabled(boolean autoEnterEnabled) {
            this.mAutoEnterEnabled = autoEnterEnabled;
            return this;
        }

        public Builder setSeamlessResizeEnabled(boolean seamlessResizeEnabled) {
            this.mSeamlessResizeEnabled = seamlessResizeEnabled;
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setSubtitle(CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        Builder setIsLaunchIntoPip(boolean isLaunchIntoPip) {
            this.mIsLaunchIntoPip = isLaunchIntoPip;
            return this;
        }

        public PictureInPictureParams build() {
            PictureInPictureParams params = new PictureInPictureParams(this.mAspectRatio, this.mExpandedAspectRatio, this.mUserActions, this.mCloseAction, this.mSourceRectHint, this.mAutoEnterEnabled, this.mSeamlessResizeEnabled, this.mTitle, this.mSubtitle, this.mIsLaunchIntoPip);
            return params;
        }
    }
}

