/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class Vr2dDisplayProperties
implements Parcelable {
    public static final int FLAG_VIRTUAL_DISPLAY_ENABLED = 1;
    private final int mWidth;
    private final int mHeight;
    private final int mDpi;
    private final int mAddedFlags;
    private final int mRemovedFlags;
    public static final Parcelable.Creator<Vr2dDisplayProperties> CREATOR = new Parcelable.Creator<Vr2dDisplayProperties>(){

        @Override
        public Vr2dDisplayProperties createFromParcel(Parcel source) {
            return new Vr2dDisplayProperties(source);
        }

        public Vr2dDisplayProperties[] newArray(int size) {
            return new Vr2dDisplayProperties[size];
        }
    };

    public Vr2dDisplayProperties(int width2, int height2, int dpi2) {
        this(width2, height2, dpi2, 0, 0);
    }

    private Vr2dDisplayProperties(int width2, int height2, int dpi2, int flags, int removedFlags) {
        this.mWidth = width2;
        this.mHeight = height2;
        this.mDpi = dpi2;
        this.mAddedFlags = flags;
        this.mRemovedFlags = removedFlags;
    }

    public int hashCode() {
        int result = this.getWidth();
        result = 31 * result + this.getHeight();
        result = 31 * result + this.getDpi();
        return result;
    }

    public String toString() {
        return "Vr2dDisplayProperties{mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + ", mDpi=" + this.mDpi + ", flags=" + Vr2dDisplayProperties.toReadableFlags(this.mAddedFlags) + ", removed_flags=" + Vr2dDisplayProperties.toReadableFlags(this.mRemovedFlags) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vr2dDisplayProperties that = (Vr2dDisplayProperties)o;
        if (this.getAddedFlags() != that.getAddedFlags()) {
            return false;
        }
        if (this.getRemovedFlags() != that.getRemovedFlags()) {
            return false;
        }
        if (this.getWidth() != that.getWidth()) {
            return false;
        }
        if (this.getHeight() != that.getHeight()) {
            return false;
        }
        return this.getDpi() == that.getDpi();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mDpi);
        dest.writeInt(this.mAddedFlags);
        dest.writeInt(this.mRemovedFlags);
    }

    private Vr2dDisplayProperties(Parcel source) {
        this.mWidth = source.readInt();
        this.mHeight = source.readInt();
        this.mDpi = source.readInt();
        this.mAddedFlags = source.readInt();
        this.mRemovedFlags = source.readInt();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + this.toString());
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getDpi() {
        return this.mDpi;
    }

    public int getAddedFlags() {
        return this.mAddedFlags;
    }

    public int getRemovedFlags() {
        return this.mRemovedFlags;
    }

    private static String toReadableFlags(int flags) {
        String retval = "{";
        if ((flags & 1) == 1) {
            retval = retval + "enabled";
        }
        return retval + "}";
    }

    public static class Builder {
        private int mAddedFlags = 0;
        private int mRemovedFlags = 0;
        private int mWidth = -1;
        private int mHeight = -1;
        private int mDpi = -1;

        public Builder setDimensions(int width2, int height2, int dpi2) {
            this.mWidth = width2;
            this.mHeight = height2;
            this.mDpi = dpi2;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            if (enabled) {
                this.addFlags(1);
            } else {
                this.removeFlags(1);
            }
            return this;
        }

        public Builder addFlags(int flags) {
            this.mAddedFlags |= flags;
            this.mRemovedFlags &= ~flags;
            return this;
        }

        public Builder removeFlags(int flags) {
            this.mRemovedFlags |= flags;
            this.mAddedFlags &= ~flags;
            return this;
        }

        public Vr2dDisplayProperties build() {
            return new Vr2dDisplayProperties(this.mWidth, this.mHeight, this.mDpi, this.mAddedFlags, this.mRemovedFlags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Vr2dDisplayFlag {
    }
}

