/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Vr2dDisplayProperties;
import android.app.VrStateCallback;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.os.RemoteException;
import android.service.vr.IPersistentVrStateCallbacks;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.ArrayMap;
import java.util.Map;
import java.util.concurrent.Executor;

@SystemApi
public class VrManager {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final IVrManager mService;
    private Map<VrStateCallback, CallbackEntry> mCallbackMap = new ArrayMap<VrStateCallback, CallbackEntry>();

    public VrManager(IVrManager service) {
        this.mService = service;
    }

    @RequiresPermission(anyOf={"android.permission.RESTRICTED_VR_ACCESS", "android.permission.ACCESS_VR_STATE"})
    public void registerVrStateCallback(Executor executor, VrStateCallback callback2) {
        if (callback2 == null || this.mCallbackMap.containsKey(callback2)) {
            return;
        }
        CallbackEntry entry = new CallbackEntry(callback2, executor);
        this.mCallbackMap.put(callback2, entry);
        try {
            this.mService.registerListener(entry.mStateCallback);
            this.mService.registerPersistentVrStateListener(entry.mPersistentStateCallback);
        }
        catch (RemoteException e) {
            try {
                this.unregisterVrStateCallback(callback2);
            }
            catch (Exception ignore) {
                e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(anyOf={"android.permission.RESTRICTED_VR_ACCESS", "android.permission.ACCESS_VR_STATE"})
    public void unregisterVrStateCallback(VrStateCallback callback2) {
        CallbackEntry entry = this.mCallbackMap.remove(callback2);
        if (entry != null) {
            try {
                this.mService.unregisterListener(entry.mStateCallback);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                this.mService.unregisterPersistentVrStateListener(entry.mPersistentStateCallback);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @RequiresPermission(anyOf={"android.permission.RESTRICTED_VR_ACCESS", "android.permission.ACCESS_VR_STATE"})
    public boolean isVrModeEnabled() {
        try {
            return this.mService.getVrModeState();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @RequiresPermission(anyOf={"android.permission.RESTRICTED_VR_ACCESS", "android.permission.ACCESS_VR_STATE"})
    public boolean isPersistentVrModeEnabled() {
        try {
            return this.mService.getPersistentVrModeEnabled();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public void setPersistentVrModeEnabled(boolean enabled) {
        try {
            this.mService.setPersistentVrModeEnabled(enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public void setVr2dDisplayProperties(Vr2dDisplayProperties vr2dDisplayProp) {
        try {
            this.mService.setVr2dDisplayProperties(vr2dDisplayProp);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public void setAndBindVrCompositor(ComponentName componentName) {
        try {
            this.mService.setAndBindCompositor(componentName == null ? null : componentName.flattenToString());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_VR_MANAGER")
    public void setStandbyEnabled(boolean standby) {
        try {
            this.mService.setStandbyEnabled(standby);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public void setVrInputMethod(ComponentName componentName) {
    }

    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public int getVr2dDisplayId() {
        try {
            return this.mService.getVr2dDisplayId();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return -1;
        }
    }

    private static class CallbackEntry {
        final IVrStateCallbacks mStateCallback = new IVrStateCallbacks.Stub(){

            @Override
            public void onVrStateChanged(boolean enabled) {
                mExecutor.execute(() -> mCallback.onVrStateChanged(enabled));
            }
        };
        final IPersistentVrStateCallbacks mPersistentStateCallback = new IPersistentVrStateCallbacks.Stub(){

            @Override
            public void onPersistentVrStateChanged(boolean enabled) {
                mExecutor.execute(() -> mCallback.onPersistentVrStateChanged(enabled));
            }
        };
        final VrStateCallback mCallback;
        final Executor mExecutor;

        CallbackEntry(VrStateCallback callback2, Executor executor) {
            this.mCallback = callback2;
            this.mExecutor = executor;
        }
    }
}

