/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.accounts.Account;
import android.annotation.SystemApi;
import android.app.admin.DevicePolicyEventLogger;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import java.util.Objects;

@SystemApi
public class ManagedProfileProvisioningParams
implements Parcelable {
    private static final String LEAVE_ALL_SYSTEM_APPS_ENABLED_PARAM = "LEAVE_ALL_SYSTEM_APPS_ENABLED";
    private static final String ORGANIZATION_OWNED_PROVISIONING_PARAM = "ORGANIZATION_OWNED_PROVISIONING";
    private static final String ACCOUNT_TO_MIGRATE_PROVIDED_PARAM = "ACCOUNT_TO_MIGRATE_PROVIDED";
    private static final String KEEP_MIGRATED_ACCOUNT_PARAM = "KEEP_MIGRATED_ACCOUNT";
    private final ComponentName mProfileAdminComponentName;
    private final String mOwnerName;
    private final String mProfileName;
    private final Account mAccountToMigrate;
    private final boolean mLeaveAllSystemAppsEnabled;
    private final boolean mOrganizationOwnedProvisioning;
    private final boolean mKeepAccountOnMigration;
    private final PersistableBundle mAdminExtras;
    public static final Parcelable.Creator<ManagedProfileProvisioningParams> CREATOR = new Parcelable.Creator<ManagedProfileProvisioningParams>(){

        @Override
        public ManagedProfileProvisioningParams createFromParcel(Parcel in) {
            ComponentName componentName = in.readTypedObject(ComponentName.CREATOR);
            String ownerName = in.readString();
            String profileName = in.readString();
            Account account = in.readTypedObject(Account.CREATOR);
            boolean leaveAllSystemAppsEnabled = in.readBoolean();
            boolean organizationOwnedProvisioning = in.readBoolean();
            boolean keepAccountMigrated = in.readBoolean();
            PersistableBundle adminExtras = in.readPersistableBundle();
            return new ManagedProfileProvisioningParams(componentName, ownerName, profileName, account, leaveAllSystemAppsEnabled, organizationOwnedProvisioning, keepAccountMigrated, adminExtras);
        }

        public ManagedProfileProvisioningParams[] newArray(int size) {
            return new ManagedProfileProvisioningParams[size];
        }
    };

    private ManagedProfileProvisioningParams(ComponentName profileAdminComponentName, String ownerName, String profileName, Account accountToMigrate, boolean leaveAllSystemAppsEnabled, boolean organizationOwnedProvisioning, boolean keepAccountOnMigration, PersistableBundle adminExtras) {
        this.mProfileAdminComponentName = Objects.requireNonNull(profileAdminComponentName);
        this.mOwnerName = Objects.requireNonNull(ownerName);
        this.mProfileName = profileName;
        this.mAccountToMigrate = accountToMigrate;
        this.mLeaveAllSystemAppsEnabled = leaveAllSystemAppsEnabled;
        this.mOrganizationOwnedProvisioning = organizationOwnedProvisioning;
        this.mKeepAccountOnMigration = keepAccountOnMigration;
        this.mAdminExtras = adminExtras;
    }

    public ComponentName getProfileAdminComponentName() {
        return this.mProfileAdminComponentName;
    }

    public String getOwnerName() {
        return this.mOwnerName;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public Account getAccountToMigrate() {
        return this.mAccountToMigrate;
    }

    public boolean isLeaveAllSystemAppsEnabled() {
        return this.mLeaveAllSystemAppsEnabled;
    }

    public boolean isOrganizationOwnedProvisioning() {
        return this.mOrganizationOwnedProvisioning;
    }

    public boolean isKeepingAccountOnMigration() {
        return this.mKeepAccountOnMigration;
    }

    public PersistableBundle getAdminExtras() {
        return new PersistableBundle(this.mAdminExtras);
    }

    public void logParams(String callerPackage) {
        Objects.requireNonNull(callerPackage);
        this.logParam(callerPackage, LEAVE_ALL_SYSTEM_APPS_ENABLED_PARAM, this.mLeaveAllSystemAppsEnabled);
        this.logParam(callerPackage, ORGANIZATION_OWNED_PROVISIONING_PARAM, this.mOrganizationOwnedProvisioning);
        this.logParam(callerPackage, KEEP_MIGRATED_ACCOUNT_PARAM, this.mKeepAccountOnMigration);
        this.logParam(callerPackage, ACCOUNT_TO_MIGRATE_PROVIDED_PARAM, this.mAccountToMigrate != null);
    }

    private void logParam(String callerPackage, String param, boolean value2) {
        DevicePolicyEventLogger.createEvent(197).setStrings(callerPackage).setAdmin(this.mProfileAdminComponentName).setStrings(param).setBoolean(value2).write();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "ManagedProfileProvisioningParams{mProfileAdminComponentName=" + this.mProfileAdminComponentName + ", mOwnerName=" + this.mOwnerName + ", mProfileName=" + (this.mProfileName == null ? "null" : this.mProfileName) + ", mAccountToMigrate=" + (this.mAccountToMigrate == null ? "null" : this.mAccountToMigrate) + ", mLeaveAllSystemAppsEnabled=" + this.mLeaveAllSystemAppsEnabled + ", mOrganizationOwnedProvisioning=" + this.mOrganizationOwnedProvisioning + ", mKeepAccountOnMigration=" + this.mKeepAccountOnMigration + ", mAdminExtras=" + this.mAdminExtras + '}';
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mProfileAdminComponentName, flags);
        dest.writeString(this.mOwnerName);
        dest.writeString(this.mProfileName);
        dest.writeTypedObject(this.mAccountToMigrate, flags);
        dest.writeBoolean(this.mLeaveAllSystemAppsEnabled);
        dest.writeBoolean(this.mOrganizationOwnedProvisioning);
        dest.writeBoolean(this.mKeepAccountOnMigration);
        dest.writePersistableBundle(this.mAdminExtras);
    }

    public static class Builder {
        private final ComponentName mProfileAdminComponentName;
        private final String mOwnerName;
        private String mProfileName;
        private Account mAccountToMigrate;
        private boolean mLeaveAllSystemAppsEnabled;
        private boolean mOrganizationOwnedProvisioning;
        private boolean mKeepingAccountOnMigration;
        private PersistableBundle mAdminExtras;

        public Builder(ComponentName profileAdminComponentName, String ownerName) {
            Objects.requireNonNull(profileAdminComponentName);
            Objects.requireNonNull(ownerName);
            this.mProfileAdminComponentName = profileAdminComponentName;
            this.mOwnerName = ownerName;
        }

        public Builder setProfileName(String profileName) {
            this.mProfileName = profileName;
            return this;
        }

        public Builder setAccountToMigrate(Account accountToMigrate) {
            this.mAccountToMigrate = accountToMigrate;
            return this;
        }

        public Builder setLeaveAllSystemAppsEnabled(boolean leaveAllSystemAppsEnabled) {
            this.mLeaveAllSystemAppsEnabled = leaveAllSystemAppsEnabled;
            return this;
        }

        public Builder setOrganizationOwnedProvisioning(boolean organizationOwnedProvisioning) {
            this.mOrganizationOwnedProvisioning = organizationOwnedProvisioning;
            return this;
        }

        public Builder setKeepingAccountOnMigration(boolean keepingAccountOnMigration) {
            this.mKeepingAccountOnMigration = keepingAccountOnMigration;
            return this;
        }

        public Builder setAdminExtras(PersistableBundle adminExtras) {
            this.mAdminExtras = adminExtras != null ? new PersistableBundle(adminExtras) : new PersistableBundle();
            return this;
        }

        public ManagedProfileProvisioningParams build() {
            return new ManagedProfileProvisioningParams(this.mProfileAdminComponentName, this.mOwnerName, this.mProfileName, this.mAccountToMigrate, this.mLeaveAllSystemAppsEnabled, this.mOrganizationOwnedProvisioning, this.mKeepingAccountOnMigration, this.mAdminExtras != null ? this.mAdminExtras : new PersistableBundle());
        }
    }
}

