/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.util.Log;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class SystemUpdateInfo
implements Parcelable {
    private static final String TAG = "SystemUpdateInfo";
    public static final int SECURITY_PATCH_STATE_UNKNOWN = 0;
    public static final int SECURITY_PATCH_STATE_FALSE = 1;
    public static final int SECURITY_PATCH_STATE_TRUE = 2;
    private static final String ATTR_RECEIVED_TIME = "received-time";
    private static final String ATTR_SECURITY_PATCH_STATE = "security-patch-state";
    private static final String ATTR_ORIGINAL_BUILD = "original-build";
    private final long mReceivedTime;
    private final int mSecurityPatchState;
    public static final Parcelable.Creator<SystemUpdateInfo> CREATOR = new Parcelable.Creator<SystemUpdateInfo>(){

        @Override
        public SystemUpdateInfo createFromParcel(Parcel in) {
            return new SystemUpdateInfo(in);
        }

        public SystemUpdateInfo[] newArray(int size) {
            return new SystemUpdateInfo[size];
        }
    };

    private SystemUpdateInfo(long receivedTime, int securityPatchState) {
        this.mReceivedTime = receivedTime;
        this.mSecurityPatchState = securityPatchState;
    }

    private SystemUpdateInfo(Parcel in) {
        this.mReceivedTime = in.readLong();
        this.mSecurityPatchState = in.readInt();
    }

    public static SystemUpdateInfo of(long receivedTime) {
        return receivedTime == -1L ? null : new SystemUpdateInfo(receivedTime, 0);
    }

    public static SystemUpdateInfo of(long receivedTime, boolean isSecurityPatch) {
        return receivedTime == -1L ? null : new SystemUpdateInfo(receivedTime, isSecurityPatch ? 2 : 1);
    }

    public long getReceivedTime() {
        return this.mReceivedTime;
    }

    public int getSecurityPatchState() {
        return this.mSecurityPatchState;
    }

    public void writeToXml(TypedXmlSerializer out, String tag2) throws IOException {
        out.startTag(null, tag2);
        out.attributeLong(null, ATTR_RECEIVED_TIME, this.mReceivedTime);
        out.attributeInt(null, ATTR_SECURITY_PATCH_STATE, this.mSecurityPatchState);
        out.attribute(null, ATTR_ORIGINAL_BUILD, _Original_Build.FINGERPRINT);
        out.endTag(null, tag2);
    }

    public static SystemUpdateInfo readFromXml(TypedXmlPullParser parser) {
        String buildFingerprint = parser.getAttributeValue(null, ATTR_ORIGINAL_BUILD);
        if (!_Original_Build.FINGERPRINT.equals(buildFingerprint)) {
            return null;
        }
        try {
            long receivedTime = parser.getAttributeLong(null, ATTR_RECEIVED_TIME);
            int securityPatchState = parser.getAttributeInt(null, ATTR_SECURITY_PATCH_STATE);
            return new SystemUpdateInfo(receivedTime, securityPatchState);
        }
        catch (XmlPullParserException e) {
            Log.w(TAG, "Load xml failed", e);
            return null;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.getReceivedTime());
        dest.writeInt(this.getSecurityPatchState());
    }

    public String toString() {
        return String.format("SystemUpdateInfo (receivedTime = %d, securityPatchState = %s)", this.mReceivedTime, SystemUpdateInfo.securityPatchStateToString(this.mSecurityPatchState));
    }

    private static String securityPatchStateToString(int state) {
        switch (state) {
            case 1: {
                return "false";
            }
            case 2: {
                return "true";
            }
            case 0: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException("Unrecognized security patch state: " + state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemUpdateInfo that = (SystemUpdateInfo)o;
        return this.mReceivedTime == that.mReceivedTime && this.mSecurityPatchState == that.mSecurityPatchState;
    }

    public int hashCode() {
        return Objects.hash(this.mReceivedTime, this.mSecurityPatchState);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityPatchState {
    }
}

