/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.util.ArrayMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class AppSearchBatchResult<KeyType, ValueType> {
    private final Map<KeyType, ValueType> mSuccesses;
    private final Map<KeyType, AppSearchResult<ValueType>> mFailures;
    private final Map<KeyType, AppSearchResult<ValueType>> mAll;

    AppSearchBatchResult(Map<KeyType, ValueType> successes, Map<KeyType, AppSearchResult<ValueType>> failures, Map<KeyType, AppSearchResult<ValueType>> all) {
        this.mSuccesses = Objects.requireNonNull(successes);
        this.mFailures = Objects.requireNonNull(failures);
        this.mAll = Objects.requireNonNull(all);
    }

    public boolean isSuccess() {
        return this.mFailures.isEmpty();
    }

    public Map<KeyType, ValueType> getSuccesses() {
        return Collections.unmodifiableMap(this.mSuccesses);
    }

    public Map<KeyType, AppSearchResult<ValueType>> getFailures() {
        return Collections.unmodifiableMap(this.mFailures);
    }

    public Map<KeyType, AppSearchResult<ValueType>> getAll() {
        return Collections.unmodifiableMap(this.mAll);
    }

    public void checkSuccess() {
        if (!this.isSuccess()) {
            throw new IllegalStateException("AppSearchBatchResult has failures: " + this);
        }
    }

    public String toString() {
        return "{\n  successes: " + this.mSuccesses + "\n  failures: " + this.mFailures + "\n}";
    }

    public static class Builder<KeyType, ValueType> {
        private ArrayMap<KeyType, ValueType> mSuccesses = new ArrayMap();
        private ArrayMap<KeyType, AppSearchResult<ValueType>> mFailures = new ArrayMap();
        private ArrayMap<KeyType, AppSearchResult<ValueType>> mAll = new ArrayMap();
        private boolean mBuilt = false;

        public Builder<KeyType, ValueType> setSuccess(KeyType key, ValueType value2) {
            Objects.requireNonNull(key);
            this.resetIfBuilt();
            return this.setResult(key, AppSearchResult.newSuccessfulResult(value2));
        }

        public Builder<KeyType, ValueType> setFailure(KeyType key, int resultCode, String errorMessage) {
            Objects.requireNonNull(key);
            this.resetIfBuilt();
            return this.setResult(key, AppSearchResult.newFailedResult(resultCode, errorMessage));
        }

        public Builder<KeyType, ValueType> setResult(KeyType key, AppSearchResult<ValueType> result) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(result);
            this.resetIfBuilt();
            if (result.isSuccess()) {
                this.mSuccesses.put(key, result.getResultValue());
                this.mFailures.remove(key);
            } else {
                this.mFailures.put(key, result);
                this.mSuccesses.remove(key);
            }
            this.mAll.put(key, result);
            return this;
        }

        public AppSearchBatchResult<KeyType, ValueType> build() {
            this.mBuilt = true;
            return new AppSearchBatchResult<KeyType, ValueType>(this.mSuccesses, this.mFailures, this.mAll);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSuccesses = new ArrayMap<KeyType, ValueType>(this.mSuccesses);
                this.mFailures = new ArrayMap<KeyType, AppSearchResult<ValueType>>(this.mFailures);
                this.mAll = new ArrayMap<KeyType, AppSearchResult<ValueType>>(this.mAll);
                this.mBuilt = false;
            }
        }
    }
}

