/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSession;
import android.app.appsearch.GlobalSearchSession;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.internal.util.Preconditions;
import android.content.Context;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class AppSearchManager {
    private final IAppSearchManager mService;
    private final Context mContext;

    public AppSearchManager(Context context, IAppSearchManager service) {
        this.mContext = Objects.requireNonNull(context);
        this.mService = Objects.requireNonNull(service);
    }

    public void createSearchSession(SearchContext searchContext, Executor executor, Consumer<AppSearchResult<AppSearchSession>> callback2) {
        Objects.requireNonNull(searchContext);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        AppSearchSession.createSearchSession(searchContext, this.mService, this.mContext.getUser(), this.mContext.getAttributionSource(), executor, callback2);
    }

    public void createGlobalSearchSession(Executor executor, Consumer<AppSearchResult<GlobalSearchSession>> callback2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        GlobalSearchSession.createGlobalSearchSession(this.mService, this.mContext.getUser(), this.mContext.getAttributionSource(), executor, callback2);
    }

    public static class SearchContext {
        final String mDatabaseName;

        SearchContext(String databaseName) {
            this.mDatabaseName = Objects.requireNonNull(databaseName);
        }

        public String getDatabaseName() {
            return this.mDatabaseName;
        }

        public static class Builder {
            private final String mDatabaseName;
            private boolean mBuilt = false;

            public Builder(String databaseName) {
                Objects.requireNonNull(databaseName);
                Preconditions.checkArgument(!databaseName.contains("/"), "Database name cannot contain '/'");
                this.mDatabaseName = databaseName;
            }

            public SearchContext build() {
                Preconditions.checkState(!this.mBuilt, "Builder has already been used");
                this.mBuilt = true;
                return new SearchContext(this.mDatabaseName);
            }
        }
    }
}

