/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.Migrator;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.SetSchemaResponse;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchResultCallback;
import android.app.appsearch.exceptions.AppSearchException;
import android.content.AttributionSource;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class AppSearchMigrationHelper
implements Closeable {
    private final IAppSearchManager mService;
    private final AttributionSource mCallerAttributionSource;
    private final String mDatabaseName;
    private final UserHandle mUserHandle;
    private final File mMigratedFile;
    private final Set<String> mDestinationTypes;
    private boolean mAreDocumentsMigrated = false;

    AppSearchMigrationHelper(IAppSearchManager service, UserHandle userHandle, AttributionSource callerAttributionSource, String databaseName, Set<AppSearchSchema> newSchemas) throws IOException {
        this.mService = Objects.requireNonNull(service);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mCallerAttributionSource = Objects.requireNonNull(callerAttributionSource);
        this.mDatabaseName = Objects.requireNonNull(databaseName);
        this.mMigratedFile = File.createTempFile("appsearch", null);
        this.mDestinationTypes = new ArraySet<String>(newSchemas.size());
        for (AppSearchSchema newSchema : newSchemas) {
            this.mDestinationTypes.add(newSchema.getSchemaType());
        }
    }

    public void queryAndTransform(String schemaType, Migrator migrator, int currentVersion, int finalVersion) throws IOException, AppSearchException, InterruptedException, ExecutionException {
        File queryFile = File.createTempFile("appsearch", null);
        try (ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(queryFile, 0x20000000);){
            final CompletableFuture future = new CompletableFuture();
            this.mService.writeQueryResultsToFile(this.mCallerAttributionSource, this.mDatabaseName, fileDescriptor, "", new SearchSpec.Builder().addFilterSchemas(schemaType).setTermMatch(1).build().getBundle(), this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    future.complete(resultParcel.getResult());
                }
            });
            AppSearchResult result = (AppSearchResult)future.get();
            if (!result.isSuccess()) {
                throw new AppSearchException(result.getResultCode(), result.getErrorMessage());
            }
            this.readAndTransform(queryFile, migrator, currentVersion, finalVersion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            queryFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppSearchResult<SetSchemaResponse> putMigratedDocuments(SetSchemaResponse.Builder responseBuilder) {
        if (!this.mAreDocumentsMigrated) {
            return AppSearchResult.newSuccessfulResult(responseBuilder.build());
        }
        try (ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(this.mMigratedFile, 0x10000000);){
            final CompletableFuture future = new CompletableFuture();
            this.mService.putDocumentsFromFile(this.mCallerAttributionSource, this.mDatabaseName, fileDescriptor, this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    future.complete(resultParcel.getResult());
                }
            });
            AppSearchResult result = (AppSearchResult)future.get();
            if (!result.isSuccess()) {
                AppSearchResult<SetSchemaResponse> appSearchResult = AppSearchResult.newFailedResult(result);
                return appSearchResult;
            }
            List migratedFailureBundles = (List)result.getResultValue();
            for (int i = 0; i < migratedFailureBundles.size(); ++i) {
                responseBuilder.addMigrationFailure(new SetSchemaResponse.MigrationFailure((Bundle)migratedFailureBundles.get(i)));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (Throwable t) {
            AppSearchResult<SetSchemaResponse> appSearchResult = AppSearchResult.throwableToFailedResult(t);
            return appSearchResult;
        }
        finally {
            this.mMigratedFile.delete();
        }
        return AppSearchResult.newSuccessfulResult(responseBuilder.build());
    }

    private void readAndTransform(File file2, Migrator migrator, int currentVersion, int finalVersion) throws IOException, AppSearchException {
        try (DataInputStream inputStream = new DataInputStream(new FileInputStream(file2));
             DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(this.mMigratedFile, true));){
            while (true) {
                GenericDocument document;
                try {
                    document = AppSearchMigrationHelper.readDocumentFromInputStream(inputStream);
                }
                catch (EOFException e) {
                    break;
                }
                GenericDocument newDocument = currentVersion < finalVersion ? migrator.onUpgrade(currentVersion, finalVersion, document) : migrator.onDowngrade(currentVersion, finalVersion, document);
                if (!this.mDestinationTypes.contains(newDocument.getSchemaType())) {
                    throw new AppSearchException(7, "Receive a migrated document with schema type: " + newDocument.getSchemaType() + ". But the schema types doesn't exist in the request");
                }
                AppSearchMigrationHelper.writeBundleToOutputStream(outputStream, newDocument.getBundle());
            }
            this.mAreDocumentsMigrated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenericDocument readDocumentFromInputStream(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        if (length == 0) {
            throw new EOFException();
        }
        byte[] serializedMessage = new byte[length];
        inputStream.read(serializedMessage);
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(serializedMessage, 0, serializedMessage.length);
            parcel.setDataPosition(0);
            Bundle bundle = parcel.readBundle();
            GenericDocument genericDocument = new GenericDocument(bundle);
            return genericDocument;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBundleToOutputStream(DataOutputStream outputStream, Bundle bundle) throws IOException {
        Parcel parcel = Parcel.obtain();
        try {
            parcel.writeBundle(bundle);
            byte[] serializedMessage = parcel.marshall();
            outputStream.writeInt(serializedMessage.length);
            outputStream.write(serializedMessage);
        }
        finally {
            parcel.recycle();
        }
    }

    @Override
    public void close() throws IOException {
        this.mMigratedFile.delete();
    }
}

