/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.exceptions.IllegalSchemaException;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.util.BundleUtil;
import android.app.appsearch.util.IndentingStringBuilder;
import android.os.Bundle;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AppSearchSchema {
    private static final String SCHEMA_TYPE_FIELD = "schemaType";
    private static final String PROPERTIES_FIELD = "properties";
    private final Bundle mBundle;

    public AppSearchSchema(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.mBundle = bundle;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public String toString() {
        IndentingStringBuilder stringBuilder = new IndentingStringBuilder();
        this.appendAppSearchSchemaString(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendAppSearchSchemaString(IndentingStringBuilder builder2) {
        Objects.requireNonNull(builder2);
        builder2.append("{\n");
        builder2.increaseIndentLevel();
        builder2.append("schemaType: \"").append(this.getSchemaType()).append("\",\n");
        builder2.append("properties: [\n");
        PropertyConfig[] sortedProperties = this.getProperties().toArray(new PropertyConfig[0]);
        Arrays.sort(sortedProperties, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (int i = 0; i < sortedProperties.length; ++i) {
            PropertyConfig propertyConfig = sortedProperties[i];
            builder2.increaseIndentLevel();
            propertyConfig.appendPropertyConfigString(builder2);
            if (i != sortedProperties.length - 1) {
                builder2.append(",\n");
            }
            builder2.decreaseIndentLevel();
        }
        builder2.append("\n");
        builder2.append("]\n");
        builder2.decreaseIndentLevel();
        builder2.append("}");
    }

    public String getSchemaType() {
        return this.mBundle.getString(SCHEMA_TYPE_FIELD, "");
    }

    public List<PropertyConfig> getProperties() {
        ArrayList propertyBundles = this.mBundle.getParcelableArrayList(PROPERTIES_FIELD);
        if (propertyBundles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PropertyConfig> ret = new ArrayList<PropertyConfig>(propertyBundles.size());
        for (int i = 0; i < propertyBundles.size(); ++i) {
            ret.add(PropertyConfig.fromBundle((Bundle)propertyBundles.get(i)));
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppSearchSchema)) {
            return false;
        }
        AppSearchSchema otherSchema = (AppSearchSchema)other;
        if (!this.getSchemaType().equals(otherSchema.getSchemaType())) {
            return false;
        }
        return this.getProperties().equals(otherSchema.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaType(), this.getProperties());
    }

    public static class DocumentPropertyConfig
    extends PropertyConfig {
        private static final String SCHEMA_TYPE_FIELD = "schemaType";
        private static final String INDEX_NESTED_PROPERTIES_FIELD = "indexNestedProperties";

        DocumentPropertyConfig(Bundle bundle) {
            super(bundle);
        }

        public String getSchemaType() {
            return Objects.requireNonNull(this.mBundle.getString("schemaType"));
        }

        public boolean shouldIndexNestedProperties() {
            return this.mBundle.getBoolean(INDEX_NESTED_PROPERTIES_FIELD);
        }

        void appendDocumentPropertyConfigFields(IndentingStringBuilder builder2) {
            builder2.append("shouldIndexNestedProperties: ").append(this.shouldIndexNestedProperties()).append(",\n");
            builder2.append("schemaType: \"").append(this.getSchemaType()).append("\",\n");
        }

        public static class Builder {
            private final String mPropertyName;
            private final String mSchemaType;
            private int mCardinality = 2;
            private boolean mShouldIndexNestedProperties = false;

            public Builder(String propertyName, String schemaType) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
                this.mSchemaType = Objects.requireNonNull(schemaType);
            }

            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            public Builder setShouldIndexNestedProperties(boolean indexNestedProperties) {
                this.mShouldIndexNestedProperties = indexNestedProperties;
                return this;
            }

            public DocumentPropertyConfig build() {
                Bundle bundle = new Bundle();
                bundle.putString("name", this.mPropertyName);
                bundle.putInt("dataType", 6);
                bundle.putInt("cardinality", this.mCardinality);
                bundle.putBoolean(DocumentPropertyConfig.INDEX_NESTED_PROPERTIES_FIELD, this.mShouldIndexNestedProperties);
                bundle.putString("schemaType", this.mSchemaType);
                return new DocumentPropertyConfig(bundle);
            }
        }
    }

    public static class BytesPropertyConfig
    extends PropertyConfig {
        BytesPropertyConfig(Bundle bundle) {
            super(bundle);
        }

        public static class Builder {
            private final String mPropertyName;
            private int mCardinality = 2;

            public Builder(String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            public BytesPropertyConfig build() {
                Bundle bundle = new Bundle();
                bundle.putString("name", this.mPropertyName);
                bundle.putInt("dataType", 5);
                bundle.putInt("cardinality", this.mCardinality);
                return new BytesPropertyConfig(bundle);
            }
        }
    }

    public static class BooleanPropertyConfig
    extends PropertyConfig {
        BooleanPropertyConfig(Bundle bundle) {
            super(bundle);
        }

        public static class Builder {
            private final String mPropertyName;
            private int mCardinality = 2;

            public Builder(String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            public BooleanPropertyConfig build() {
                Bundle bundle = new Bundle();
                bundle.putString("name", this.mPropertyName);
                bundle.putInt("dataType", 4);
                bundle.putInt("cardinality", this.mCardinality);
                return new BooleanPropertyConfig(bundle);
            }
        }
    }

    public static class DoublePropertyConfig
    extends PropertyConfig {
        DoublePropertyConfig(Bundle bundle) {
            super(bundle);
        }

        public static class Builder {
            private final String mPropertyName;
            private int mCardinality = 2;

            public Builder(String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            public DoublePropertyConfig build() {
                Bundle bundle = new Bundle();
                bundle.putString("name", this.mPropertyName);
                bundle.putInt("dataType", 3);
                bundle.putInt("cardinality", this.mCardinality);
                return new DoublePropertyConfig(bundle);
            }
        }
    }

    public static class LongPropertyConfig
    extends PropertyConfig {
        LongPropertyConfig(Bundle bundle) {
            super(bundle);
        }

        public static class Builder {
            private final String mPropertyName;
            private int mCardinality = 2;

            public Builder(String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            public LongPropertyConfig build() {
                Bundle bundle = new Bundle();
                bundle.putString("name", this.mPropertyName);
                bundle.putInt("dataType", 2);
                bundle.putInt("cardinality", this.mCardinality);
                return new LongPropertyConfig(bundle);
            }
        }
    }

    public static class StringPropertyConfig
    extends PropertyConfig {
        private static final String INDEXING_TYPE_FIELD = "indexingType";
        private static final String TOKENIZER_TYPE_FIELD = "tokenizerType";
        public static final int INDEXING_TYPE_NONE = 0;
        public static final int INDEXING_TYPE_EXACT_TERMS = 1;
        public static final int INDEXING_TYPE_PREFIXES = 2;
        public static final int TOKENIZER_TYPE_NONE = 0;
        public static final int TOKENIZER_TYPE_PLAIN = 1;

        StringPropertyConfig(Bundle bundle) {
            super(bundle);
        }

        public int getIndexingType() {
            return this.mBundle.getInt(INDEXING_TYPE_FIELD);
        }

        public int getTokenizerType() {
            return this.mBundle.getInt(TOKENIZER_TYPE_FIELD);
        }

        void appendStringPropertyConfigFields(IndentingStringBuilder builder2) {
            switch (this.getIndexingType()) {
                case 0: {
                    builder2.append("indexingType: INDEXING_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder2.append("indexingType: INDEXING_TYPE_EXACT_TERMS,\n");
                    break;
                }
                case 2: {
                    builder2.append("indexingType: INDEXING_TYPE_PREFIXES,\n");
                    break;
                }
                default: {
                    builder2.append("indexingType: INDEXING_TYPE_UNKNOWN,\n");
                }
            }
            switch (this.getTokenizerType()) {
                case 0: {
                    builder2.append("tokenizerType: TOKENIZER_TYPE_NONE,\n");
                    break;
                }
                case 1: {
                    builder2.append("tokenizerType: TOKENIZER_TYPE_PLAIN,\n");
                    break;
                }
                default: {
                    builder2.append("tokenizerType: TOKENIZER_TYPE_UNKNOWN,\n");
                }
            }
        }

        public static class Builder {
            private final String mPropertyName;
            private int mCardinality = 2;
            private int mIndexingType = 0;
            private int mTokenizerType = 0;

            public Builder(String propertyName) {
                this.mPropertyName = Objects.requireNonNull(propertyName);
            }

            public Builder setCardinality(int cardinality) {
                Preconditions.checkArgumentInRange(cardinality, 1, 3, "cardinality");
                this.mCardinality = cardinality;
                return this;
            }

            public Builder setIndexingType(int indexingType) {
                Preconditions.checkArgumentInRange(indexingType, 0, 2, StringPropertyConfig.INDEXING_TYPE_FIELD);
                this.mIndexingType = indexingType;
                return this;
            }

            public Builder setTokenizerType(int tokenizerType) {
                Preconditions.checkArgumentInRange(tokenizerType, 0, 1, StringPropertyConfig.TOKENIZER_TYPE_FIELD);
                this.mTokenizerType = tokenizerType;
                return this;
            }

            public StringPropertyConfig build() {
                if (this.mTokenizerType == 0) {
                    Preconditions.checkState(this.mIndexingType == 0, "Cannot set TOKENIZER_TYPE_NONE with an indexing type other than INDEXING_TYPE_NONE.");
                } else {
                    Preconditions.checkState(this.mIndexingType != 0, "Cannot set TOKENIZER_TYPE_PLAIN  with INDEXING_TYPE_NONE.");
                }
                Bundle bundle = new Bundle();
                bundle.putString("name", this.mPropertyName);
                bundle.putInt("dataType", 1);
                bundle.putInt("cardinality", this.mCardinality);
                bundle.putInt(StringPropertyConfig.INDEXING_TYPE_FIELD, this.mIndexingType);
                bundle.putInt(StringPropertyConfig.TOKENIZER_TYPE_FIELD, this.mTokenizerType);
                return new StringPropertyConfig(bundle);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TokenizerType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IndexingType {
        }
    }

    public static abstract class PropertyConfig {
        static final String NAME_FIELD = "name";
        static final String DATA_TYPE_FIELD = "dataType";
        static final String CARDINALITY_FIELD = "cardinality";
        public static final int DATA_TYPE_STRING = 1;
        public static final int DATA_TYPE_LONG = 2;
        public static final int DATA_TYPE_DOUBLE = 3;
        public static final int DATA_TYPE_BOOLEAN = 4;
        public static final int DATA_TYPE_BYTES = 5;
        public static final int DATA_TYPE_DOCUMENT = 6;
        public static final int CARDINALITY_REPEATED = 1;
        public static final int CARDINALITY_OPTIONAL = 2;
        public static final int CARDINALITY_REQUIRED = 3;
        final Bundle mBundle;
        private Integer mHashCode;

        PropertyConfig(Bundle bundle) {
            this.mBundle = Objects.requireNonNull(bundle);
        }

        public String toString() {
            IndentingStringBuilder stringBuilder = new IndentingStringBuilder();
            this.appendPropertyConfigString(stringBuilder);
            return stringBuilder.toString();
        }

        void appendPropertyConfigString(IndentingStringBuilder builder2) {
            Objects.requireNonNull(builder2);
            builder2.append("{\n");
            builder2.increaseIndentLevel();
            builder2.append("name: \"").append(this.getName()).append("\",\n");
            if (this instanceof StringPropertyConfig) {
                ((StringPropertyConfig)this).appendStringPropertyConfigFields(builder2);
            } else if (this instanceof DocumentPropertyConfig) {
                ((DocumentPropertyConfig)this).appendDocumentPropertyConfigFields(builder2);
            }
            switch (this.getCardinality()) {
                case 1: {
                    builder2.append("cardinality: CARDINALITY_REPEATED,\n");
                    break;
                }
                case 2: {
                    builder2.append("cardinality: CARDINALITY_OPTIONAL,\n");
                    break;
                }
                case 3: {
                    builder2.append("cardinality: CARDINALITY_REQUIRED,\n");
                    break;
                }
                default: {
                    builder2.append("cardinality: CARDINALITY_UNKNOWN,\n");
                }
            }
            switch (this.getDataType()) {
                case 1: {
                    builder2.append("dataType: DATA_TYPE_STRING,\n");
                    break;
                }
                case 2: {
                    builder2.append("dataType: DATA_TYPE_LONG,\n");
                    break;
                }
                case 3: {
                    builder2.append("dataType: DATA_TYPE_DOUBLE,\n");
                    break;
                }
                case 4: {
                    builder2.append("dataType: DATA_TYPE_BOOLEAN,\n");
                    break;
                }
                case 5: {
                    builder2.append("dataType: DATA_TYPE_BYTES,\n");
                    break;
                }
                case 6: {
                    builder2.append("dataType: DATA_TYPE_DOCUMENT,\n");
                    break;
                }
                default: {
                    builder2.append("dataType: DATA_TYPE_UNKNOWN,\n");
                }
            }
            builder2.decreaseIndentLevel();
            builder2.append("}");
        }

        public String getName() {
            return this.mBundle.getString(NAME_FIELD, "");
        }

        public int getDataType() {
            return this.mBundle.getInt(DATA_TYPE_FIELD, -1);
        }

        public int getCardinality() {
            return this.mBundle.getInt(CARDINALITY_FIELD, 2);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertyConfig)) {
                return false;
            }
            PropertyConfig otherProperty = (PropertyConfig)other;
            return BundleUtil.deepEquals(this.mBundle, otherProperty.mBundle);
        }

        public int hashCode() {
            if (this.mHashCode == null) {
                this.mHashCode = BundleUtil.deepHashCode(this.mBundle);
            }
            return this.mHashCode;
        }

        public static PropertyConfig fromBundle(Bundle propertyBundle) {
            switch (propertyBundle.getInt(DATA_TYPE_FIELD)) {
                case 1: {
                    return new StringPropertyConfig(propertyBundle);
                }
                case 2: {
                    return new LongPropertyConfig(propertyBundle);
                }
                case 3: {
                    return new DoublePropertyConfig(propertyBundle);
                }
                case 4: {
                    return new BooleanPropertyConfig(propertyBundle);
                }
                case 5: {
                    return new BytesPropertyConfig(propertyBundle);
                }
                case 6: {
                    return new DocumentPropertyConfig(propertyBundle);
                }
            }
            throw new IllegalArgumentException("Unsupported property bundle of type " + propertyBundle.getInt(DATA_TYPE_FIELD) + "; contents: " + propertyBundle);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Cardinality {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataType {
        }
    }

    public static class Builder {
        private final String mSchemaType;
        private ArrayList<Bundle> mPropertyBundles = new ArrayList();
        private final Set<String> mPropertyNames = new ArraySet<String>();
        private boolean mBuilt = false;

        public Builder(String schemaType) {
            Objects.requireNonNull(schemaType);
            this.mSchemaType = schemaType;
        }

        public Builder addProperty(PropertyConfig propertyConfig) {
            Objects.requireNonNull(propertyConfig);
            this.resetIfBuilt();
            String name = propertyConfig.getName();
            if (!this.mPropertyNames.add(name)) {
                throw new IllegalSchemaException("Property defined more than once: " + name);
            }
            this.mPropertyBundles.add(propertyConfig.mBundle);
            return this;
        }

        public AppSearchSchema build() {
            Bundle bundle = new Bundle();
            bundle.putString(AppSearchSchema.SCHEMA_TYPE_FIELD, this.mSchemaType);
            bundle.putParcelableArrayList(AppSearchSchema.PROPERTIES_FIELD, this.mPropertyBundles);
            this.mBuilt = true;
            return new AppSearchSchema(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mPropertyBundles = new ArrayList<Bundle>(this.mPropertyBundles);
                this.mBuilt = false;
            }
        }
    }
}

