/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.util.ArraySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class RemoveByDocumentIdRequest {
    private final String mNamespace;
    private final Set<String> mIds;

    RemoveByDocumentIdRequest(String namespace, Set<String> ids) {
        this.mNamespace = namespace;
        this.mIds = ids;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.mIds);
    }

    public static class Builder {
        private final String mNamespace;
        private ArraySet<String> mIds = new ArraySet();
        private boolean mBuilt = false;

        public Builder(String namespace) {
            this.mNamespace = Objects.requireNonNull(namespace);
        }

        public Builder addIds(String ... ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            return this.addIds(Arrays.asList(ids));
        }

        public Builder addIds(Collection<String> ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            this.mIds.addAll(ids);
            return this;
        }

        public RemoveByDocumentIdRequest build() {
            this.mBuilt = true;
            return new RemoveByDocumentIdRequest(this.mNamespace, this.mIds);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mIds = new ArraySet<String>(this.mIds);
                this.mBuilt = false;
            }
        }
    }
}

