/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.GenericDocument;
import android.app.appsearch.internal.util.Preconditions;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchResult {
    static final String DOCUMENT_FIELD = "document";
    static final String MATCH_INFOS_FIELD = "matchInfos";
    static final String PACKAGE_NAME_FIELD = "packageName";
    static final String DATABASE_NAME_FIELD = "databaseName";
    static final String RANKING_SIGNAL_FIELD = "rankingSignal";
    private final Bundle mBundle;
    private GenericDocument mDocument;
    private List<MatchInfo> mMatchInfos;

    public SearchResult(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public GenericDocument getGenericDocument() {
        if (this.mDocument == null) {
            this.mDocument = new GenericDocument(Objects.requireNonNull(this.mBundle.getBundle(DOCUMENT_FIELD)));
        }
        return this.mDocument;
    }

    public List<MatchInfo> getMatchInfos() {
        if (this.mMatchInfos == null) {
            List matchBundles = Objects.requireNonNull(this.mBundle.getParcelableArrayList(MATCH_INFOS_FIELD));
            this.mMatchInfos = new ArrayList<MatchInfo>(matchBundles.size());
            for (int i = 0; i < matchBundles.size(); ++i) {
                MatchInfo matchInfo = new MatchInfo((Bundle)matchBundles.get(i), this.getGenericDocument());
                this.mMatchInfos.add(matchInfo);
            }
        }
        return this.mMatchInfos;
    }

    public String getPackageName() {
        return Objects.requireNonNull(this.mBundle.getString(PACKAGE_NAME_FIELD));
    }

    public String getDatabaseName() {
        return Objects.requireNonNull(this.mBundle.getString(DATABASE_NAME_FIELD));
    }

    public double getRankingSignal() {
        return this.mBundle.getDouble(RANKING_SIGNAL_FIELD);
    }

    public static class MatchRange {
        private final int mEnd;
        private final int mStart;

        public MatchRange(int start, int end) {
            if (start > end) {
                throw new IllegalArgumentException("Start point must be less than or equal to end point");
            }
            this.mStart = start;
            this.mEnd = end;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchRange)) {
                return false;
            }
            MatchRange otherMatchRange = (MatchRange)other;
            return this.getStart() == otherMatchRange.getStart() && this.getEnd() == otherMatchRange.getEnd();
        }

        public String toString() {
            return "MatchRange { start: " + this.mStart + " , end: " + this.mEnd + "}";
        }

        public int hashCode() {
            return Objects.hash(this.mStart, this.mEnd);
        }
    }

    public static class MatchInfo {
        private static final String PROPERTY_PATH_FIELD = "propertyPath";
        private static final String EXACT_MATCH_RANGE_LOWER_FIELD = "exactMatchRangeLower";
        private static final String EXACT_MATCH_RANGE_UPPER_FIELD = "exactMatchRangeUpper";
        private static final String SUBMATCH_RANGE_LOWER_FIELD = "submatchRangeLower";
        private static final String SUBMATCH_RANGE_UPPER_FIELD = "submatchRangeUpper";
        private static final String SNIPPET_RANGE_LOWER_FIELD = "snippetRangeLower";
        private static final String SNIPPET_RANGE_UPPER_FIELD = "snippetRangeUpper";
        private final String mPropertyPath;
        final Bundle mBundle;
        final GenericDocument mDocument;
        private String mFullText;
        private MatchRange mExactMatchRange;
        private MatchRange mSubmatchRange;
        private MatchRange mWindowRange;

        MatchInfo(Bundle bundle, GenericDocument document) {
            this.mBundle = Objects.requireNonNull(bundle);
            this.mDocument = document;
            this.mPropertyPath = Objects.requireNonNull(bundle.getString(PROPERTY_PATH_FIELD));
        }

        public String getPropertyPath() {
            return this.mPropertyPath;
        }

        public String getFullText() {
            if (this.mFullText == null) {
                Preconditions.checkState(this.mDocument != null, "Document has not been populated; this MatchInfo cannot be used yet");
                this.mFullText = MatchInfo.getPropertyValues(this.mDocument, this.mPropertyPath);
            }
            return this.mFullText;
        }

        public MatchRange getExactMatchRange() {
            if (this.mExactMatchRange == null) {
                this.mExactMatchRange = new MatchRange(this.mBundle.getInt(EXACT_MATCH_RANGE_LOWER_FIELD), this.mBundle.getInt(EXACT_MATCH_RANGE_UPPER_FIELD));
            }
            return this.mExactMatchRange;
        }

        public CharSequence getExactMatch() {
            return this.getSubstring(this.getExactMatchRange());
        }

        public MatchRange getSubmatchRange() {
            this.checkSubmatchSupported();
            if (this.mSubmatchRange == null) {
                this.mSubmatchRange = new MatchRange(this.mBundle.getInt(SUBMATCH_RANGE_LOWER_FIELD), this.mBundle.getInt(SUBMATCH_RANGE_UPPER_FIELD));
            }
            return this.mSubmatchRange;
        }

        public CharSequence getSubmatch() {
            this.checkSubmatchSupported();
            return this.getSubstring(this.getSubmatchRange());
        }

        public MatchRange getSnippetRange() {
            if (this.mWindowRange == null) {
                this.mWindowRange = new MatchRange(this.mBundle.getInt(SNIPPET_RANGE_LOWER_FIELD), this.mBundle.getInt(SNIPPET_RANGE_UPPER_FIELD));
            }
            return this.mWindowRange;
        }

        public CharSequence getSnippet() {
            return this.getSubstring(this.getSnippetRange());
        }

        private CharSequence getSubstring(MatchRange range) {
            return this.getFullText().substring(range.getStart(), range.getEnd());
        }

        private void checkSubmatchSupported() {
            if (!this.mBundle.containsKey(SUBMATCH_RANGE_LOWER_FIELD)) {
                throw new UnsupportedOperationException("Submatch is not supported with this backend/Android API level combination");
            }
        }

        private static String getPropertyValues(GenericDocument document, String propertyName) {
            String result = document.getPropertyString(propertyName);
            if (result == null) {
                throw new IllegalStateException("No content found for requested property path: " + propertyName);
            }
            return result;
        }

        public static class Builder {
            private final String mPropertyPath;
            private MatchRange mExactMatchRange = new MatchRange(0, 0);
            private MatchRange mSubmatchRange;
            private MatchRange mSnippetRange = new MatchRange(0, 0);

            public Builder(String propertyPath) {
                this.mPropertyPath = Objects.requireNonNull(propertyPath);
            }

            public Builder setExactMatchRange(MatchRange matchRange) {
                this.mExactMatchRange = Objects.requireNonNull(matchRange);
                return this;
            }

            public Builder setSubmatchRange(MatchRange matchRange) {
                this.mSubmatchRange = Objects.requireNonNull(matchRange);
                return this;
            }

            public Builder setSnippetRange(MatchRange matchRange) {
                this.mSnippetRange = Objects.requireNonNull(matchRange);
                return this;
            }

            public MatchInfo build() {
                Bundle bundle = new Bundle();
                bundle.putString(MatchInfo.PROPERTY_PATH_FIELD, this.mPropertyPath);
                bundle.putInt(MatchInfo.EXACT_MATCH_RANGE_LOWER_FIELD, this.mExactMatchRange.getStart());
                bundle.putInt(MatchInfo.EXACT_MATCH_RANGE_UPPER_FIELD, this.mExactMatchRange.getEnd());
                if (this.mSubmatchRange != null) {
                    bundle.putInt(MatchInfo.SUBMATCH_RANGE_LOWER_FIELD, this.mSubmatchRange.getStart());
                    bundle.putInt(MatchInfo.SUBMATCH_RANGE_UPPER_FIELD, this.mSubmatchRange.getEnd());
                }
                bundle.putInt(MatchInfo.SNIPPET_RANGE_LOWER_FIELD, this.mSnippetRange.getStart());
                bundle.putInt(MatchInfo.SNIPPET_RANGE_UPPER_FIELD, this.mSnippetRange.getEnd());
                return new MatchInfo(bundle, null);
            }
        }
    }

    public static class Builder {
        private final String mPackageName;
        private final String mDatabaseName;
        private ArrayList<Bundle> mMatchInfoBundles = new ArrayList();
        private GenericDocument mGenericDocument;
        private double mRankingSignal;
        private boolean mBuilt = false;

        public Builder(String packageName, String databaseName) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mDatabaseName = Objects.requireNonNull(databaseName);
        }

        public Builder setGenericDocument(GenericDocument document) {
            Objects.requireNonNull(document);
            this.resetIfBuilt();
            this.mGenericDocument = document;
            return this;
        }

        public Builder addMatchInfo(MatchInfo matchInfo) {
            Preconditions.checkState(matchInfo.mDocument == null, "This MatchInfo is already associated with a SearchResult and can't be reassigned");
            this.resetIfBuilt();
            this.mMatchInfoBundles.add(matchInfo.mBundle);
            return this;
        }

        public Builder setRankingSignal(double rankingSignal) {
            this.resetIfBuilt();
            this.mRankingSignal = rankingSignal;
            return this;
        }

        public SearchResult build() {
            Bundle bundle = new Bundle();
            bundle.putString(SearchResult.PACKAGE_NAME_FIELD, this.mPackageName);
            bundle.putString(SearchResult.DATABASE_NAME_FIELD, this.mDatabaseName);
            bundle.putBundle(SearchResult.DOCUMENT_FIELD, this.mGenericDocument.getBundle());
            bundle.putDouble(SearchResult.RANKING_SIGNAL_FIELD, this.mRankingSignal);
            bundle.putParcelableArrayList(SearchResult.MATCH_INFOS_FIELD, this.mMatchInfoBundles);
            this.mBuilt = true;
            return new SearchResult(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mMatchInfoBundles = new ArrayList<Bundle>(this.mMatchInfoBundles);
                this.mBuilt = false;
            }
        }
    }
}

