/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.app.appsearch.AppSearchResult;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class AppSearchResultParcel<ValueType>
implements Parcelable {
    private final AppSearchResult<ValueType> mResult;
    public static final Parcelable.Creator<AppSearchResultParcel<?>> CREATOR = new Parcelable.Creator<AppSearchResultParcel<?>>(){

        @Override
        public AppSearchResultParcel<?> createFromParcel(Parcel in) {
            return new AppSearchResultParcel(in);
        }

        public AppSearchResultParcel<?>[] newArray(int size) {
            return new AppSearchResultParcel[size];
        }
    };

    public AppSearchResultParcel(AppSearchResult<ValueType> result) {
        this.mResult = Objects.requireNonNull(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppSearchResultParcel(Parcel in) {
        byte[] dataBlob = in.readBlob();
        Parcel data = Parcel.obtain();
        try {
            data.unmarshall(dataBlob, 0, dataBlob.length);
            data.setDataPosition(0);
            this.mResult = AppSearchResultParcel.directlyReadFromParcel(data);
        }
        finally {
            data.recycle();
        }
    }

    static AppSearchResult directlyReadFromParcel(Parcel data) {
        int resultCode = data.readInt();
        Object resultValue = data.readValue(null);
        String errorMessage = data.readString();
        if (resultCode == 0) {
            return AppSearchResult.newSuccessfulResult(resultValue);
        }
        return AppSearchResult.newFailedResult(resultCode, errorMessage);
    }

    public AppSearchResult<ValueType> getResult() {
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte[] bytes;
        Parcel data = Parcel.obtain();
        try {
            AppSearchResultParcel.directlyWriteToParcel(data, this.mResult);
            bytes = data.marshall();
        }
        finally {
            data.recycle();
        }
        dest.writeBlob(bytes);
    }

    static void directlyWriteToParcel(Parcel data, AppSearchResult result) {
        data.writeInt(result.getResultCode());
        if (result.isSuccess()) {
            data.writeValue(result.getResultValue());
        } else {
            data.writeValue(null);
        }
        data.writeString(result.getErrorMessage());
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

