/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.internal.util;

import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class Preconditions {
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(messageTemplate, messageArgs));
        }
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T string2) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException();
        }
        return string2;
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T string2, Object errorMessage) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return string2;
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T string2, String messageTemplate, Object ... messageArgs) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException(String.format(messageTemplate, messageArgs));
        }
        return string2;
    }

    @Deprecated
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @Deprecated
    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String messageTemplate, Object ... messageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageTemplate, messageArgs));
        }
        return reference;
    }

    public static void checkState(boolean expression) {
        Preconditions.checkState(expression, null);
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void checkState(boolean expression, String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(messageTemplate, messageArgs));
        }
    }

    public static void checkCallAuthorization(boolean expression) {
        if (!expression) {
            throw new SecurityException("Calling identity is not authorized");
        }
    }

    public static void checkCallAuthorization(boolean expression, String message) {
        if (!expression) {
            throw new SecurityException(message);
        }
    }

    public static void checkCallAuthorization(boolean expression, String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new SecurityException(String.format(messageTemplate, messageArgs));
        }
    }

    public static void checkCallingUser(boolean expression) {
        if (!expression) {
            throw new SecurityException("Calling user is not authorized");
        }
    }

    public static int checkFlagsArgument(int requestedFlags, int allowedFlags) {
        if ((requestedFlags & allowedFlags) != requestedFlags) {
            throw new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(requestedFlags) + ", but only 0x" + Integer.toHexString(allowedFlags) + " are allowed");
        }
        return requestedFlags;
    }

    public static int checkArgumentNonnegative(int value2, String errorMessage) {
        if (value2 < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value2;
    }

    public static int checkArgumentNonnegative(int value2) {
        if (value2 < 0) {
            throw new IllegalArgumentException();
        }
        return value2;
    }

    public static long checkArgumentNonnegative(long value2) {
        if (value2 < 0L) {
            throw new IllegalArgumentException();
        }
        return value2;
    }

    public static long checkArgumentNonnegative(long value2, String errorMessage) {
        if (value2 < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value2;
    }

    public static int checkArgumentPositive(int value2, String errorMessage) {
        if (value2 <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value2;
    }

    public static float checkArgumentNonNegative(float value2, String errorMessage) {
        if (value2 < 0.0f) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value2;
    }

    public static float checkArgumentPositive(float value2, String errorMessage) {
        if (value2 <= 0.0f) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value2;
    }

    public static float checkArgumentFinite(float value2, String valueName) {
        if (Float.isNaN(value2)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (Float.isInfinite(value2)) {
            throw new IllegalArgumentException(valueName + " must not be infinite");
        }
        return value2;
    }

    public static float checkArgumentInRange(float value2, float lower, float upper, String valueName) {
        if (Float.isNaN(value2)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (value2 < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too low)", valueName, Float.valueOf(lower), Float.valueOf(upper)));
        }
        if (value2 > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too high)", valueName, Float.valueOf(lower), Float.valueOf(upper)));
        }
        return value2;
    }

    public static double checkArgumentInRange(double value2, double lower, double upper, String valueName) {
        if (Double.isNaN(value2)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (value2 < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too low)", valueName, lower, upper));
        }
        if (value2 > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too high)", valueName, lower, upper));
        }
        return value2;
    }

    public static int checkArgumentInRange(int value2, int lower, int upper, String valueName) {
        if (value2 < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", valueName, lower, upper));
        }
        if (value2 > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", valueName, lower, upper));
        }
        return value2;
    }

    public static long checkArgumentInRange(long value2, long lower, long upper, String valueName) {
        if (value2 < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", valueName, lower, upper));
        }
        if (value2 > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", valueName, lower, upper));
        }
        return value2;
    }

    public static <T> T[] checkArrayElementsNotNull(T[] value2, String valueName) {
        if (value2 == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        for (int i = 0; i < value2.length; ++i) {
            if (value2[i] != null) continue;
            throw new NullPointerException(String.format("%s[%d] must not be null", valueName, i));
        }
        return value2;
    }

    public static <C extends Collection<T>, T> C checkCollectionElementsNotNull(C value2, String valueName) {
        if (value2 == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        long ctr = 0L;
        for (T elem : value2) {
            if (elem == null) {
                throw new NullPointerException(String.format("%s[%d] must not be null", valueName, ctr));
            }
            ++ctr;
        }
        return value2;
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> value2, String valueName) {
        if (value2 == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        if (value2.isEmpty()) {
            throw new IllegalArgumentException(valueName + " is empty");
        }
        return value2;
    }

    public static byte[] checkByteArrayNotEmpty(byte[] value2, String valueName) {
        if (value2 == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        if (value2.length == 0) {
            throw new IllegalArgumentException(valueName + " is empty");
        }
        return value2;
    }

    public static String checkArgumentIsSupported(String[] supportedValues, String value2) {
        Preconditions.checkNotNull(value2);
        Preconditions.checkNotNull(supportedValues);
        if (!Preconditions.contains(supportedValues, value2)) {
            throw new IllegalArgumentException(value2 + "is not supported " + Arrays.toString(supportedValues));
        }
        return value2;
    }

    private static boolean contains(String[] values2, String value2) {
        if (values2 == null) {
            return false;
        }
        for (int i = 0; i < values2.length; ++i) {
            if (!Objects.equals(value2, values2[i])) continue;
            return true;
        }
        return false;
    }

    public static float[] checkArrayElementsInRange(float[] value2, float lower, float upper, String valueName) {
        Preconditions.checkNotNull(value2, "%s must not be null", valueName);
        for (int i = 0; i < value2.length; ++i) {
            float v = value2[i];
            if (Float.isNaN(v)) {
                throw new IllegalArgumentException(valueName + "[" + i + "] must not be NaN");
            }
            if (v < lower) {
                throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%f, %f] (too low)", valueName, i, Float.valueOf(lower), Float.valueOf(upper)));
            }
            if (!(v > upper)) continue;
            throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%f, %f] (too high)", valueName, i, Float.valueOf(lower), Float.valueOf(upper)));
        }
        return value2;
    }

    public static int[] checkArrayElementsInRange(int[] value2, int lower, int upper, String valueName) {
        Preconditions.checkNotNull(value2, "%s must not be null", valueName);
        for (int i = 0; i < value2.length; ++i) {
            int v = value2[i];
            if (v < lower) {
                throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%d, %d] (too low)", valueName, i, lower, upper));
            }
            if (v <= upper) continue;
            throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%d, %d] (too high)", valueName, i, lower, upper));
        }
        return value2;
    }
}

