/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.observer;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class DocumentChangeInfo {
    private final String mPackageName;
    private final String mDatabase;
    private final String mNamespace;
    private final String mSchemaName;
    private final Set<String> mChangedDocumentIds;

    public DocumentChangeInfo(String packageName, String database, String namespace, String schemaName, Set<String> changedDocumentIds) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabase = Objects.requireNonNull(database);
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mSchemaName = Objects.requireNonNull(schemaName);
        this.mChangedDocumentIds = Collections.unmodifiableSet(Objects.requireNonNull(changedDocumentIds));
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getDatabaseName() {
        return this.mDatabase;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getSchemaName() {
        return this.mSchemaName;
    }

    public Set<String> getChangedDocumentIds() {
        return this.mChangedDocumentIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentChangeInfo)) {
            return false;
        }
        DocumentChangeInfo that = (DocumentChangeInfo)o;
        return this.mPackageName.equals(that.mPackageName) && this.mDatabase.equals(that.mDatabase) && this.mNamespace.equals(that.mNamespace) && this.mSchemaName.equals(that.mSchemaName) && this.mChangedDocumentIds.equals(that.mChangedDocumentIds);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mDatabase, this.mNamespace, this.mSchemaName, this.mChangedDocumentIds);
    }

    public String toString() {
        return "DocumentChangeInfo{packageName='" + this.mPackageName + '\'' + ", database='" + this.mDatabase + '\'' + ", namespace='" + this.mNamespace + '\'' + ", schemaName='" + this.mSchemaName + '\'' + ", changedDocumentIds='" + this.mChangedDocumentIds + '\'' + '}';
    }
}

