/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.util;

import android.os.Bundle;
import android.os.Parcel;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Arrays;

public class BundleUtil {
    private BundleUtil() {
    }

    public static boolean deepEquals(Bundle one, Bundle two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.size() != two.size()) {
            return false;
        }
        if (!one.keySet().equals(two.keySet())) {
            return false;
        }
        for (String key : one.keySet()) {
            if (BundleUtil.bundleValueEquals(one.get(key), two.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean bundleValueEquals(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        if (one instanceof Bundle && two instanceof Bundle) {
            return BundleUtil.deepEquals((Bundle)one, (Bundle)two);
        }
        if (one instanceof int[] && two instanceof int[]) {
            return Arrays.equals((int[])one, (int[])two);
        }
        if (one instanceof byte[] && two instanceof byte[]) {
            return Arrays.equals((byte[])one, (byte[])two);
        }
        if (one instanceof char[] && two instanceof char[]) {
            return Arrays.equals((char[])one, (char[])two);
        }
        if (one instanceof long[] && two instanceof long[]) {
            return Arrays.equals((long[])one, (long[])two);
        }
        if (one instanceof float[] && two instanceof float[]) {
            return Arrays.equals((float[])one, (float[])two);
        }
        if (one instanceof short[] && two instanceof short[]) {
            return Arrays.equals((short[])one, (short[])two);
        }
        if (one instanceof double[] && two instanceof double[]) {
            return Arrays.equals((double[])one, (double[])two);
        }
        if (one instanceof boolean[] && two instanceof boolean[]) {
            return Arrays.equals((boolean[])one, (boolean[])two);
        }
        if (one instanceof Object[] && two instanceof Object[]) {
            Object[] arrayOne = (Object[])one;
            Object[] arrayTwo = (Object[])two;
            if (arrayOne.length != arrayTwo.length) {
                return false;
            }
            if (Arrays.equals(arrayOne, arrayTwo)) {
                return true;
            }
            for (int i = 0; i < arrayOne.length; ++i) {
                if (BundleUtil.bundleValueEquals(arrayOne[i], arrayTwo[i])) continue;
                return false;
            }
            return true;
        }
        if (one instanceof ArrayList && two instanceof ArrayList) {
            ArrayList listOne = (ArrayList)one;
            ArrayList listTwo = (ArrayList)two;
            if (listOne.size() != listTwo.size()) {
                return false;
            }
            for (int i = 0; i < listOne.size(); ++i) {
                if (BundleUtil.bundleValueEquals(listOne.get(i), listTwo.get(i))) continue;
                return false;
            }
            return true;
        }
        if (one instanceof SparseArray && two instanceof SparseArray) {
            SparseArray arrayOne = (SparseArray)one;
            SparseArray arrayTwo = (SparseArray)two;
            if (arrayOne.size() != arrayTwo.size()) {
                return false;
            }
            for (int i = 0; i < arrayOne.size(); ++i) {
                if (arrayOne.keyAt(i) == arrayTwo.keyAt(i) && BundleUtil.bundleValueEquals(arrayOne.valueAt(i), arrayTwo.valueAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int deepHashCode(Bundle bundle) {
        if (bundle == null) {
            return 0;
        }
        int[] hashCodes = new int[bundle.size() + 1];
        int hashCodeIdx = 0;
        Object[] keys = bundle.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        hashCodes[hashCodeIdx++] = Arrays.hashCode(keys);
        for (int keyIdx = 0; keyIdx < keys.length; ++keyIdx) {
            Object item;
            int j;
            int[] innerHashCodes;
            Object array2;
            Object value2 = bundle.get((String)keys[keyIdx]);
            if (value2 instanceof Bundle) {
                hashCodes[hashCodeIdx++] = BundleUtil.deepHashCode((Bundle)value2);
                continue;
            }
            if (value2 instanceof int[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((int[])value2);
                continue;
            }
            if (value2 instanceof byte[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((byte[])value2);
                continue;
            }
            if (value2 instanceof char[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((char[])value2);
                continue;
            }
            if (value2 instanceof long[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((long[])value2);
                continue;
            }
            if (value2 instanceof float[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((float[])value2);
                continue;
            }
            if (value2 instanceof short[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((short[])value2);
                continue;
            }
            if (value2 instanceof double[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((double[])value2);
                continue;
            }
            if (value2 instanceof boolean[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((boolean[])value2);
                continue;
            }
            if (value2 instanceof String[]) {
                hashCodes[hashCodeIdx++] = Arrays.hashCode((String[])value2);
                continue;
            }
            if (value2 instanceof Object[]) {
                array2 = (Object[])value2;
                innerHashCodes = new int[((Object[])array2).length];
                for (j = 0; j < ((Object)array2).length; ++j) {
                    if (array2[j] instanceof Bundle) {
                        innerHashCodes[j] = BundleUtil.deepHashCode((Bundle)array2[j]);
                        continue;
                    }
                    if (array2[j] == null) continue;
                    innerHashCodes[j] = array2[j].hashCode();
                }
                hashCodes[hashCodeIdx++] = Arrays.hashCode(innerHashCodes);
                continue;
            }
            if (value2 instanceof ArrayList) {
                ArrayList list = (ArrayList)value2;
                innerHashCodes = new int[list.size()];
                for (j = 0; j < innerHashCodes.length; ++j) {
                    item = list.get(j);
                    if (item instanceof Bundle) {
                        innerHashCodes[j] = BundleUtil.deepHashCode((Bundle)item);
                        continue;
                    }
                    if (item == null) continue;
                    innerHashCodes[j] = item.hashCode();
                }
                hashCodes[hashCodeIdx++] = Arrays.hashCode(innerHashCodes);
                continue;
            }
            if (value2 instanceof SparseArray) {
                array2 = (SparseArray)value2;
                innerHashCodes = new int[((SparseArray)array2).size() * 2];
                for (j = 0; j < ((SparseArray)array2).size(); ++j) {
                    innerHashCodes[j * 2] = ((SparseArray)array2).keyAt(j);
                    item = ((SparseArray)array2).valueAt(j);
                    if (item instanceof Bundle) {
                        innerHashCodes[j * 2 + 1] = BundleUtil.deepHashCode((Bundle)item);
                        continue;
                    }
                    if (item == null) continue;
                    innerHashCodes[j * 2 + 1] = item.hashCode();
                }
                hashCodes[hashCodeIdx++] = Arrays.hashCode(innerHashCodes);
                continue;
            }
            hashCodes[hashCodeIdx++] = value2.hashCode();
        }
        return Arrays.hashCode(hashCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle deepCopy(Bundle bundle) {
        Parcel parcel = Parcel.obtain();
        try {
            parcel.writeBundle(bundle);
            byte[] serializedMessage = parcel.marshall();
            parcel.unmarshall(serializedMessage, 0, serializedMessage.length);
            parcel.setDataPosition(0);
            Bundle bundle2 = parcel.readBundle();
            return bundle2;
        }
        finally {
            parcel.recycle();
        }
    }
}

