/*
 * Decompiled with CFR 0.152.
 */
package android.app.cloudsearch;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.cloudsearch.ICloudSearchManager;
import android.app.cloudsearch.ICloudSearchManagerCallback;
import android.app.cloudsearch.SearchRequest;
import android.app.cloudsearch.SearchResponse;
import android.os.RemoteException;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class CloudSearchManager {
    private final ICloudSearchManager mService;

    public CloudSearchManager(ICloudSearchManager service) {
        this.mService = service;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_CLOUDSEARCH")
    public void search(SearchRequest request, Executor callbackExecutor, CallBack callback2) {
        try {
            this.mService.search(Objects.requireNonNull(request), new CallBackWrapper(Objects.requireNonNull(request), Objects.requireNonNull(callback2), Objects.requireNonNull(callbackExecutor)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class CallBackWrapper
    extends ICloudSearchManagerCallback.Stub {
        private final SearchRequest mSearchRequest;
        private final CallBack mCallback;
        private final Executor mCallbackExecutor;

        CallBackWrapper(SearchRequest searchRequest, CallBack callback2, Executor callbackExecutor) {
            this.mSearchRequest = searchRequest;
            this.mCallback = callback2;
            this.mCallbackExecutor = callbackExecutor;
        }

        @Override
        public void onSearchSucceeded(SearchResponse searchResponse) {
            this.mCallbackExecutor.execute(() -> this.mCallback.onSearchSucceeded(this.mSearchRequest, searchResponse));
        }

        @Override
        public void onSearchFailed(SearchResponse searchResponse) {
            this.mCallbackExecutor.execute(() -> this.mCallback.onSearchFailed(this.mSearchRequest, searchResponse));
        }
    }

    public static interface CallBack {
        public void onSearchSucceeded(SearchRequest var1, SearchResponse var2);

        public void onSearchFailed(SearchRequest var1, SearchResponse var2);
    }
}

