/*
 * Decompiled with CFR 0.152.
 */
package android.app.cloudsearch;

import android.app.cloudsearch.SearchResponse;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICloudSearchManagerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.cloudsearch.ICloudSearchManagerCallback";

    public void onSearchSucceeded(SearchResponse var1) throws RemoteException;

    public void onSearchFailed(SearchResponse var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICloudSearchManagerCallback {
        static final int TRANSACTION_onSearchSucceeded = 1;
        static final int TRANSACTION_onSearchFailed = 2;

        public Stub() {
            this.attachInterface(this, ICloudSearchManagerCallback.DESCRIPTOR);
        }

        public static ICloudSearchManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICloudSearchManagerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICloudSearchManagerCallback) {
                return (ICloudSearchManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSearchSucceeded";
                }
                case 2: {
                    return "onSearchFailed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICloudSearchManagerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SearchResponse _arg0 = data.readTypedObject(SearchResponse.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSearchSucceeded(_arg0);
                    break;
                }
                case 2: {
                    SearchResponse _arg0 = data.readTypedObject(SearchResponse.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSearchFailed(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICloudSearchManagerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICloudSearchManagerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchSucceeded(SearchResponse response) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICloudSearchManagerCallback.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSearchFailed(SearchResponse response) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICloudSearchManagerCallback.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICloudSearchManagerCallback {
        @Override
        public void onSearchSucceeded(SearchResponse response) throws RemoteException {
        }

        @Override
        public void onSearchFailed(SearchResponse response) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

