/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.role.IOnRoleHoldersChangedListener;
import android.app.role.IRoleManager;
import android.app.role.OnRoleHoldersChangedListener;
import android.app.role.RoleControllerManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.SparseArray;
import androidx.annotation.RequiresApi;
import com.android.permission.jarjar.com.android.internal.annotations.GuardedBy;
import com.android.permission.jarjar.com.android.internal.util.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class RoleManager {
    public static final String ROLE_ASSISTANT = "android.app.role.ASSISTANT";
    public static final String ROLE_BROWSER = "android.app.role.BROWSER";
    public static final String ROLE_DIALER = "android.app.role.DIALER";
    public static final String ROLE_SMS = "android.app.role.SMS";
    public static final String ROLE_EMERGENCY = "android.app.role.EMERGENCY";
    public static final String ROLE_HOME = "android.app.role.HOME";
    public static final String ROLE_CALL_REDIRECTION = "android.app.role.CALL_REDIRECTION";
    public static final String ROLE_CALL_SCREENING = "android.app.role.CALL_SCREENING";
    @SystemApi
    public static final String ROLE_SYSTEM_WELLBEING = "android.app.role.SYSTEM_WELLBEING";
    @SystemApi
    public static final String ROLE_SYSTEM_SUPERVISION = "android.app.role.SYSTEM_SUPERVISION";
    @SystemApi
    public static final String ROLE_SYSTEM_ACTIVITY_RECOGNIZER = "android.app.role.SYSTEM_ACTIVITY_RECOGNIZER";
    @SystemApi
    public static final String ROLE_DEVICE_POLICY_MANAGEMENT = "android.app.role.DEVICE_POLICY_MANAGEMENT";
    @SystemApi
    public static final int MANAGE_HOLDERS_FLAG_DONT_KILL_APP = 1;
    public static final String ACTION_REQUEST_ROLE = "android.app.role.action.REQUEST_ROLE";
    public static final String PERMISSION_MANAGE_ROLES_FROM_CONTROLLER = "com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER";
    private final Context mContext;
    private final IRoleManager mService;
    @GuardedBy(value={"mListenersLock"})
    private final SparseArray<ArrayMap<OnRoleHoldersChangedListener, OnRoleHoldersChangedListenerDelegate>> mListeners = new SparseArray();
    private final Object mListenersLock = new Object();
    @GuardedBy(value={"mRoleControllerManagerLock"})
    private RoleControllerManager mRoleControllerManager;
    private final Object mRoleControllerManagerLock = new Object();

    public RoleManager(Context context, IRoleManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public Intent createRequestRoleIntent(String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Intent intent = new Intent(ACTION_REQUEST_ROLE);
        intent.setPackage(this.mContext.getPackageManager().getPermissionControllerPackageName());
        intent.putExtra("android.intent.extra.ROLE_NAME", roleName);
        return intent;
    }

    public boolean isRoleAvailable(String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            return this.mService.isRoleAvailable(roleName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isRoleHeld(String roleName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        try {
            return this.mService.isRoleHeld(roleName, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public List<String> getRoleHolders(String roleName) {
        return this.getRoleHoldersAsUser(roleName, Process.myUserHandle());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public List<String> getRoleHoldersAsUser(String roleName, UserHandle user) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            return this.mService.getRoleHoldersAsUser(roleName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void addRoleHolderAsUser(String roleName, String packageName, @ManageHoldersFlags int flags, UserHandle user, Executor executor, Consumer<Boolean> callback2) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        try {
            this.mService.addRoleHolderAsUser(roleName, packageName, flags, user.getIdentifier(), RoleManager.createRemoteCallback(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void removeRoleHolderAsUser(String roleName, String packageName, @ManageHoldersFlags int flags, UserHandle user, Executor executor, Consumer<Boolean> callback2) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        try {
            this.mService.removeRoleHolderAsUser(roleName, packageName, flags, user.getIdentifier(), RoleManager.createRemoteCallback(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void clearRoleHoldersAsUser(String roleName, @ManageHoldersFlags int flags, UserHandle user, Executor executor, Consumer<Boolean> callback2) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback2, "callback cannot be null");
        try {
            this.mService.clearRoleHoldersAsUser(roleName, flags, user.getIdentifier(), RoleManager.createRemoteCallback(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static RemoteCallback createRemoteCallback(Executor executor, Consumer<Boolean> callback2) {
        return new RemoteCallback(result -> executor.execute(() -> {
            boolean successful = result != null;
            long token = Binder.clearCallingIdentity();
            try {
                callback2.accept(successful);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_ROLE_HOLDERS")
    @SuppressLint(value={"SamShouldBeLast"})
    public void addOnRoleHoldersChangedListenerAsUser(Executor executor, OnRoleHoldersChangedListener listener2, UserHandle user) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener2, "listener cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        int userId = user.getIdentifier();
        Object object = this.mListenersLock;
        synchronized (object) {
            ArrayMap<OnRoleHoldersChangedListener, OnRoleHoldersChangedListenerDelegate> listeners = this.mListeners.get(userId);
            if (listeners == null) {
                listeners = new ArrayMap();
                this.mListeners.put(userId, listeners);
            } else if (listeners.containsKey(listener2)) {
                return;
            }
            OnRoleHoldersChangedListenerDelegate listenerDelegate = new OnRoleHoldersChangedListenerDelegate(executor, listener2);
            try {
                this.mService.addOnRoleHoldersChangedListenerAsUser(listenerDelegate, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            listeners.put(listener2, listenerDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.OBSERVE_ROLE_HOLDERS")
    @SuppressLint(value={"SamShouldBeLast"})
    public void removeOnRoleHoldersChangedListenerAsUser(OnRoleHoldersChangedListener listener2, UserHandle user) {
        Objects.requireNonNull(listener2, "listener cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        int userId = user.getIdentifier();
        Object object = this.mListenersLock;
        synchronized (object) {
            ArrayMap<OnRoleHoldersChangedListener, OnRoleHoldersChangedListenerDelegate> listeners = this.mListeners.get(userId);
            if (listeners == null) {
                return;
            }
            OnRoleHoldersChangedListenerDelegate listenerDelegate = listeners.get(listener2);
            if (listenerDelegate == null) {
                return;
            }
            try {
                this.mService.removeOnRoleHoldersChangedListenerAsUser(listenerDelegate, user.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            listeners.remove(listener2);
            if (listeners.isEmpty()) {
                this.mListeners.remove(userId);
            }
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public boolean isBypassingRoleQualification() {
        try {
            return this.mService.isBypassingRoleQualification();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.BYPASS_ROLE_QUALIFICATION")
    public void setBypassingRoleQualification(boolean bypassRoleQualification) {
        try {
            this.mService.setBypassingRoleQualification(bypassRoleQualification);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public void setRoleNamesFromController(List<String> roleNames) {
        Objects.requireNonNull(roleNames, "roleNames cannot be null");
        try {
            this.mService.setRoleNamesFromController(roleNames);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public boolean addRoleHolderFromController(String roleName, String packageName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        try {
            return this.mService.addRoleHolderFromController(roleName, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public boolean removeRoleHolderFromController(String roleName, String packageName) {
        Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        try {
            return this.mService.removeRoleHolderFromController(roleName, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER")
    public List<String> getHeldRolesFromController(String packageName) {
        Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
        try {
            return this.mService.getHeldRolesFromController(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=31)
    public String getBrowserRoleHolder(int userId) {
        try {
            return this.mService.getBrowserRoleHolder(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.SET_PREFERRED_APPLICATIONS")
    public boolean setBrowserRoleHolder(String packageName, int userId) {
        try {
            return this.mService.setBrowserRoleHolder(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=31)
    public String getSmsRoleHolder(int userId) {
        try {
            return this.mService.getSmsRoleHolder(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isRoleVisible(String roleName, Executor executor, Consumer<Boolean> callback2) {
        this.getRoleControllerManager().isRoleVisible(roleName, executor, callback2);
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isApplicationVisibleForRole(String roleName, String packageName, Executor executor, Consumer<Boolean> callback2) {
        this.getRoleControllerManager().isApplicationVisibleForRole(roleName, packageName, executor, callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleControllerManager getRoleControllerManager() {
        Object object = this.mRoleControllerManagerLock;
        synchronized (object) {
            if (this.mRoleControllerManager == null) {
                this.mRoleControllerManager = new RoleControllerManager(this.mContext);
            }
            return this.mRoleControllerManager;
        }
    }

    private static class OnRoleHoldersChangedListenerDelegate
    extends IOnRoleHoldersChangedListener.Stub {
        private final Executor mExecutor;
        private final OnRoleHoldersChangedListener mListener;

        OnRoleHoldersChangedListenerDelegate(Executor executor, OnRoleHoldersChangedListener listener2) {
            this.mExecutor = executor;
            this.mListener = listener2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRoleHoldersChanged(String roleName, int userId) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mListener.onRoleHoldersChanged(roleName, UserHandle.of(userId)));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static @interface ManageHoldersFlags {
    }
}

