/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.annotation.SystemApi;
import android.app.search.SearchAction;
import android.appwidget.AppWidgetProviderInfo;
import android.content.pm.ShortcutInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class SearchTarget
implements Parcelable {
    public static final int RESULT_TYPE_APPLICATION = 1;
    public static final int RESULT_TYPE_SHORTCUT = 2;
    public static final int RESULT_TYPE_SLICE = 4;
    public static final int RESULT_TYPE_WIDGETS = 8;
    public static final String LAYOUT_TYPE_ICON = "icon";
    public static final String LAYOUT_TYPE_ICON_ROW = "icon_row";
    public static final String LAYOUT_TYPE_SHORT_ICON_ROW = "short_icon_row";
    private final int mResultType;
    private final String mLayoutType;
    private final String mId;
    private String mParentId;
    private final float mScore;
    private final boolean mHidden;
    private final String mPackageName;
    private final UserHandle mUserHandle;
    private final SearchAction mSearchAction;
    private final ShortcutInfo mShortcutInfo;
    private final AppWidgetProviderInfo mAppWidgetProviderInfo;
    private final Uri mSliceUri;
    private final Bundle mExtras;
    public static final Parcelable.Creator<SearchTarget> CREATOR = new Parcelable.Creator<SearchTarget>(){

        @Override
        public SearchTarget createFromParcel(Parcel parcel) {
            return new SearchTarget(parcel);
        }

        public SearchTarget[] newArray(int size) {
            return new SearchTarget[size];
        }
    };

    private SearchTarget(Parcel parcel) {
        this.mResultType = parcel.readInt();
        this.mLayoutType = parcel.readString();
        this.mId = parcel.readString();
        this.mParentId = parcel.readString();
        this.mScore = parcel.readFloat();
        this.mHidden = parcel.readBoolean();
        this.mPackageName = parcel.readString();
        this.mUserHandle = UserHandle.of(parcel.readInt());
        this.mSearchAction = parcel.readTypedObject(SearchAction.CREATOR);
        this.mShortcutInfo = parcel.readTypedObject(ShortcutInfo.CREATOR);
        this.mAppWidgetProviderInfo = parcel.readTypedObject(AppWidgetProviderInfo.CREATOR);
        this.mSliceUri = parcel.readTypedObject(Uri.CREATOR);
        this.mExtras = parcel.readBundle(this.getClass().getClassLoader());
    }

    private SearchTarget(int resultType, String layoutType, String id2, String parentId, float score, boolean hidden, String packageName, UserHandle userHandle, SearchAction action2, ShortcutInfo shortcutInfo, Uri sliceUri, AppWidgetProviderInfo appWidgetProviderInfo, Bundle extras) {
        this.mResultType = resultType;
        this.mLayoutType = Objects.requireNonNull(layoutType);
        this.mId = Objects.requireNonNull(id2);
        this.mParentId = parentId;
        this.mScore = score;
        this.mHidden = hidden;
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mSearchAction = action2;
        this.mShortcutInfo = shortcutInfo;
        this.mAppWidgetProviderInfo = appWidgetProviderInfo;
        this.mSliceUri = sliceUri;
        this.mExtras = extras;
        int published = 0;
        if (this.mSearchAction != null) {
            ++published;
        }
        if (this.mShortcutInfo != null) {
            ++published;
        }
        if (this.mAppWidgetProviderInfo != null) {
            ++published;
        }
        if (this.mSliceUri != null) {
            ++published;
        }
        if (published > 1) {
            throw new IllegalStateException("Only one of SearchAction, ShortcutInfo, AppWidgetProviderInfo, SliceUri can be assigned in a SearchTarget.");
        }
    }

    public int getResultType() {
        return this.mResultType;
    }

    public String getLayoutType() {
        return this.mLayoutType;
    }

    public String getId() {
        return this.mId;
    }

    public String getParentId() {
        return this.mParentId;
    }

    public float getScore() {
        return this.mScore;
    }

    @Deprecated
    public boolean shouldHide() {
        return this.mHidden;
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    public ShortcutInfo getShortcutInfo() {
        return this.mShortcutInfo;
    }

    public AppWidgetProviderInfo getAppWidgetProviderInfo() {
        return this.mAppWidgetProviderInfo;
    }

    public Uri getSliceUri() {
        return this.mSliceUri;
    }

    public SearchAction getSearchAction() {
        return this.mSearchAction;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mResultType);
        parcel.writeString(this.mLayoutType);
        parcel.writeString(this.mId);
        parcel.writeString(this.mParentId);
        parcel.writeFloat(this.mScore);
        parcel.writeBoolean(this.mHidden);
        parcel.writeString(this.mPackageName);
        parcel.writeInt(this.mUserHandle.getIdentifier());
        parcel.writeTypedObject(this.mSearchAction, flags);
        parcel.writeTypedObject(this.mShortcutInfo, flags);
        parcel.writeTypedObject(this.mAppWidgetProviderInfo, flags);
        parcel.writeTypedObject(this.mSliceUri, flags);
        parcel.writeBundle(this.mExtras);
    }

    @SystemApi
    public static class Builder {
        private int mResultType;
        private String mLayoutType;
        private String mId;
        private String mParentId;
        private float mScore;
        private boolean mHidden;
        private String mPackageName;
        private UserHandle mUserHandle;
        private SearchAction mSearchAction;
        private ShortcutInfo mShortcutInfo;
        private Uri mSliceUri;
        private AppWidgetProviderInfo mAppWidgetProviderInfo;
        private Bundle mExtras;

        public Builder(int resultType, String layoutType, String id2) {
            this.mId = id2;
            this.mLayoutType = Objects.requireNonNull(layoutType);
            this.mResultType = resultType;
            this.mScore = 1.0f;
            this.mHidden = false;
        }

        public Builder setParentId(String parentId) {
            this.mParentId = Objects.requireNonNull(parentId);
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = Objects.requireNonNull(packageName);
            return this;
        }

        public Builder setUserHandle(UserHandle userHandle) {
            this.mUserHandle = Objects.requireNonNull(userHandle);
            return this;
        }

        public Builder setShortcutInfo(ShortcutInfo shortcutInfo) {
            this.mShortcutInfo = Objects.requireNonNull(shortcutInfo);
            if (this.mPackageName != null && !this.mPackageName.equals(shortcutInfo.getPackage())) {
                throw new IllegalStateException("SearchTarget packageName is different from shortcut's packageName");
            }
            this.mPackageName = shortcutInfo.getPackage();
            return this;
        }

        public Builder setAppWidgetProviderInfo(AppWidgetProviderInfo appWidgetProviderInfo) {
            this.mAppWidgetProviderInfo = Objects.requireNonNull(appWidgetProviderInfo);
            if (this.mPackageName != null && !this.mPackageName.equals(appWidgetProviderInfo.provider.getPackageName())) {
                throw new IllegalStateException("SearchTarget packageName is different from appWidgetProviderInfo's packageName");
            }
            return this;
        }

        public Builder setSliceUri(Uri sliceUri) {
            this.mSliceUri = sliceUri;
            return this;
        }

        public Builder setSearchAction(SearchAction searchAction) {
            this.mSearchAction = searchAction;
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        public Builder setScore(float score) {
            this.mScore = score;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.mHidden = hidden;
            return this;
        }

        @Deprecated
        public Builder setShouldHide(boolean shouldHide) {
            this.mHidden = shouldHide;
            return this;
        }

        public SearchTarget build() {
            return new SearchTarget(this.mResultType, this.mLayoutType, this.mId, this.mParentId, this.mScore, this.mHidden, this.mPackageName, this.mUserHandle, this.mSearchAction, this.mShortcutInfo, this.mSliceUri, this.mAppWidgetProviderInfo, this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SearchLayoutType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SearchResultType {
    }
}

