/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.ResultInfo;
import android.app.servertransaction.ActivityTransactionItem;
import android.app.servertransaction.ObjectPool;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;
import android.util.MergedConfiguration;
import com.android.internal.content.ReferrerIntent;
import java.util.List;
import java.util.Objects;

public class ActivityRelaunchItem
extends ActivityTransactionItem {
    private static final String TAG = "ActivityRelaunchItem";
    private List<ResultInfo> mPendingResults;
    private List<ReferrerIntent> mPendingNewIntents;
    private int mConfigChanges;
    private MergedConfiguration mConfig;
    private boolean mPreserveWindow;
    private ActivityThread.ActivityClientRecord mActivityClientRecord;
    public static final Parcelable.Creator<ActivityRelaunchItem> CREATOR = new Parcelable.Creator<ActivityRelaunchItem>(){

        @Override
        public ActivityRelaunchItem createFromParcel(Parcel in) {
            return new ActivityRelaunchItem(in);
        }

        public ActivityRelaunchItem[] newArray(int size) {
            return new ActivityRelaunchItem[size];
        }
    };

    @Override
    public void preExecute(ClientTransactionHandler client, IBinder token) {
        this.mActivityClientRecord = client.prepareRelaunchActivity(token, this.mPendingResults, this.mPendingNewIntents, this.mConfigChanges, this.mConfig, this.mPreserveWindow);
    }

    @Override
    public void execute(ClientTransactionHandler client, ActivityThread.ActivityClientRecord r, PendingTransactionActions pendingActions) {
        if (this.mActivityClientRecord == null) {
            return;
        }
        Trace.traceBegin(64L, "activityRestart");
        client.handleRelaunchActivity(this.mActivityClientRecord, pendingActions);
        Trace.traceEnd(64L);
    }

    @Override
    public void postExecute(ClientTransactionHandler client, IBinder token, PendingTransactionActions pendingActions) {
        ActivityThread.ActivityClientRecord r = this.getActivityClientRecord(client, token);
        client.reportRelaunch(r, pendingActions);
    }

    private ActivityRelaunchItem() {
    }

    public static ActivityRelaunchItem obtain(List<ResultInfo> pendingResults, List<ReferrerIntent> pendingNewIntents, int configChanges, MergedConfiguration config, boolean preserveWindow) {
        ActivityRelaunchItem instance2 = ObjectPool.obtain(ActivityRelaunchItem.class);
        if (instance2 == null) {
            instance2 = new ActivityRelaunchItem();
        }
        instance2.mPendingResults = pendingResults;
        instance2.mPendingNewIntents = pendingNewIntents;
        instance2.mConfigChanges = configChanges;
        instance2.mConfig = config;
        instance2.mPreserveWindow = preserveWindow;
        return instance2;
    }

    @Override
    public void recycle() {
        this.mPendingResults = null;
        this.mPendingNewIntents = null;
        this.mConfigChanges = 0;
        this.mConfig = null;
        this.mPreserveWindow = false;
        this.mActivityClientRecord = null;
        ObjectPool.recycle(this);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mPendingResults, flags);
        dest.writeTypedList(this.mPendingNewIntents, flags);
        dest.writeInt(this.mConfigChanges);
        dest.writeTypedObject(this.mConfig, flags);
        dest.writeBoolean(this.mPreserveWindow);
    }

    private ActivityRelaunchItem(Parcel in) {
        this.mPendingResults = in.createTypedArrayList(ResultInfo.CREATOR);
        this.mPendingNewIntents = in.createTypedArrayList(ReferrerIntent.CREATOR);
        this.mConfigChanges = in.readInt();
        this.mConfig = in.readTypedObject(MergedConfiguration.CREATOR);
        this.mPreserveWindow = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityRelaunchItem other = (ActivityRelaunchItem)o;
        return Objects.equals(this.mPendingResults, other.mPendingResults) && Objects.equals(this.mPendingNewIntents, other.mPendingNewIntents) && this.mConfigChanges == other.mConfigChanges && Objects.equals(this.mConfig, other.mConfig) && this.mPreserveWindow == other.mPreserveWindow;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mPendingResults);
        result = 31 * result + Objects.hashCode(this.mPendingNewIntents);
        result = 31 * result + this.mConfigChanges;
        result = 31 * result + Objects.hashCode(this.mConfig);
        result = 31 * result + (this.mPreserveWindow ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ActivityRelaunchItem{pendingResults=" + this.mPendingResults + ",pendingNewIntents=" + this.mPendingNewIntents + ",configChanges=" + this.mConfigChanges + ",config=" + this.mConfig + ",preserveWindow" + this.mPreserveWindow + "}";
    }
}

