/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ObjectPool;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;

public class StopActivityItem
extends ActivityLifecycleItem {
    private static final String TAG = "StopActivityItem";
    private int mConfigChanges;
    public static final Parcelable.Creator<StopActivityItem> CREATOR = new Parcelable.Creator<StopActivityItem>(){

        @Override
        public StopActivityItem createFromParcel(Parcel in) {
            return new StopActivityItem(in);
        }

        public StopActivityItem[] newArray(int size) {
            return new StopActivityItem[size];
        }
    };

    @Override
    public void execute(ClientTransactionHandler client, ActivityThread.ActivityClientRecord r, PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "activityStop");
        client.handleStopActivity(r, this.mConfigChanges, pendingActions, true, "STOP_ACTIVITY_ITEM");
        Trace.traceEnd(64L);
    }

    @Override
    public void postExecute(ClientTransactionHandler client, IBinder token, PendingTransactionActions pendingActions) {
        client.reportStop(pendingActions);
    }

    @Override
    public int getTargetState() {
        return 5;
    }

    private StopActivityItem() {
    }

    public static StopActivityItem obtain(int configChanges) {
        StopActivityItem instance2 = ObjectPool.obtain(StopActivityItem.class);
        if (instance2 == null) {
            instance2 = new StopActivityItem();
        }
        instance2.mConfigChanges = configChanges;
        return instance2;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.mConfigChanges = 0;
        ObjectPool.recycle(this);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConfigChanges);
    }

    private StopActivityItem(Parcel in) {
        this.mConfigChanges = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopActivityItem other = (StopActivityItem)o;
        return this.mConfigChanges == other.mConfigChanges;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mConfigChanges;
        return result;
    }

    public String toString() {
        return "StopActivityItem{configChanges=" + this.mConfigChanges + "}";
    }
}

