/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace.uitemplatedata;

import android.annotation.SystemApi;
import android.app.smartspace.SmartspaceUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class Icon
implements Parcelable {
    private final android.graphics.drawable.Icon mIcon;
    private final CharSequence mContentDescription;
    private final boolean mShouldTint;
    public static final Parcelable.Creator<Icon> CREATOR = new Parcelable.Creator<Icon>(){

        @Override
        public Icon createFromParcel(Parcel in) {
            return new Icon(in);
        }

        public Icon[] newArray(int size) {
            return new Icon[size];
        }
    };

    Icon(Parcel in) {
        this.mIcon = in.readTypedObject(android.graphics.drawable.Icon.CREATOR);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mShouldTint = in.readBoolean();
    }

    private Icon(android.graphics.drawable.Icon icon2, CharSequence contentDescription, boolean shouldTint) {
        this.mIcon = icon2;
        this.mContentDescription = contentDescription;
        this.mShouldTint = shouldTint;
    }

    public android.graphics.drawable.Icon getIcon() {
        return this.mIcon;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public boolean shouldTint() {
        return this.mShouldTint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Icon)) {
            return false;
        }
        Icon that = (Icon)o;
        return this.mIcon.toString().equals(that.mIcon.toString()) && SmartspaceUtils.isEqual(this.mContentDescription, that.mContentDescription) && this.mShouldTint == that.mShouldTint;
    }

    public int hashCode() {
        return Objects.hash(this.mIcon.toString(), this.mContentDescription, this.mShouldTint);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedObject(this.mIcon, flags);
        TextUtils.writeToParcel(this.mContentDescription, out, flags);
        out.writeBoolean(this.mShouldTint);
    }

    public String toString() {
        return "SmartspaceIcon{mIcon=" + this.mIcon + ", mContentDescription=" + this.mContentDescription + ", mShouldTint=" + this.mShouldTint + '}';
    }

    @SystemApi
    public static class Builder {
        private android.graphics.drawable.Icon mIcon;
        private CharSequence mContentDescription;
        private boolean mShouldTint;

        public Builder(android.graphics.drawable.Icon icon2) {
            this.mIcon = Objects.requireNonNull(icon2);
            this.mShouldTint = true;
        }

        public Builder setContentDescription(CharSequence contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        public Builder setShouldTint(boolean shouldTint) {
            this.mShouldTint = shouldTint;
            return this;
        }

        public Icon build() {
            return new Icon(this.mIcon, this.mContentDescription, this.mShouldTint);
        }
    }
}

