/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.SystemApi;
import android.app.time.TimeZoneConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@SystemApi
public class TimeZoneCapabilities
implements Parcelable {
    public static final Parcelable.Creator<TimeZoneCapabilities> CREATOR = new Parcelable.Creator<TimeZoneCapabilities>(){

        @Override
        public TimeZoneCapabilities createFromParcel(Parcel in) {
            return TimeZoneCapabilities.createFromParcel(in);
        }

        public TimeZoneCapabilities[] newArray(int size) {
            return new TimeZoneCapabilities[size];
        }
    };
    private final UserHandle mUserHandle;
    private final int mConfigureAutoDetectionEnabledCapability;
    private final int mConfigureGeoDetectionEnabledCapability;
    private final int mSuggestManualTimeZoneCapability;

    private TimeZoneCapabilities(Builder builder2) {
        this.mUserHandle = Objects.requireNonNull(builder2.mUserHandle);
        this.mConfigureAutoDetectionEnabledCapability = builder2.mConfigureAutoDetectionEnabledCapability;
        this.mConfigureGeoDetectionEnabledCapability = builder2.mConfigureGeoDetectionEnabledCapability;
        this.mSuggestManualTimeZoneCapability = builder2.mSuggestManualTimeZoneCapability;
    }

    private static TimeZoneCapabilities createFromParcel(Parcel in) {
        UserHandle userHandle = UserHandle.readFromParcel(in);
        return new Builder(userHandle).setConfigureAutoDetectionEnabledCapability(in.readInt()).setConfigureGeoDetectionEnabledCapability(in.readInt()).setSuggestManualTimeZoneCapability(in.readInt()).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        UserHandle.writeToParcel(this.mUserHandle, dest);
        dest.writeInt(this.mConfigureAutoDetectionEnabledCapability);
        dest.writeInt(this.mConfigureGeoDetectionEnabledCapability);
        dest.writeInt(this.mSuggestManualTimeZoneCapability);
    }

    public int getConfigureAutoDetectionEnabledCapability() {
        return this.mConfigureAutoDetectionEnabledCapability;
    }

    public int getConfigureGeoDetectionEnabledCapability() {
        return this.mConfigureGeoDetectionEnabledCapability;
    }

    public int getSuggestManualTimeZoneCapability() {
        return this.mSuggestManualTimeZoneCapability;
    }

    public TimeZoneConfiguration tryApplyConfigChanges(TimeZoneConfiguration config, TimeZoneConfiguration requestedChanges) {
        TimeZoneConfiguration.Builder newConfigBuilder = new TimeZoneConfiguration.Builder(config);
        if (requestedChanges.hasIsAutoDetectionEnabled()) {
            if (this.getConfigureAutoDetectionEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setAutoDetectionEnabled(requestedChanges.isAutoDetectionEnabled());
        }
        if (requestedChanges.hasIsGeoDetectionEnabled()) {
            if (this.getConfigureGeoDetectionEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setGeoDetectionEnabled(requestedChanges.isGeoDetectionEnabled());
        }
        return newConfigBuilder.build();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneCapabilities that = (TimeZoneCapabilities)o;
        return this.mUserHandle.equals(that.mUserHandle) && this.mConfigureAutoDetectionEnabledCapability == that.mConfigureAutoDetectionEnabledCapability && this.mConfigureGeoDetectionEnabledCapability == that.mConfigureGeoDetectionEnabledCapability && this.mSuggestManualTimeZoneCapability == that.mSuggestManualTimeZoneCapability;
    }

    public int hashCode() {
        return Objects.hash(this.mUserHandle, this.mConfigureAutoDetectionEnabledCapability, this.mConfigureGeoDetectionEnabledCapability, this.mSuggestManualTimeZoneCapability);
    }

    public String toString() {
        return "TimeZoneDetectorCapabilities{mUserHandle=" + this.mUserHandle + ", mConfigureAutoDetectionEnabledCapability=" + this.mConfigureAutoDetectionEnabledCapability + ", mConfigureGeoDetectionEnabledCapability=" + this.mConfigureGeoDetectionEnabledCapability + ", mSuggestManualTimeZoneCapability=" + this.mSuggestManualTimeZoneCapability + '}';
    }

    public static class Builder {
        private UserHandle mUserHandle;
        private int mConfigureAutoDetectionEnabledCapability;
        private int mConfigureGeoDetectionEnabledCapability;
        private int mSuggestManualTimeZoneCapability;

        public Builder(UserHandle userHandle) {
            this.mUserHandle = Objects.requireNonNull(userHandle);
        }

        public Builder(TimeZoneCapabilities capabilitiesToCopy) {
            Objects.requireNonNull(capabilitiesToCopy);
            this.mUserHandle = capabilitiesToCopy.mUserHandle;
            this.mConfigureAutoDetectionEnabledCapability = capabilitiesToCopy.mConfigureAutoDetectionEnabledCapability;
            this.mConfigureGeoDetectionEnabledCapability = capabilitiesToCopy.mConfigureGeoDetectionEnabledCapability;
            this.mSuggestManualTimeZoneCapability = capabilitiesToCopy.mSuggestManualTimeZoneCapability;
        }

        public Builder setConfigureAutoDetectionEnabledCapability(int value2) {
            this.mConfigureAutoDetectionEnabledCapability = value2;
            return this;
        }

        public Builder setConfigureGeoDetectionEnabledCapability(int value2) {
            this.mConfigureGeoDetectionEnabledCapability = value2;
            return this;
        }

        public Builder setSuggestManualTimeZoneCapability(int value2) {
            this.mSuggestManualTimeZoneCapability = value2;
            return this;
        }

        public TimeZoneCapabilities build() {
            this.verifyCapabilitySet(this.mConfigureAutoDetectionEnabledCapability, "configureAutoDetectionEnabledCapability");
            this.verifyCapabilitySet(this.mConfigureGeoDetectionEnabledCapability, "configureGeoDetectionEnabledCapability");
            this.verifyCapabilitySet(this.mSuggestManualTimeZoneCapability, "suggestManualTimeZoneCapability");
            return new TimeZoneCapabilities(this);
        }

        private void verifyCapabilitySet(int value2, String name) {
            if (value2 == 0) {
                throw new IllegalStateException(name + " not set");
            }
        }
    }
}

