/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.TimestampedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ManualTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<ManualTimeSuggestion> CREATOR = new Parcelable.Creator<ManualTimeSuggestion>(){

        @Override
        public ManualTimeSuggestion createFromParcel(Parcel in) {
            return ManualTimeSuggestion.createFromParcel(in);
        }

        public ManualTimeSuggestion[] newArray(int size) {
            return new ManualTimeSuggestion[size];
        }
    };
    private final TimestampedValue<Long> mUnixEpochTime;
    private ArrayList<String> mDebugInfo;

    public ManualTimeSuggestion(TimestampedValue<Long> unixEpochTime) {
        this.mUnixEpochTime = Objects.requireNonNull(unixEpochTime);
        Objects.requireNonNull(unixEpochTime.getValue());
    }

    private static ManualTimeSuggestion createFromParcel(Parcel in) {
        TimestampedValue unixEpochTime = in.readParcelable(null, TimestampedValue.class);
        ManualTimeSuggestion suggestion = new ManualTimeSuggestion(unixEpochTime);
        ArrayList<String> debugInfo = in.readArrayList(null, String.class);
        suggestion.mDebugInfo = debugInfo;
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mUnixEpochTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public TimestampedValue<Long> getUnixEpochTime() {
        return this.mUnixEpochTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.addAll(Arrays.asList(debugInfos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualTimeSuggestion that = (ManualTimeSuggestion)o;
        return Objects.equals(this.mUnixEpochTime, that.mUnixEpochTime);
    }

    public int hashCode() {
        return Objects.hash(this.mUnixEpochTime);
    }

    public String toString() {
        return "ManualTimeSuggestion{mUnixEpochTime=" + this.mUnixEpochTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }
}

