/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezone;

import android.app.timezone.ICallback;
import android.app.timezone.RulesState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IRulesManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.timezone.IRulesManager";

    public RulesState getRulesState() throws RemoteException;

    public int requestInstall(ParcelFileDescriptor var1, byte[] var2, ICallback var3) throws RemoteException;

    public int requestUninstall(byte[] var1, ICallback var2) throws RemoteException;

    public void requestNothing(byte[] var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRulesManager {
        static final int TRANSACTION_getRulesState = 1;
        static final int TRANSACTION_requestInstall = 2;
        static final int TRANSACTION_requestUninstall = 3;
        static final int TRANSACTION_requestNothing = 4;

        public Stub() {
            this.attachInterface(this, IRulesManager.DESCRIPTOR);
        }

        public static IRulesManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRulesManager.DESCRIPTOR);
            if (iin != null && iin instanceof IRulesManager) {
                return (IRulesManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getRulesState";
                }
                case 2: {
                    return "requestInstall";
                }
                case 3: {
                    return "requestUninstall";
                }
                case 4: {
                    return "requestNothing";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRulesManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    RulesState _result = this.getRulesState();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    byte[] _arg1 = data.createByteArray();
                    ICallback _arg2 = ICallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.requestInstall(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    byte[] _arg0 = data.createByteArray();
                    ICallback _arg1 = ICallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.requestUninstall(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    byte[] _arg0 = data.createByteArray();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.requestNothing(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IRulesManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRulesManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RulesState getRulesState() throws RemoteException {
                RulesState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRulesManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RulesState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestInstall(ParcelFileDescriptor distroFileDescriptor, byte[] checkToken, ICallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRulesManager.DESCRIPTOR);
                    _data.writeTypedObject(distroFileDescriptor, 0);
                    _data.writeByteArray(checkToken);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestUninstall(byte[] checkToken, ICallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRulesManager.DESCRIPTOR);
                    _data.writeByteArray(checkToken);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestNothing(byte[] token, boolean success) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRulesManager.DESCRIPTOR);
                    _data.writeByteArray(token);
                    _data.writeBoolean(success);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRulesManager {
        @Override
        public RulesState getRulesState() throws RemoteException {
            return null;
        }

        @Override
        public int requestInstall(ParcelFileDescriptor distroFileDescriptor, byte[] checkToken, ICallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public int requestUninstall(byte[] checkToken, ICallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public void requestNothing(byte[] token, boolean success) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

